/*=========================================================================

  Program:   ParaView
  Module:    vtkStreamingTerrainRepresentation.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class vtkStreamingTerrainRepresentation
 * @brief
 *
 */

#ifndef vtkStreamingTerrainRepresentation_h
#define vtkStreamingTerrainRepresentation_h

#include "vtkGeometryRepresentationWithFaces.h"
#include "vtkStreamingTerrainModule.h" // for exports

class VTKSTREAMINGTERRAIN_EXPORT vtkStreamingTerrainRepresentation : public vtkGeometryRepresentationWithFaces
{
public:
  static vtkStreamingTerrainRepresentation* New();
  vtkTypeMacro(vtkStreamingTerrainRepresentation, vtkGeometryRepresentationWithFaces);
  void PrintSelf(ostream& os, vtkIndent indent) override;

protected:
  vtkStreamingTerrainRepresentation();
  ~vtkStreamingTerrainRepresentation();

private:
  vtkStreamingTerrainRepresentation(const vtkStreamingTerrainRepresentation&) = delete;
  void operator=(const vtkStreamingTerrainRepresentation&) = delete;
};

#endif
