/*=========================================================================

  Program:   ParaView
  Module:    vtkStreamingTerrainRepresentation.cxx

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkStreamingTerrainRepresentation.h"

#include "vtkObjectFactory.h"
#include "vtkPVLODActor.h"
#include "vtkStreamingTerrainMapper.h"

vtkStandardNewMacro(vtkStreamingTerrainRepresentation);
//----------------------------------------------------------------------------
vtkStreamingTerrainRepresentation::vtkStreamingTerrainRepresentation()
{
  vtkSmartPointer<vtkMapper> mapper;
  mapper.TakeReference(this->Mapper);

  this->Mapper = vtkStreamingTerrainMapper::New();
  this->Actor->SetMapper(this->Mapper);
}

//----------------------------------------------------------------------------
vtkStreamingTerrainRepresentation::~vtkStreamingTerrainRepresentation()
{
}

//----------------------------------------------------------------------------
void vtkStreamingTerrainRepresentation::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}
