/*=========================================================================

  Program:   ParaView
  Module:    vtkStreamingTerrainMapper.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class vtkStreamingTerrainMapper
 * @brief
 *
 */

#ifndef vtkStreamingTerrainMapper_h
#define vtkStreamingTerrainMapper_h

#include "vtkCompositePolyDataMapper2.h"
#include "vtkStreamingTerrainModule.h"

class VTKSTREAMINGTERRAIN_EXPORT vtkStreamingTerrainMapper : public vtkCompositePolyDataMapper2
{
public:
  static vtkStreamingTerrainMapper* New();
  vtkTypeMacro(vtkStreamingTerrainMapper, vtkCompositePolyDataMapper2);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  void Render(vtkRenderer* ren, vtkActor* actor) override;

protected:
  vtkStreamingTerrainMapper();
  ~vtkStreamingTerrainMapper();

private:
  vtkStreamingTerrainMapper(const vtkStreamingTerrainMapper&) = delete;
  void operator=(const vtkStreamingTerrainMapper&) = delete;
};

#endif
