/*=========================================================================

  Program:   ParaView
  Module:    vtkReaderWithMetaData.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class vtkReaderWithMetaData
 * @brief
 *
 * A dummy reader that doesn't read anything, but shows how a reader can be
 * setup which has properties whose default values (and range domain) can be
 * filled using meta-data potentially read from the file.
 *
 */

#ifndef vtkReaderWithMetaData_h
#define vtkReaderWithMetaData_h

#include "vtkPolyDataAlgorithm.h"
#include <string> // needed for std::string

class vtkReaderWithMetaData : public vtkPolyDataAlgorithm
{
public:
  static vtkReaderWithMetaData* New();
  vtkTypeMacro(vtkReaderWithMetaData, vtkPolyDataAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent);

  vtkSetStringMacro(FileName);
  vtkGetStringMacro(FileName);

  vtkGetMacro(IntVariable, int);
  vtkSetMacro(IntVariable, int);

  vtkGetMacro(DoubleVariable, double);
  vtkSetMacro(DoubleVariable, double);

  vtkGetMacro(StringVariable, std::string);
  vtkSetMacro(StringVariable, std::string);

  vtkGetVector2Macro(IntVariable2Range, int);
  vtkSetVector2Macro(IntVariable2Range, int);

  vtkGetMacro(IntVariable2, int);
  vtkSetMacro(IntVariable2, int);

protected:
  vtkReaderWithMetaData();
  ~vtkReaderWithMetaData();

  /**
   * must read all meta-data in this method, not in request-data.
   */
  int RequestInformation(vtkInformation* request, vtkInformationVector** inputVector,
    vtkInformationVector* outputVector) VTK_OVERRIDE;
  int RequestData(vtkInformation* request, vtkInformationVector** inputVector,
    vtkInformationVector* outputVector) VTK_OVERRIDE;

  bool ReadMetaData();

private:
  vtkReaderWithMetaData(const vtkReaderWithMetaData&) VTK_DELETE_FUNCTION;
  void operator=(const vtkReaderWithMetaData&) VTK_DELETE_FUNCTION;

  char* FileName;
  int IntVariable;
  int DoubleVariable;
  std::string StringVariable;

  int IntVariable2;
  int IntVariable2Range[2];

  std::string LastFileName;
};

#endif
