/*=========================================================================

  Program:   ParaView
  Module:    vtkReaderWithMetaData.cxx

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkReaderWithMetaData.h"

#include "vtkObjectFactory.h"

vtkStandardNewMacro(vtkReaderWithMetaData);
//----------------------------------------------------------------------------
vtkReaderWithMetaData::vtkReaderWithMetaData()
  : FileName(nullptr)
  , IntVariable(0)
  , DoubleVariable(0.0)
  , StringVariable("Empty")
  , IntVariable2(0)
  , IntVariable2Range{ 0, 0 }
{
  this->SetNumberOfInputPorts(0);
}

//----------------------------------------------------------------------------
vtkReaderWithMetaData::~vtkReaderWithMetaData()
{
  this->SetFileName(nullptr);
}

//----------------------------------------------------------------------------
int vtkReaderWithMetaData::RequestInformation(
  vtkInformation* request, vtkInformationVector** inputVector, vtkInformationVector* outputVector)
{
  std::string sFileName = this->FileName ? std::string(this->FileName) : std::string();
  if (sFileName != this->LastFileName)
  {
    this->LastFileName = sFileName;
    return this->ReadMetaData();
  }
  return 1;
}

//----------------------------------------------------------------------------
int vtkReaderWithMetaData::RequestData(
  vtkInformation* request, vtkInformationVector** inputVector, vtkInformationVector* outputVector)
{
  return 1;
}

//----------------------------------------------------------------------------
bool vtkReaderWithMetaData::ReadMetaData()
{
  // This is the method where you can can read some parts of the file to fill up
  // meta-data variables.

  // I am just going to makeup values in this example.
  this->IntVariable = this->IntVariable + 10;
  this->DoubleVariable = this->DoubleVariable + 20.0;
  this->StringVariable = "Some string";

  this->IntVariable2Range[0] = 10;
  this->IntVariable2Range[1] = 100;

  // NOTE: Don't call the Set.. methods here. One should not call
  // `this->Modified()` (which the Set... methods do) in any of the pipeline
  // passes (which in this case is RequestInformation).
  return true;
}

//----------------------------------------------------------------------------
void vtkReaderWithMetaData::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}
