/*=========================================================================

  Program:   ParaView
  Module:    vtkPythonObservableWrapper.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkPythonObservableWrapper
 * @brief   Wrap methods that returns rxcpp observables to asyncio.future
 */

#ifndef vtkPythonObservableWrapper_h
#define vtkPythonObservableWrapper_h

#include "vtkPython.h" // include first

#include "vtkRemotingPythonAsyncCoreModule.h" //needed for exports

#include <string> // for std::string

class vtkObject;

class VTKREMOTINGPYTHONASYNCCORE_EXPORT vtkPythonObservableWrapper
{
public:
  static PyObject* GetFuture(vtkObject* object, std::string methodName, PyObject* args = nullptr);
  static PyObject* GetIterator(vtkObject* object, std::string methodName, PyObject* args = nullptr);
};
#endif
