import paraview.modules.vtkRemotingPythonAsyncCore as asyncCore
from paraview.modules.vtkRemotingServerManager import vtkPVApplication
import asyncio
from timeit import default_timer as timer

loop = asyncCore.vtkPythonRunLoop.GetInstance()


async def main():
    assert loop.IsAsyncInitialized() == True
    assert loop.HasRunningLoop() == False
    loop.AcquireRunningLoopFromPython()
    assert loop.HasRunningLoop() == True
    f = asyncCore.vtkPythonObservableWrapper.GetFuture(
        vtkPVApplication.GetInstance(), "CreateBuiltinSession"
    )
    await f
    assert f.done() == True
    assert f.result() == 1

    Object = asyncCore.vtkObservableExamplePython()

    iterator = asyncCore.vtkPythonObservableWrapper.GetIterator(Object, "GetObservable")

    start = timer()
    async for x in iterator:
        now = timer()
        print(f"{x} {now-start:.3f}ms")
        start = now


asyncio.run(main())
