/*
 * Copyright 2012 SciberQuest Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  * Neither name of SciberQuest Inc. nor the names of any contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "pqSQFieldTracer.h"

#include <QCheckBox>
#include <QWidget>

#include <iostream>

//-----------------------------------------------------------------------------
pqSQFieldTracer::pqSQFieldTracer(pqProxy* pxy, QWidget* p)
  : pqAutoGeneratedObjectPanel(pxy, p)
{
#if defined pqSQFieldTracerDEBUG
  std::cerr << ":::::pqSQFieldTracer::pqSQFieldTracer" << std::endl;
#endif

  // master and worker block sizes are only relevant if
  // dynamic scheduling is selected. If it is not selected
  // then disable master, and worker block entries.

  QCheckBox* dynSched = this->findChild<QCheckBox*>("UseDynamicScheduler");

  QWidget* masterBlock = this->findChild<QWidget*>("MasterBlockSize");
  QWidget* workerBlock = this->findChild<QWidget*>("WorkerBlockSize");

  // disable signals during construction. PV 3.16 will create/destroy
  // the panel as the object is selected/unselected in the browser.
  this->blockSignals(true);
  dynSched->blockSignals(true);
  masterBlock->blockSignals(true);
  workerBlock->blockSignals(true);

  // initialize based on current state, set by PV SM.
  if (!dynSched->isChecked())
  {
    masterBlock->setEnabled(false);
    workerBlock->setEnabled(false);
  }

  // sync dyanmic load balancing toggle and its assoiciated items
  connect(dynSched, SIGNAL(clicked(bool)), masterBlock, SLOT(setEnabled(bool)));
  connect(dynSched, SIGNAL(clicked(bool)), workerBlock, SLOT(setEnabled(bool)));

  // enable signals now that things are setup.
  this->blockSignals(false);
  dynSched->blockSignals(false);
  masterBlock->blockSignals(false);
  workerBlock->blockSignals(false);
}

//-----------------------------------------------------------------------------
void pqSQFieldTracer::accept()
{
#if defined pqSQFieldTracerDEBUG
  std::cerr << ":::::pqSQFieldTracer::accept" << std::endl;
#endif

  /* -- I don't recall why this was done, and I don't see
        a good reason for it now.

  // dynamic scheduling can only be selected prior to the
  // first apply, because of some technicallity in the way
  // PV pipeline executes. Prevent changes after first
  // apply.

  QCheckBox *dynSched
    = this->findChild<QCheckBox*>("UseDynamicScheduler");

  dynSched->setEnabled(false);
  */

  this->pqAutoGeneratedObjectPanel::accept();
}
