// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

#![deny(missing_docs)]

//! Verify, route, and write webhooks to a location on disk.
//!
//! This crate handles incoming webhook contents and using HTTP headers and the contents of the
//! webhook itself to determine whether it is a valid webhook or not and route it to a file on disk
//! with a classification as to what kind of webhook it is.

#[macro_use]
extern crate log;

#[macro_use]
extern crate serde_derive;

#[macro_use]
extern crate serde_json;

mod crates {
    // private
    pub extern crate chrono;
    pub extern crate hex;
    pub extern crate itertools;
    // pub extern crate log;
    pub extern crate rand;
    pub extern crate ring;
    pub extern crate serde;
    pub extern crate serde_json;
    pub extern crate thiserror;

    // public
    pub extern crate http;

    #[cfg(test)]
    pub extern crate log;
    #[cfg(test)]
    pub extern crate tempdir;
}

mod config;
mod handler;
mod router;

pub use config::Config;
pub use router::Router;

#[cfg(test)]
mod test_utils;
