// © Kitware, Inc. See license.md for details.
#ifndef token_Compiler_h
#define token_Compiler_h

#if !defined(_MSC_VER) && !defined(__INTEL_COMPILER) && !defined(__PGI) && !defined(__clang__) && defined(__GNUC__)
/* Several compilers pretend to be GCC but have minor differences. To
 * compensate for that, we checked for those compilers first above. */
#  define token_GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)

// gcc 4.8.5 and earlier require a space after a string-literal-operator's double-quotes
// and before the name of the operator. C++23 deprecates a space between them. Test which
// we need to make things work.
#  if token_GCC_VERSION <= 40805
#    define token_SPACE_BEFORE_SUFFIX 1
#  else
#    define token_SPACE_BEFORE_SUFFIX 0
#  endif
#endif

#endif // token_Compiler_h
