#!/bin/sh

set -e

apt update

# Rustup
apt install -y \
    rustup
rustup set profile minimal

readonly toolchains="
    stable
    1.85
"

# rustfmt
for toolchain in $toolchains; do
    rustup toolchain install "$toolchain"
    rustup component add --toolchain "$toolchain" rustfmt
done

apt clean
