// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

//! Project star API endpoints.
//!
//! These endpoints are used for querying and starring a project.

mod star;
mod starrers;
mod unstar;

pub use self::star::StarProject;
pub use self::star::StarProjectBuilder;
pub use self::star::StarProjectBuilderError;

pub use self::starrers::Starrers;
pub use self::starrers::StarrersBuilder;
pub use self::starrers::StarrersBuilderError;

pub use self::unstar::UnstarProject;
pub use self::unstar::UnstarProjectBuilder;
pub use self::unstar::UnstarProjectBuilderError;
