// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

//! Project job artifact API endpoints.
//!
//! These endpoints are used for working with artifacts of jobs.

mod delete;
mod download;
mod download_by_ref;
mod download_file;
mod download_file_by_ref;
mod keep;

pub use self::delete::DeleteJobArtifacts;
pub use self::delete::DeleteJobArtifactsBuilder;
pub use self::delete::DeleteJobArtifactsBuilderError;

pub use self::download::DownloadJobArtifacts;
pub use self::download::DownloadJobArtifactsBuilder;
pub use self::download::DownloadJobArtifactsBuilderError;

pub use self::download_by_ref::DownloadRefJobArtifacts;
pub use self::download_by_ref::DownloadRefJobArtifactsBuilder;
pub use self::download_by_ref::DownloadRefJobArtifactsBuilderError;

pub use self::download_file::DownloadJobArtifactFile;
pub use self::download_file::DownloadJobArtifactFileBuilder;
pub use self::download_file::DownloadJobArtifactFileBuilderError;

pub use self::download_file_by_ref::DownloadRefJobArtifactFile;
pub use self::download_file_by_ref::DownloadRefJobArtifactFileBuilder;
pub use self::download_file_by_ref::DownloadRefJobArtifactFileBuilderError;

pub use self::keep::KeepJobArtifacts;
pub use self::keep::KeepJobArtifactsBuilder;
pub use self::keep::KeepJobArtifactsBuilderError;
