// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

//! Project job token scopes API endpoints.
//!
//! These endpoints are used for managing job token scopes.

mod allow_group;
mod allow_project;
mod allowed_groups;
mod allowed_projects;
mod disallow_group;
mod disallow_project;
mod edit;
mod job_token_scopes;

pub use self::allowed_groups::AllowedJobTokenGroups;
pub use self::allowed_groups::AllowedJobTokenGroupsBuilder;
pub use self::allowed_groups::AllowedJobTokenGroupsBuilderError;

pub use self::allowed_projects::AllowedJobTokenProjects;
pub use self::allowed_projects::AllowedJobTokenProjectsBuilder;
pub use self::allowed_projects::AllowedJobTokenProjectsBuilderError;

pub use self::allow_group::AllowJobTokenGroup;
pub use self::allow_group::AllowJobTokenGroupBuilder;
pub use self::allow_group::AllowJobTokenGroupBuilderError;

pub use self::allow_project::AllowJobTokenProject;
pub use self::allow_project::AllowJobTokenProjectBuilder;
pub use self::allow_project::AllowJobTokenProjectBuilderError;

pub use self::disallow_group::DisallowJobTokenGroup;
pub use self::disallow_group::DisallowJobTokenGroupBuilder;
pub use self::disallow_group::DisallowJobTokenGroupBuilderError;

pub use self::disallow_project::DisallowJobTokenProject;
pub use self::disallow_project::DisallowJobTokenProjectBuilder;
pub use self::disallow_project::DisallowJobTokenProjectBuilderError;

pub use self::edit::EditJobTokenScope;
pub use self::edit::EditJobTokenScopeBuilder;
pub use self::edit::EditJobTokenScopeBuilderError;

pub use self::job_token_scopes::JobTokenScopes;
pub use self::job_token_scopes::JobTokenScopesBuilder;
pub use self::job_token_scopes::JobTokenScopesBuilderError;
