# Endpoint status

This document categorizes the APIs as they pertain to this crate.

Last synced: v17.10.0-pre (dd39e7375dd8f1a598fd23767a856571b8585d0e)

Missed from last sync:
  - creating and editing projects parameters (mirroring deprecations at least)
  - file position support for discussions

# Implemented

These API endpoints have been implemented.

  * `GET    /deploy_keys` `deploy_keys/deploy_keys.rs`
  * `GET    /groups` `groups/groups.rs`
  * `POST   /groups` `groups/create.rs`
  * `PUT    /groups/:group` `groups/edit.rs`
  * `GET    /groups/:group` `groups/group.rs`
  * `GET    /groups/:group/access_requests` `groups/access_requests/access_requests.rs`
  * `POST   /groups/:group/access_requests` `groups/access_requests/request.rs`
  * `PUT    /groups/:group/access_requests/:user_id/approve` `groups/access_requests/approve.rs`
    This should be a `POST` action `POST /groups/:group/access_requests/:user_id/approve`.
    https://gitlab.com/gitlab-org/gitlab/-/issues/435861
  * `DELETE /groups/:group/access_requests/:user_id` `groups/access_requests/deny.rs`
  * `GET    /groups/:group/hooks` `groups/hooks/hooks.rs`
  * `POST   /groups/:group/hooks` `groups/hooks/create.rs`
  * `GET    /groups/:group/hooks/:hook` `groups/hooks/hook.rs`
  * `PUT    /groups/:group/hooks/:hook` `groups/hooks/edit.rs`
  * `DELETE /groups/:group/hooks/:hook` `groups/hooks/delete.rs`
  * `GET    /groups/:group/members` `groups/members/members.rs`
  * `POST   /groups/:group/members` `groups/members/add.rs`
  * `GET    /groups/:group/members/:member` `groups/members/member.rs`
  * `DELETE /groups/:group/members/:member` `groups/members/remove.rs`
  * `PUT    /groups/:group/members/:member` `groups/members/edit.rs`
  * `POST   /groups/:group/milestones` `groups/milestones/create.rs`
  * `GET    /groups/:group/packages`  `groups/packages/packages.rs`
  * `GET    /groups/:group/projects` `groups/projects/projects.rs`
  * `GET    /groups/:group/projects/shared` `groups/projects/shared.rs`
  * `PUT    /groups/:group/push_rule` `groups/push_rule/edit.rs`
  * `GET    /groups/:group/runners` `groups/runners/runners.rs`
  * `POST   /groups/:group/share` `groups/share.rs`
  * `DELETE /groups/:group/share/:group2` `groups/unshare.rs`
  * `GET    /groups/:group/subgroups` `groups/subgroups/subgroups.rs`
  * `GET    /groups/:group/variables` `groups/variables/variables.rs`
  * `POST   /groups/:group/variables` `groups/variables/create.rs`
  * `GET    /groups/:group/variables/:key` `groups/variables/variable.rs`
  * `PUT    /groups/:group/variables/:key` `groups/variables/update.rs`
  * `DELETE /groups/:group/variables/:key` `groups/variables/delete.rs`
  * `GET    /issues` `issues/issues.rs`
  * `GET    /job` `job/job.rs`
  * `GET    /merge_requests` `merge_requests/merge_requests.rs`
  * `GET    /personal_access_tokens` `personal_access_tokens/personal_access_tokens.rs`
  * `GET    /personal_access_tokens/:token` `personal_access_tokens/personal_access_token.rs`
  * `DELETE /personal_access_tokens/:token` `personal_access_tokens/revoke.rs`
  * `POST   /personal_access_tokens/:token/rotate` `personal_access_tokens/rotate.rs`
  * `GET    /personal_access_tokens/self` `personal_access_tokens/personal_access_token_self.rs`
  * `DELETE /personal_access_tokens/self` `personal_access_tokens/revoke_self.rs`
  * `POST   /personal_access_tokens/self/rotate` `personal_access_tokens/rotate_self.rs`
  * `GET    /projects` `projects/projects.rs`
  * `POST   /projects` `projects/create.rs`
  * `GET    /projects/:project` `projects/project.rs`
  * `PUT    /projects/:project` `projects/edit.rs`
  * `DELETE /projects/:project` `projects/delete.rs`
  * `GET    /projects/:project/access_tokens` `projects/access_tokens/access_tokens.rs`
  * `POST   /projects/:project/access_tokens` `projects/access_tokens/create.rs`
  * `GET    /projects/:project/access_tokens/:token` `projects/access_tokens/access_token.rs`
  * `DELETE /projects/:project/access_tokens/:token` `projects/access_tokens/revoke.rs`
  * `POST   /prgjects/:project/access_tokens/rotate` `projects/access_tokens/rotate.rs`
  * `GET    /projects/:project/access_requests` `projects/access_requests/access_requests.rs`
  * `POST   /projects/:project/access_requests` `projects/access_requests/request.rs`
    This should be a `POST` action `POST /projects/:project/access_requests/:user_id/approve`.
    https://gitlab.com/gitlab-org/gitlab/-/issues/435861
  * `PUT    /projects/:project/access_requests/:user_id/approve` `projects/access_requests/approve.rs`
  * `DELETE /projects/:project/access_requests/:user_id` `projects/access_requests/deny.rs`
  * `POST   /projects/:project/archive` `projects/archive.rs`
  * `DELETE /projects/:project/artifacts` `projects/artifacts/delete.rs`
  * `GET    /projects/:project/approvals` `projects/approvals/approvals.rs`
  * `GET    /projects/:project/approval_rules` `projects/approval_rules/approval_rules.rs`
  * `GET    /projects/:project/deploy_keys` `projects/deploy_keys/deploy_keys.rs`
  * `GET    /projects/:project/deploy_keys/:deploy_key` `projects/deploy_keys/deploy_key.rs`
  * `POST   /projects/:project/deploy_keys` `projects/deploy_keys/create.rs`
  * `PUT    /projects/:project/deploy_keys/:deploy_key` `projects/deploy_keys/edit.rs`
  * `DELETE /projects/:project/deploy_keys/:deploy_key` `projects/deploy_keys/delete.rs`
  * `POST   /projects/:project/deploy_keys/:deploy_key/enable` `projects/deploy_keys/enable.rs`
  * `GET    /projects/:project/deployments` `projects/deployments/deployments.rs`
  * `POST   /projects/:project/deployments` `projects/deployments/create.rs`
  * `GET    /projects/:project/deployments/:deployment` `projects/deployments/deployment.rs`
  * `PUT    /projects/:project/deployments/:deployment` `projects/deployments/edit.rs`
  * `DELETE /projects/:project/deployments/:deployment` `projects/deployments/delete.rs`
  * `GET    /projects/:project/environments` `projects/environments/environments.rs`
  * `GET    /projects/:project/environments/:environment` `projects/environments/environment.rs`
  * `GET    /projects/:project/hooks` `projects/hooks/hooks.rs`
  * `POST   /projects/:project/hooks` `projects/hooks/create.rs`
  * `GET    /projects/:project/hooks/:hook` `projects/hooks/hook.rs`
  * `PUT    /projects/:project/hooks/:hook` `projects/hooks/edit.rs`
  * `DELETE /projects/:project/hooks/:hook` `projects/hooks/delete.rs`
  * `GET    /projects/:project/issues` `projects/issues/issues.rs`
    - Missing support for `not`.
  * `POST   /projects/:project/issues` `projects/issues/create.rs`
  * `GET    /projects/:project/issues/:issue` `projects/issues/issue.rs`
  * `PUT    /projects/:project/issues/:issue` `projects/issues/edit.rs`
  * `DELETE /projects/:project/issues/:issue` `projects/issues/delete.rs`
  * `GET    /projects/:project/issues/:issue/award_emoji` `projects/issues/awards/awards.rs`
  * `POST   /projects/:project/issues/:issue/award_emoji` `projects/issues/awards/create.rs`
  * `GET    /projects/:project/issues/:issue/award_emoji/:award` `projects/issues/awards/award.rs`
  * `DELETE /projects/:project/issues/:issue/award_emoji/:award` `projects/issues/awards/delete.rs`
  * `GET    /projects/:project/issues/:issue/closed_by` `projects/issues/merge_requests_closing.rs`
  * `GET    /projects/:project/issues/:issue/notes` `projects/issues/notes/notes.rs`
  * `POST   /projects/:project/issues/:issue/notes` `projects/issues/notes/create.rs`
  * `PUT    /projects/:project/issues/:issue/notes/:note` `projects/issues/notes/edit.rs`
  * `DELETE /projects/:project/issues/:issue/notes/:note` `projects/issues/notes/delete.rs`
  * `GET    /projects/:project/issues/:issue/notes/:note/award_emoji` `projects/issues/notes/awards/awards.rs`
  * `POST   /projects/:project/issues/:issue/notes/:note/award_emoji` `projects/issues/notes/awards/create.rs`
  * `GET    /projects/:project/issues/:issue/notes/:note/award_emoji/:award` `projects/issues/notes/awards/award.rs`
  * `DELETE /projects/:project/issues/:issue/notes/:note/award_emoji/:award` `projects/issues/notes/awards/delete.rs`
  * `GET    /projects/:project/issues/:issue/related_merge_requests` `projects/issues/related_merge_requests.rs`
  * `GET    /projects/:project/issues/:issue/resource_label_events` `projects/issues/resource_label_events.rs`
  * `GET    /projects/:project/jobs` `projects/jobs/jobs.rs`
  * `GET    /projects/:project/jobs/artifacts/:ref/download` `projects/jobs/artifacts/download_by_ref.rs`
  * `GET    /projects/:project/jobs/artifacts/:ref/raw/*path` `projects/jobs/artifacts/download_file_by_ref.rs`
  * `GET    /projects/:project/jobs/:job` `projects/jobs/job.rs`
  * `GET    /projects/:project/jobs/:job/artifacts` `projects/jobs/artifacts/download.rs`
  * `DELETE /projects/:project/jobs/:job/artifacts` `projects/jobs/artifacts/delete.rs`
  * `POST   /projects/:project/jobs/:job/artifacts/keep` `projects/jobs/artifacts/keep.rs`
  * `GET    /projects/:project/jobs/:job/artifacts/*path` `projects/jobs/artifacts/download_file.rs`
  * `POST   /projects/:project/jobs/:job/cancel` `projects/jobs/cancel.rs`
  * `POST   /projects/:project/jobs/:job/erase` `projects/jobs/erase.rs`
  * `POST   /projects/:project/jobs/:job/retry` `projects/jobs/retry.rs`
  * `POST   /projects/:project/jobs/:job/play` `projects/jobs/play.rs`
  * `GET    /projects/:project/jobs/:job/trace` `projects/jobs/trace.rs`
  * `GET    /projects/:project/job_token_scope` `projects/job_token_scopes/job_token_scopes.rs`
  * `PATCH  /projects/:project/job_token_scope` `projects/job_token_scopes/edit.rs`
  * `GET    /projects/:project/job_token_scope/allowlist` `projects/job_token_scopes/allowed_projects.rs`
  * `POST   /projects/:project/job_token_scope/allowlist` `projects/job_token_scopes/allow_project.rs`
  * `DELETE /projects/:project/job_token_scope/allowlist/:target_project_id` `projects/job_token_scopes/disallow_project.rs`
  * `GET    /projects/:project/job_token_scope/groups_allowlist` `projects/job_token_scopes/allowed_groups.rs`
  * `POST   /projects/:project/job_token_scope/groups_allowlist` `projects/job_token_scopes/allow_group.rs`
  * `DELETE /projects/:project/job_token_scope/groups_allowlist/:target_group_id` `projects/job_token_scopes/disallow_group.rs`
  * `GET    /projects/:project/labels` `projects/labels/labels.rs`
  * `POST   /projects/:project/labels` `projects/labels/create.rs`
  * `GET    /projects/:project/labels/:label` `projects/labels/label.rs`
  * `PUT    /projects/:project/labels/:label` `projects/labels/edit.rs`
  * `DELETE /projects/:project/labels/:label` `projects/labels/delete.rs`
  * `PUT    /projects/:project/labels/:label/promote` `projects/labels/promote.rs`
    Arguably, this should be `POST /projects/:project/labels/:label/promote`.
    https://gitlab.com/gitlab-org/gitlab/-/issues/219324#note_382305638
  * `GET    /projects/:project/members` `projects/members/members.rs`
  * `POST   /projects/:project/members` `projects/members/add.rs`
  * `GET    /projects/:project/members/:member` `projects/members/member.rs`
  * `PUT    /projects/:project/members/:member` `projects/members/edit.rs`
  * `DELETE /projects/:project/members/:member` `projects/members/remove.rs`
  * `GET    /projects/:project/members/all` `projects/members/members.rs`
  * `GET    /projects/:project/members/all/:member` `projects/members/member.rs`
  * `GET    /projects/:project/merge_requests` `projects/merge_requests/merge_requests.rs`
    - Missing support for `not`.
  * `POST   /projects/:project/merge_requests` `projects/merge_requests/create.rs`
  * `GET    /projects/:project/merge_requests/:merge_request` `projects/merge_requests/merge_request.rs`
  * `PUT    /projects/:project/merge_requests/:merge_request` `projects/merge_requests/edit.rs`
  * `GET    /projects/:project/merge_requests/:merge_request/approval_rules` `projects/merge_requests/approval_rules/approval_rules.rs`
  * `GET    /projects/:project/merge_requests/:merge_request/approval_state` `projects/merge_requests/approval_state/approval_state.rs`
  * `GET    /projects/:project/merge_requests/:merge_request/approvals` `projects/merge_requests/approvals/approvals.rs`
  * `POST   /projects/:project/merge_requests/:merge_request/approve` `projects/merge_requests/approve.rs`
  * `GET    /projects/:project/merge_requests/:merge_request/award_emoji` `projects/merge_requests/awards/awards.rs`
  * `GET    /projects/:project/merge_requests/:merge_request/changes` `projects/merge_requests/changes.rs`
  * `GET    /projects/:project/merge_requests/:merge_request/closes_issues` `projects/merge_requests/issues_closed_by.rs`
  * `GET    /projects/:project/merge_requests/:merge_request/commits` `projects/merge_requests/commits.rs`
  * `GET    /projects/:project/merge_requests/:merge_request/diffs` `projects/merge_requests/diffs.rs`
  * `GET    /projects/:project/merge_requests/:merge_request/discussions` `projects/merge_requests/discussions/discussions.rs`
  * `POST   /projects/:project/merge_requests/:merge_request/discussions` `projects/merge_requests/discussions/create.rs`
  * `PUT    /projects/:project/merge_requests/:merge_request/merge` `projects/merge_requests/merge.rs`
    This should be a `POST` action.
    https://gitlab.com/gitlab-org/gitlab/-/issues/219324
  * `GET    /projects/:project/merge_requests/:merge_request/notes` `projects/merge_requests/notes/notes.rs`
  * `POST   /projects/:project/merge_requests/:merge_request/notes` `projects/merge_requests/notes/create.rs`
  * `PUT    /projects/:project/merge_requests/:merge_request/notes/:note` `projects/merge_requests/notes/edit.rs`
  * `GET    /projects/:project/merge_requests/:merge_request/notes/:note/award_emoji` `projects/merge_requests/notes/awards/awards.rs`
  * `POST   /projects/:project/merge_requests/:merge_request/notes/:note/award_emoji` `projects/merge_requests/notes/awards/create.rs`
  * `GET    /projects/:project/merge_requests/:merge_request/notes/:note/award_emoji/:award` `projects/merge_requests/notes/awards/award.rs`
  * `DELETE /projects/:project/merge_requests/:merge_request/notes/:note/award_emoji/:award` `projects/merge_requests/notes/awards/delete.rs`
  * `GET    /projects/:project/merge_requests/:merge_request/pipelines` `projects/merge_requests/pipelines/pipelines.rs`
  * `POST   /projects/:project/merge_requests/:merge_request/pipelines` `projects/merge_requests/pipelines/create.rs`
  * `PUT    /projects/:project/merge_requests/:merge_request/rebase` `projects/merge_requests/rebase.rs`
    This should be a `POST` action.
    https://gitlab.com/gitlab-org/gitlab/-/issues/219324
  * `GET    /projects/:project/merge_requests/:merge_request/resource_label_events` `projects/merge_requests/resource_label_events.rs`
  * `POST   /projects/:project/merge_requests/:merge_request/unapprove` `projects/merge_requests/unapprove.rs`
  * `GET    /projects/:project/merge_trains` `projects/merge_trains.rs`
  * `POST   /projects/:project/milestones` `projects/milestones/create.rs`
  * `GET    /projects/:project/packages` `projects/packages/packages.rs`
  * `GET    /projects/:project/packages/:package` `projects/packages/get.rs`
  * `DELETE /projects/:project/packages/:package` `projects/packages/delete.rs`
  * `GET    /projects/:project/packages/:package/package_files` `projects/packages/package_files/package_files.rs`
  * `DELETE /projects/:project/packages/:package/package_files/:package_file` `projects/packages/package_files/delete.rs`
  * `GET    /projects/:project/packages/generic/:package_name/:package_version/:file_name` `projects/packages/generic/get.rs`
  * `PUT    /projects/:project/packages/generic/:package_name/:package_version/:file_name` `projects/packages/generic/upload.rs`
  * `GET    /projects/:project/pages` `projects/pages/pages.rs`
  * `PATCH  /projects/:project/pages` `projects/pages/edit.rs`
  * `DELETE /projects/:project/pages` `projects/pages/unpublish.rs`
  * `GET    /projects/:project/pipelines` `projects/pipelines/pipelines.rs`
  * `POST   /projects/:project/pipelines` `projects/pipelines/create.rs`
  * `GET    /projects/:project/pipelines/:pipeline` `projects/pipelines/pipeline.rs`
  * `DELETE /projects/:project/pipelines/:pipeline` `projects/pipelines/delete.rs`
  * `POST   /projects/:project/pipelines/:pipeline/cancel` `projects/pipelines/cancel.rs`
  * `GET    /projects/:project/pipelines/:pipeline/jobs` `projects/pipelines/jobs.rs`
  * `GET    /projects/:project/pipelines/:pipeline/bridges` `projects/pipelines/bridges.rs`
  * `POST   /projects/:project/pipelines/:pipeline/retry` `projects/pipelines/retry.rs`
  * `GET    /projects/:project/pipelines/:pipeline/variables` `projects/pipelines/variables.rs`
  * `GET    /projects/:project/pipelines/:pipeline/test_report` `projects/pipelines/test_report.rs`
  * `GET    /projects/:project/pipelines/:pipeline/test_report_summary` `projects/pipelines/test_report_summary.rs`
  * `GET    /projects/:project/pipeline_schedules` `projects/pipeline_schedules/schedules.rs`
  * `POST   /projects/:project/pipeline_schedules` `projects/pipeline_schedules/create.rs`
  * `GET    /projects/:project/pipeline_schedules/:id` `projects/pipeline_schedules/schedule.rs`
  * `DELETE /projects/:project/pipeline_schedules/:id` `projects/pipeline_schedules/delete.rs`
  * `PUT    /projects/:project/pipeline_schedules/:id` `projects/pipeline_schedules/edit.rs`
  * `GET    /projects/:project/pipeline_schedules/:id/pipelines` `projects/pipeline_schedules/pipelines.rs`
  * `POST   /projects/:project/pipeline_schedules/:id/play` `projects/pipeline_schedules/play.rs`
  * `POST   /projects/:project/pipeline_schedules/:id/take_ownership` `projects/pipeline_schedules/take_ownership.rs`
  * `POST   /projects/:project/pipeline_schedules/:id/variables` `projects/pipeline_schedules/variables/create.rs`
  * `DELETE /projects/:project/pipeline_schedules/:id/variables/:key` `projects/pipeline_schedules/variables/delete.rs`
  * `PUT    /projects/:project/pipeline_schedules/:id/variables/:key` `projects/pipeline_schedules/variables/edit.rs`
  * `GET    /projects/:project/protected_branches` `projects/protected_branches/protected_branches.rs`
  * `POST   /projects/:project/protected_branches` `projects/protected_branches/protect.rs`
  * `DELETE /projects/:project/protected_branches/*branch` `projects/protected_branches/unprotect.rs`
  * `GET    /projects/:project/protected_branches/:branch` `projects/protected_branches/protected_branch.rs`
  * `GET    /projects/:project/protected_tags` `projects/protected_tags/protected_tags.rs`
  * `POST   /projects/:project/protected_tags` `projects/protected_tags/protect.rs`
  * `GET    /projects/:project/protected_tags/:name` `projects/protected_tags/protected_tag.rs`
  * `DELETE /projects/:project/protected_tags/:name` `projects/protected_tags/unprotect.rs`
  * `PUT    /projects/:project/push_rule` `projects/push_rule/edit.rs`
  * `GET    /projects/:project/registry/repositories` `projects/registry/repositories.rs`
  * `DELETE /projects/:project/registry/repositories/:repository` `projects/registry/delete_repository.rs`
  * `GET    /projects/:project/registry/repositories/:repository/tags` `projects/registry/repository_tags.rs`
  * `DELETE /projects/:project/registry/repositories/:repository/tags` `projects/registry/delete_repository_tags.rs`
  * `GET    /projects/:project/registry/repositories/:repository/tags/:tag_name` `projects/registry/repository_tag_details.rs`
  * `DELETE /projects/:project/registry/repositories/:repository/tags/:tag_name` `projects/registry/delete_repository_tag.rs`
  * `GET    /projects/:project/releases` `projects/releases/releases.rs`
  * `GET    /projects/:project/releases/:tag_name` `projects/releases/release_by_tag.rs`
  * `POST   /projects/:project/releases` `projects/releases/create.rs`
  * `GET    /projects/:project/releases/:tag/assets/links` `projects/releases/links/links.rs`
  * `POST   /projects/:project/releases/:tag/assets/links` `projects/releases/links/create.rs`
  * `GET    /projects/:project/releases/:tag/assets/links/:id` `projects/releases/links/link.rs`
  * `PUT    /projects/:project/releases/:tag/assets/links/:id` `projects/releases/links/update.rs`
  * `DELETE /projects/:project/releases/:tag/assets/links/:id` `projects/releases/links/delete.rs`
  * `GET    /projects/:project/repository/archive[.format]` `projects/repository/archive.rs`
  * `GET    /projects/:project/repository/branches` `projects/repository/branches/branches.rs`
  * `POST   /projects/:project/repository/branches` `projects/repository/branches/create.rs`
  * `GET    /projects/:project/repository/branches/:branch` `projects/repository/branches/branch.rs`
  * `DELETE /projects/:project/repository/branches/:branch` `projects/repository/branches/delete.rs`
  * `GET    /projects/:project/repository/commits` `projects/repository/commits/commits.rs`
  * `POST   /projects/:project/repository/commits` `projects/repository/commits/create.rs`
  * `GET    /projects/:project/repository/commits/:sha` `projects/repository/commits/commit.rs`
  * `GET    /projects/:project/repository/commits/:sha/refs` `projects/repository/commits/refs.rs`
  * `GET    /projects/:project/repository/commits/:sha/comments` `projects/repository/commits/comments.rs`
  * `POST   /projects/:project/repository/commits/:sha/comments` `projects/repository/commits/comment.rs`
  * `GET    /projects/:project/repository/commits/:sha/merge_requests` `projects/repository/commits/merge_requests.rs`
  * `GET    /projects/:project/repository/commits/:sha/statuses` `projects/repository/commits/statuses.rs`
  * `GET    /projects/:project/repository/commits/:sha/signature` `projects/repository/commits/signature.rs`
  * `GET    /projects/:project/repository/compare` `projects/repository/commits/compare.rs`
  * `GET    /projects/:project/repository/contributors` `projects/repository/contributors/contributors.rs`
  * `GET    /projects/:project/repository/files/*file_path` `projects/repository/files/file.rs`
  * `POST   /projects/:project/repository/files/*file_path` `projects/repository/files/create.rs`
  * `PUT    /projects/:project/repository/files/*file_path` `projects/repository/files/update.rs`
  * `DELETE /projects/:project/repository/files/*file_path` `projects/repository/files/delete.rs`
  * `GET    /projects/:project/repository/files/*file_path/raw` `projects/repository/files/file_raw.rs`
  * `GET    /projects/:project/repository/tags` `projects/repository/tags/tags.rs`
  * `POST   /projects/:project/repository/tags` `projects/repository/tags/create.rs`
  * `GET    /projects/:project/repository/tags/:tag` `projects/repository/tags/tag.rs`
  * `DELETE /projects/:project/repository/tags/:tag` `projects/repository/tags/delete.rs`
  * `GET    /projects/:project/repository/tree` `projects/repository/tree.rs`
  * `GET    /projects/:project/runners` `projects/runners/runners.rs`
  * `POST   /projects/:project/runners` `projects/runners/enable.rs`
  * `DELETE /projects/:project/runners/:runner` `projects/runners/disable.rs`
  * `POST   /projects/:project/share` `projects/share.rs`
  * `DELETE /projects/:project/share/:group` `projects/unshare.rs`
  * `POST   /projects/:project/star` `projects/star/star.rs`
  * `GET    /projects/:project/starrers` `projects/star/starrers.rs`
  * `POST   /projects/:project/statuses/:sha` `projects/repository/commits/create_status.rs`
    Arguably, this should be `POST /projects/:project/repository/commits/:sha/statuses`.
    https://gitlab.com/gitlab-org/gitlab/-/issues/217412
  * `POST   /projects/:project/unarchive` `projects/unarchive.rs`
  * `POST   /projects/:project/unstar` `projects/star/unstar.rs`
  * `GET    /projects/:project/variables` `projects/variables/variables.rs`
  * `POST   /projects/:project/variables` `projects/variables/create.rs`
  * `GET    /projects/:project/variables/:key` `projects/variables/variable.rs`
  * `PUT    /projects/:project/variables/:key` `projects/variables/update.rs`
  * `DELETE /projects/:project/variables/:key` `projects/variables/delete.rs`
  * `GET    /registry/repositories/:repository` `registry/repositories/repository_details.rs`
  * `GET    /runners` `runners/runners.rs`
  * `POST   /runners` `runners/create.rs`
  * `DELETE /runners` `runners/delete_by_token.rs`
  * `GET    /runners/all` `runners/all_runners.rs`
  * `GET    /runners/:runner` `runners/runner.rs`
  * `PUT    /runners/:runner` `runners/edit.rs`
  * `DELETE /runners/:runner` `runners/delete.rs`
  * `GET    /runners/:runner/jobs` `runners/jobs.rs`
  * `POST   /runners/:runner/reset_authentication_token` `runners/reset_authentication_token.rs`
  * `POST   /runners/reset_authentication_token` `runners/reset_authentication_token_by_token.rs`
  * `POST   /runners/verify` `runners/verify.rs`
  * `GET    /user` `users/current_user.rs`
  * `POST   /user/runners` `users/runners/create.rs`
  * `GET    /users` `users/users.rs`
  * `POST   /users` `users/create.rs`
  * `POST   /users/personal_access_tokens` `users/personal_access_tokens/create.rs`
  * `GET    /users/:user` `users/user.rs`
  * `GET    /users/:user/impersonation_tokens` `users/impersonation_tokens/impersonation_tokens.rs`
  * `POST   /users/:user/impersonation_tokens` `users/impersonation_tokens/create.rs`
  * `GET    /users/:user/impersonation_tokens/:impersonation_token` `users/impersonation_tokens/impersonation_token.rs`
  * `DELETE /users/:user/impersonation_tokens/:impersonation_token` `users/impersonation_tokens/delete.rs`
  * `POST   /users/:user/personal_access_tokens` `users/personal_access_tokens/create_for_user.rs`
  * `GET    /users/:user/projects` `users/projects/projects.rs`

# Todo

This section contains the list of API endpoints which are not yet implemented
in this crate. Contributions welcome!

## Specific endpoints

These endpoints are documented on a page that have other endpoints already
implemented above. This is split out into a separate list for convenience
instead of having to search the page for missing endpoints.

  * `POST   /deploy_keys` https://gitlab.kitware.com/help/api/deploy_keys.md#add-deploy-key
  * `GET    /issues/:issue` https://gitlab.kitware.com/help/api/issues.md#single-issue
  * `DELETE /groups/:group` https://gitlab.kitware.com/help/api/groups.md#remove-group
  * `GET    /groups/:group/avatar` https://gitlab.kitware.com/help/api/groups.md#download-a-group-avatar
  * `PUT    /groups/:group/avatar` https://gitlab.kitware.com/help/api/groups.md#upload-a-group-avatar
  * `DELETE /groups/:group/avatar` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523467
  * `GET    /groups/:group/approval_rules` https://gitlab.kitware.com/help/api/merge_request_approvals.md#get-group-approval-rules
  * `POST   /groups/:group/approval_rules` https://gitlab.kitware.com/help/api/merge_request_approvals.md#create-group-approval-rules
  * `PUT    /groups/:group/approval_rules/:approval_rule` https://gitlab.kitware.com/help/api/merge_request_approvals.md#update-group-approval-rules
  * `DELETE /groups/:group/approval_rules/:approval_rule` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523478
  * `GET    /groups/:group/billable_members` https://gitlab.kitware.com/help/api/groups.md#list-all-billable-members-of-a-group
  * `GET    /groups/:group/billable_members/:user/memberships` https://gitlab.kitware.com/help/api/members.md#list-memberships-for-a-billable-member-of-a-group
  * `DELETE /groups/:group/billable_members/:user` https://gitlab.kitware.com/help/api/members.md#remove-a-billable-member-from-a-group
  * `GET    /groups/:group/billable_members/:user/indirect` https://gitlab.kitware.com/help/api/members.md#list-indirect-memberships-for-a-billable-member-of-a-group
  * `PUT    /groups/:group/billable_members/:user/state` https://gitlab.kitware.com/help/api/members.md#change-membership-state-of-a-user-in-a-group
  * `GET    /groups/:group/descendant_groups` https://gitlab.kitware.com/help/api/groups.md#list-a-groups-descendant-groups
  * `GET    /groups/:group/epics/:epic/discussions` https://gitlab.kitware.com/help/api/discussions.md#list-group-epic-discussion-items
  * `POST   /groups/:group/epics/:epic/discussions` https://gitlab.kitware.com/help/api/discussions.md#create-new-epic-thread
  * `GET    /groups/:group/epics/:epic/discussions/:discussion` https://gitlab.kitware.com/help/api/discussions.md#get-single-epic-discussion-item
  * `POST   /groups/:group/epics/:epic/discussions/:discussion/notes` https://gitlab.kitware.com/help/api/discussions.md#add-note-to-existing-epic-thread
  * `PUT    /groups/:group/epics/:epic/discussions/:discussion/notes/:note` https://gitlab.kitware.com/help/api/discussions.md#modify-existing-epic-thread-note
  * `DELETE /groups/:group/epics/:epic/discussions/:discussion/notes/:note` https://gitlab.kitware.com/help/api/discussions.md#delete-an-epic-thread-note
  * `GET    /groups/:group/epics/:epic/notes` https://gitlab.kitware.com/help/api/notes.md#list-all-epic-notes
  * `POST   /groups/:group/epics/:epic/notes` https://gitlab.kitware.com/help/api/notes.md#create-new-epic-note
  * `GET    /groups/:group/epics/:epic/notes/:note` https://gitlab.kitware.com/help/api/notes.md#get-single-epic-note
  * `PUT    /groups/:group/epics/:epic/notes/:note` https://gitlab.kitware.com/help/api/notes.md#modify-existing-epic-note
  * `DELETE /groups/:group/epics/:epic/notes/:note` https://gitlab.kitware.com/help/api/notes.md#delete-an-epic-note
  * `GET    /groups/:group/epics/:epic/resource_label_events` https://gitlab.kitware.com/help/api/resource_label_events.md#list-group-epic-label-events (deprecated in 17.0)
  * `GET    /groups/:group/epics/:epic/resource_label_events/:event` https://gitlab.kitware.com/help/api/resource_label_events.md#get-single-epic-label-event (deprecated in 17.0)
  * `GET    /groups/:group/hooks/:hook/events` https://gitlab.kitware.com/help/api/group_webhooks.md#get-group-hook-events
  * `POST   /groups/:group/hooks/:hook/events/:event/resend` https://gitlab.kitware.com/help/api/group_webhooks.md#resend-group-hook-event
  * `POST   /groups/:group/hooks/:hook/test/:trigger` https://gitlab.kitware.com/help/api/group_webhooks.md#trigger-a-test-group-hook
  * `GET    /groups/:group/hooks/:hook/custom_headers/:key` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523476
  * `POST   /groups/:group/hooks/:hook/custom_headers/:key` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523476
  * `GET    /groups/:group/hooks/:hook/custom_headers/:key` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523476
  * `PUT    /groups/:group/hooks/:hook/custom_headers/:key` https://gitlab.kitware.com/help/api/group_webhooks.md#set-a-custom-header
  * `DELETE /groups/:group/hooks/:hook/custom_headers/:key` https://gitlab.kitware.com/help/api/group_webhooks.md#delete-a-custom-header
  * `GET    /groups/:group/hooks/:hook/url_variables` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523476
  * `POST   /groups/:group/hooks/:hook/url_variables` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523476
  * `GET    /groups/:group/hooks/:hook/url_variables/:key` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523476
  * `PUT    /groups/:group/hooks/:hook/url_variables/:key` https://gitlab.kitware.com/help/api/group_webhooks.md#set-a-url-variable
  * `DELETE /groups/:group/hooks/:hook/url_variables/:key` https://gitlab.kitware.com/help/api/group_webhooks.md#delete-a-url-variable
  * `GET    /groups/:group/invited_groups` https://gitlab.kitware.com/help/api/groups.md#list-a-projects-invited-groups
  * `GET    /groups/:group/issues` https://gitlab.kitware.com/help/api/issues.md#list-group-issues
  * `GET    /groups/:group/ldap_group_links` https://gitlab.kitware.com/help/api/groups.md#list-ldap-group-links-starter
  * `POST   /groups/:group/ldap_group_links` https://gitlab.kitware.com/help/api/groups.md#add-ldap-group-link-with-cn-or-filter-starter
  * `DELETE /groups/:group/ldap_group_links` https://gitlab.kitware.com/help/api/groups.md#delete-ldap-group-link-with-cn-or-filter-starter
  * `DELETE /groups/:group/ldap_group_links/:cn` https://gitlab.kitware.com/help/api/groups.md#delete-ldap-group-link-starter (deprecated)
  * `DELETE /groups/:group/ldap_group_links/:provider/:cn` https://gitlab.kitware.com/help/api/groups.md#delete-ldap-group-link-starter (deprecated)
  * `POST   /groups/:group/ldap_sync` https://gitlab.kitware.com/help/api/groups.md#sync-group-with-ldap-starter
  * `GET    /groups/:group/members/all` https://gitlab.kitware.com/help/api/members.md#list-all-members-of-a-group-or-project-including-inherited-members
  * `GET    /groups/:group/members/all/:member` https://gitlab.kitware.com/help/api/members.md#get-a-member-of-a-group-or-project-including-inherited-members
  * `POST   /groups/:group/members/:member/approve` https://gitlab.kitware.com/help/api/members.md#approve-a-member-for-a-group
  * `POST   /groups/:group/members/:member/approve_all` https://gitlab.kitware.com/help/api/members.md#approve-all-pending-members-for-a-group
  * `POST   /groups/:group/members/:member/override` https://gitlab.kitware.com/help/api/members.md#set-override-flag-for-a-member-from-a-group
  * `DELETE /groups/:group/members/:member/override` https://gitlab.kitware.com/help/api/members.md#remove-override-for-a-member-from-a-group
  * `PUT    /groups/:group/members/:member/state` https://gitlab.kitware.com/help/api/members.md#change-membership-state-of-a-user-in-a-group
  * `GET    /groups/:group/merge_requests` https://gitlab.kitware.com/help/api/merge_requests.md#list-group-merge-requests
  * `GET    /groups/:group/milestones` https://gitlab.kitware.com/help/api/group_milestones.md#list-group-milestones
  * `GET    /groups/:group/milestones/:milestone` https://gitlab.kitware.com/help/api/group_milestones.md#get-single-milestone
  * `PUT    /groups/:group/milestones/:milestone` https://gitlab.kitware.com/help/api/group_milestones.md#edit-milestone
  * `DELETE /groups/:group/milestones/:milestone` https://gitlab.kitware.com/help/api/group_milestones.md#delete-group-milestone
  * `GET    /groups/:group/milestones/:milestone/burndown_events` https://gitlab.kitware.com/help/api/group_milestones.md#get-all-burndown-chart-events-for-a-single-milestone-starter
  * `GET    /groups/:group/milestones/:milestone/issues` https://gitlab.kitware.com/help/api/group_milestones.md#get-all-issues-assigned-to-a-single-milestone
  * `GET    /groups/:group/milestones/:milestone/merge_requests` https://gitlab.kitware.com/help/api/group_milestones.md#get-all-merge-requests-assigned-to-a-single-milestone
  * `GET    /groups/:group/pending_members` https://gitlab.kitware.com/help/api/members.md#list-pending-members-of-a-group-and-its-subgroups-and-projects
  * `POST   /groups/:group/projects/:project` https://gitlab.kitware.com/help/api/groups.md#transfer-project-to-group
  * `GET    /groups/:group/provisioned_users` https://gitlab.kitware.com/help/api/groups.md#list-provisioned-users
  * `GET    /groups/:group/push_rule` https://gitlab.kitware.com/help/api/groups.md#get-group-push-rules
  * `POST   /groups/:group/push_rule` https://gitlab.kitware.com/help/api/groups.md#add-group-push-rule
  * `DELETE /groups/:group/push_rule` https://gitlab.kitware.com/help/api/groups.md#delete-group-push-rule
  * `GET    /groups/:group/registry/repositories` https://gitlab.kitware.com/help/api/container_registry.md#within-a-group
  * `POST   /groups/:group/restore` https://gitlab.kitware.com/help/api/groups.md#restore-group-marked-for-deletion-premium
  * `GET    /groups/:group/saml_group_links` https://gitlab.kitware.com/help/api/groups.md#list-saml-group-links
  * `GET    /groups/:group/saml_group_links/:saml_group` https://gitlab.kitware.com/help/api/groups.md#get-saml-group-link
  * `DELETE /groups/:group/saml_group_links/:saml_group` https://gitlab.kitware.com/help/api/groups.md#delete-saml-group-link
  * `GET    /groups/:group/service_accounts` https://gitlab.kitware.com/help/api/group_service_accounts.md#list-all-service-account-users
  * `POST   /groups/:group/service_accounts` https://gitlab.kitware.com/help/api/group_service_accounts.md#create-a-service-account-user
  * `DELETE /groups/:group/service_accounts/:id` https://gitlab.kitware.com/help/api/group_service_accounts.md#delete-a-service-account-user
  * `GET    /groups/:group/service_accounts/:id/personal_access_tokens` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523474
  * `POST   /groups/:group/service_accounts/:id/personal_access_tokens` https://gitlab.kitware.com/help/api/group_service_accounts.md#create-a-personal-access-token-for-a-service-account-user
  * `GET    /groups/:group/service_accounts/:id/personal_access_tokens/:token` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523474
  * `POST   /groups/:group/service_accounts/:id/personal_access_tokens/:token/rotate` https://gitlab.kitware.com/help/api/group_service_accounts.md#rotate-a-personal-access-token-for-service-account-user
  * `GET    /groups/:group/shared` https://gitlab.kitware.com/help/api/groups.md#list-shared-groups
  * `POST   /groups/:group/tokens/revoke` https://gitlab.kitware.com/help/api/groups.md#revoke-a-token
  * `POST   /groups/:group/transfer` https://gitlab.kitware.com/help/api/groups.md#transfer-a-group-to-a-new-parent-group-turn-a-subgroup-to-a-top-level-group
  * `GET    /groups/:group/transfer_locations` https://gitlab.kitware.com/help/api/groups.md#get-groups-to-which-a-user-can-transfer-a-group
  * `GET    /groups/:group/users` https://gitlab.kitware.com/help/api/groups.md#list-group-users (EXPERIMENTAL)
  * `GET    /job/allowed_agents` https://gitlab.kitware.com/help/api/jobs.md#get-gitlab-agent-by-ci_job_token
  * `GET    /personal_access_tokens/self/associations` https://gitlab.kitware.com/help/api/personal_access_tokens.md#list-all-token-associations
  * `POST   /projects/:project/approvals` https://gitlab.kitware.com/help/api/merge_request_approvals.md#change-configuration
  * `POST   /projects/:project/approval_rules` https://gitlab.kitware.com/help/api/merge_request_approvals.md#create-project-level-rule
  * `GET    /projects/:project/approval_rules/:approval_rule` https://gitlab.kitware.com/help/api/merge_request_approvals.md#get-a-single-project-level-rule
  * `PUT    /projects/:project/approval_rules/:approval_rule` https://gitlab.kitware.com/help/api/merge_request_approvals.md#update-project-approval-rule
  * `DELETE /projects/:project/approval_rules/:approval_rule` https://gitlab.kitware.com/help/api/merge_request_approvals.md#delete-project-approval-rule
  * `GET    /projects/:project/avatar` https://gitlab.kitware.com/help/api/projects.md#download-a-project-avatar
  * `PUT    /projects/:project/avatar` https://gitlab.kitware.com/help/api/projects.md#upload-a-project-avatar
  * `DELETE /projects/:project/avatar` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523467
  * `GET    /projects/:project/commits/:sha/discussions` https://gitlab.kitware.com/help/api/discussions.md#list-project-commit-discussion-items
    Arguably, this (and its related endpoints) should be `GET
    /projects/:project/repository/commits/:sha/discussions`.
    https://gitlab.com/gitlab-org/gitlab/-/issues/219321
  * `GET    /projects/:project/repository/commits/:sha/sequence` https://gitlab.kitware.com/help/api/commits.md#get-the-sequence-of-a-commit
  * `POST   /projects/:project/commits/:sha/discussions` https://gitlab.kitware.com/help/api/discussions.md#create-new-commit-thread
  * `GET    /projects/:project/commits/:sha/discussions/:discussion` https://gitlab.kitware.com/help/api/discussions.md#get-single-commit-discussion-item
  * `POST   /projects/:project/commits/:sha/discussions/:discussion/notes` https://gitlab.kitware.com/help/api/discussions.md#add-note-to-existing-commit-thread
  * `PUT    /projects/:project/commits/:sha/discussions/:discussion/notes/:note` https://gitlab.kitware.com/help/api/discussions.md#modify-an-existing-commit-thread-note
  * `DELETE /projects/:project/commits/:sha/discussions/:discussion/notes/:note` https://gitlab.kitware.com/help/api/discussions.md#delete-a-commit-thread-note
  * `GET    /projects/:project/deployments/:deployment/merge_requests` https://gitlab.kitware.com/help/api/deployments.md#list-of-merge-requests-associated-with-a-deployment
  * `POST   /projects/:project/deployments/:deployment/approval` https://gitlab.kitware.com/help/api/deployments.md#approve-or-reject-a-blocked-deployment
  * `POST   /projects/:project/environments` https://gitlab.kitware.com/help/api/environments.md#create-a-new-environment
  * `DELETE /projects/:project/environments/review_apps` https://gitlab.kitware.com/help/api/environments.md#delete-multiple-stopped-review-apps
  * `PUT    /projects/:project/environments/:environment` https://gitlab.kitware.com/help/api/environments.md#edit-an-existing-environment
  * `DELETE /projects/:project/environments/:environment` https://gitlab.kitware.com/help/api/environments.md#delete-an-environment
  * `POST   /projects/:project/environments/:environment/stop` https://gitlab.kitware.com/help/api/environments.md#stop-an-environment
  * `POST   /projects/:project/environments/:environment/stop_stale` https://gitlab.kitware.com/help/api/environments.md#stop-stale-environments
  * `GET    /projects/:project/epics/:epic/notes` https://gitlab.kitware.com/help/api/notes.md#list-all-epic-notes
  * `GET    /projects/:project/epics/:epic/notes/:note` https://gitlab.kitware.com/help/api/notes.md#get-single-epic-note
  * `POST   /projects/:project/epics/:epic/notes` https://gitlab.kitware.com/help/api/notes.md#create-new-epic-note
  * `PUT    /projects/:project/epics/:epic/notes/:note` https://gitlab.kitware.com/help/api/notes.md#modify-existing-epic-note
  * `DELETE /projects/:project/epics/:epic/notes/:note` https://gitlab.kitware.com/help/api/notes.md#delete-an-epic-note
  * `POST   /projects/:project/fork` https://gitlab.kitware.com/help/api/project_forks.md#fork-a-project
  * `DELETE /projects/:project/fork` https://gitlab.kitware.com/help/api/project_forks.md#delete-a-fork-relationship-between-projects
  * `POST   /projects/:project/fork/:from` https://gitlab.kitware.com/help/api/project_forks.md#create-a-forked-relationship-between-projects
  * `GET    /projects/:project/forks` https://gitlab.kitware.com/help/api/project_forks.md#list-forks-of-a-project
  * `GET    /projects/:project/groups` https://gitlab.kitware.com/help/api/projects.md#list-groups
  * `GET    /projects/:project/hooks/:hook/events` https://gitlab.kitware.com/help/api/project_webhooks.md#get-a-list-of-project-webhook-events
  * `POST   /projects/:project/hooks/:hook/events/:event/resend` https://gitlab.kitware.com/help/api/project_webhooks.md#resend-a-project-webhook-event
  * `POST   /projects/:project/hooks/:hook/test/:trigger` https://gitlab.kitware.com/help/api/project_webhooks.md#trigger-a-test-project-webhook
  * `GET    /projects/:project/hooks/:hook/custom_headers` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523476
  * `POST   /projects/:project/hooks/:hook/custom_headers` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523476
  * `GET    /projects/:project/hooks/:hook/custom_headers/:key` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523476
  * `PUT    /projects/:project/hooks/:hook/custom_headers/:key` https://gitlab.kitware.com/help/api/project_webhooks.md#set-a-custom-header
  * `DELETE /projects/:project/hooks/:hook/custom_headers/:key` https://gitlab.kitware.com/help/api/project_webhooks.md#delete-a-custom-header
  * `GET    /projects/:project/hooks/:hook/url_variables` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523476
  * `POST   /projects/:project/hooks/:hook/url_variables` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523476
  * `GET    /projects/:project/hooks/:hook/url_variables/:key` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523476
  * `PUT    /projects/:project/hooks/:hook/url_variables/:key` https://gitlab.kitware.com/help/api/project_webhooks.md#set-a-url-variable
  * `DELETE /projects/:project/hooks/:hook/url_variables/:key` https://gitlab.kitware.com/help/api/project_webhooks.md#delete-a-url-variable
  * `POST   /projects/:project/housekeeping` https://gitlab.kitware.com/help/api/projects.md#start-the-housekeeping-task-for-a-project
  * `POST   /projects/:project/import_project_members/:project2` https://gitlab.kitware.com/help/api/projects.md#import-members
  * `POST   /projects/:project/issues/:issue/add_spent_time` https://gitlab.kitware.com/help/api/issues.md#add-spent-time-for-an-issue
  * `POST   /projects/:project/issues/:issue/clone` https://gitlab.kitware.com/help/api/issues.md#clone-an-issue
  * `GET    /projects/:project/issues/:issue/discussions` https://gitlab.kitware.com/help/api/discussions.md#list-project-issue-discussion-items
  * `POST   /projects/:project/issues/:issue/discussions` https://gitlab.kitware.com/help/api/discussions.md#create-new-issue-thread
  * `GET    /projects/:project/issues/:issue/discussions/:discussion` https://gitlab.kitware.com/help/api/discussions.md#get-single-issue-discussion-item
  * `POST   /projects/:project/issues/:issue/discussions/:discussion/notes` https://gitlab.kitware.com/help/api/discussions.md#add-note-to-existing-issue-thread
  * `PUT    /projects/:project/issues/:issue/discussions/:discussion/notes/:note` https://gitlab.kitware.com/help/api/discussions.md#modify-existing-issue-thread-note
  * `DELETE /projects/:project/issues/:issue/discussions/:discussion/notes/:note` https://gitlab.kitware.com/help/api/discussions.md#delete-an-issue-thread-note
  * `GET    /projects/:project/issues/:issue/notes/:note` https://gitlab.kitware.com/help/api/notes.md#get-single-issue-note
  * `GET    /projects/:project/issues/:issue/metric_images` https://gitlab.kitware.com/help/api/issues.md#list-metric-images
  * `POST   /projects/:project/issues/:issue/metric_images` https://gitlab.kitware.com/help/api/issues.md#upload-metric-image
  * `PUT    /projects/:project/issues/:issue/metric_images/:metric_image` https://gitlab.kitware.com/help/api/issues.md#update-metric-image
  * `DELETE /projects/:project/issues/:issue/metric_images/:metric_image` https://gitlab.kitware.com/help/api/issues.md#delete-metric-image
  * `POST   /projects/:project/issues/:issue/move` https://gitlab.kitware.com/help/api/issues.md#move-an-issue
  * `GET    /projects/:project/issues/:issue/participants` https://gitlab.kitware.com/help/api/issues.md#participants-on-issues
  * `POST   /projects/:project/issues/:issue/promote` Does not exist, but should
    https://gitlab.com/gitlab-org/gitlab/-/issues/523466
  * `PUT    /projects/:project/issues/:issue/reorder` https://gitlab.kitware.com/help/api/issues.md#reorder-an-issue
    Arguably this should be a `POST` endpoint
    https://gitlab.com/gitlab-org/gitlab/-/issues/523479
  * `POST   /projects/:project/issues/:issue/reset_spent_time` https://gitlab.kitware.com/help/api/issues.md#reset-spent-time-for-an-issue
  * `POST   /projects/:project/issues/:issue/reset_time_estimate` https://gitlab.kitware.com/help/api/issues.md#reset-the-time-estimate-for-an-issue
  * `GET    /projects/:project/issues/:issue/resource_label_events/:event` https://gitlab.kitware.com/help/api/resource_label_events.md#get-single-issue-label-event
  * `POST   /projects/:project/issues/:issue/subscribe` https://gitlab.kitware.com/help/api/issues.md#subscribe-to-an-issue
  * `POST   /projects/:project/issues/:issue/time_estimate` https://gitlab.kitware.com/help/api/issues.md#set-a-time-estimate-for-an-issue
  * `GET    /projects/:project/issues/:issue/time_stats` https://gitlab.kitware.com/help/api/issues.md#get-time-tracking-stats
  * `POST   /projects/:project/issues/:issue/todo` https://gitlab.kitware.com/help/api/issues.md#create-a-to-do-item
  * `POST   /projects/:project/issues/:issue/unsubscribe` https://gitlab.kitware.com/help/api/issues.md#unsubscribe-from-an-issue
  * `GET    /projects/:project/issues/:issue/user_agent_detail` https://gitlab.kitware.com/help/api/issues.md#get-user-agent-details
  * `POST   /projects/:project/labels/:label/subscribe` https://gitlab.kitware.com/help/api/labels.md#subscribe-to-a-label
  * `POST   /projects/:project/labels/:label/unsubscribe` https://gitlab.kitware.com/help/api/labels.md#unsubscribe-from-a-label
  * `GET    /projects/:project/languages` https://gitlab.kitware.com/help/api/projects.md#list-programming-languages-used
  * `DELETE /projects/:project/merge_requests/:merge_request` https://gitlab.kitware.com/help/api/merge_requests.md#delete-a-merge-request
  * `POST   /projects/:project/merge_requests/:merge_request/add_spent_time` https://gitlab.kitware.com/help/api/merge_requests.md#add-spent-time-for-a-merge-request
  * `POST   /projects/:project/merge_requests/:merge_request/approval_rules` https://gitlab.kitware.com/help/api/merge_request_approvals.md#get-merge-request-level-rules
  * `GET    /projects/:project/merge_requests/:merge_request/approval_rules/:approval_rule` https://gitlab.kitware.com/help/api/merge_request_approvals.md#get-a-single-merge-request-level-rule
  * `PUT    /projects/:project/merge_requests/:merge_request/approval_rules/:approval_rule` https://gitlab.kitware.com/help/api/merge_request_approvals.md#update-merge-request-rule
  * `DELETE /projects/:project/merge_requests/:merge_request/approval_rules/:approval_rule` https://gitlab.kitware.com/help/api/merge_request_approvals.md#delete-merge-request-rule
  * `POST   /projects/:project/merge_requests/:merge_request/award_emoji` https://gitlab.kitware.com/help/api/award_emoji.md#award-a-new-emoji
  * `GET    /projects/:project/merge_requests/:merge_request/award_emoji/:award` https://gitlab.kitware.com/help/api/award_emoji.md#get-single-award-emoji
  * `DELETE /projects/:project/merge_requests/:merge_request/award_emoji/:award` https://gitlab.kitware.com/help/api/award_emoji.md#delete-an-award-emoji
  * `GET    /projects/:project/merge_requests/:merge_request/blockees` https://gitlab.kitware.com/help/api/merge_requests.md#get-merge-request-blocked-mrs
  * `GET    /projects/:project/merge_requests/:merge_request/blocks` https://gitlab.kitware.com/help/api/merge_requests.md#get-merge-request-dependencies
  * `POST   /projects/:project/merge_requests/:merge_request/blocks` https://gitlab.kitware.com/help/api/merge_requests.md#create-a--merge-request-dependencies
  * `DELETE /projects/:project/merge_requests/:merge_request/blocks/:block_id` https://gitlab.kitware.com/help/api/merge_requests.md#delete-a-merge-request-dependency
  * `POST   /projects/:project/merge_requests/:merge_request/cancel_merge_when_pipeline_succeeds` https://gitlab.kitware.com/help/api/merge_requests.md#cancel-merge-when-pipeline-succeeds
  * `GET    /projects/:project/merge_requests/:merge_request/discussions/:discussion` https://gitlab.kitware.com/help/api/discussions.md#get-single-merge-request-discussion-item
  * `PUT    /projects/:project/merge_requests/:merge_request/discussions/:discussion` https://gitlab.kitware.com/help/api/discussions.md#resolve-a-merge-request-thread
  * `POST   /projects/:project/merge_requests/:merge_request/discussions/:discussion/notes` https://gitlab.kitware.com/help/api/discussions.md#add-note-to-existing-merge-request-thread
  * `PUT    /projects/:project/merge_requests/:merge_request/discussions/:discussion/notes/:note` https://gitlab.kitware.com/help/api/discussions.md#modify-an-existing-merge-request-thread-note
  * `DELETE /projects/:project/merge_requests/:merge_request/discussions/:discussion/notes/:note` https://gitlab.kitware.com/help/api/discussions.md#delete-a-merge-request-thread-note
  * `GET    /projects/:project/merge_requests/:merge_request/merge_ref` https://gitlab.kitware.com/help/api/merge_requests.md#merge-to-default-merge-ref-path
    This should probably be a `POST` event?
  * `GET    /projects/:project/merge_requests/:merge_request/notes/:note` https://gitlab.kitware.com/help/api/notes.md#get-single-merge-request-note
  * `DELETE /projects/:project/merge_requests/:merge_request/notes/:note` https://gitlab.kitware.com/help/api/notes.md#delete-a-merge-request-note
  * `GET    /projects/:project/merge_requests/:merge_request/participants` https://gitlab.kitware.com/help/api/merge_requests.md#get-single-mr-participants
  * `RAW    /projects/:project/merge_requests/:merge_request/raw_diffs` https://gitlab.kitware.com/help/api/merge_requests.md#show-merge-request-raw-diffs
  * `GET    /projects/:project/merge_requests/:merge_request/related_issues` https://gitlab.kitware.com/help/api/merge_requests.md#list-issues-related-to-the-merge-request
  * `PUT    /projects/:project/merge_requests/:merge_request/reset_approvals` https://gitlab.kitware.com/help/api/merge_request_approvals.md#reset-approvals-of-a-merge-request
    This should probably be a `POST` event.
    https://gitlab.com/gitlab-org/gitlab/-/issues/523480
  * `POST   /projects/:project/merge_requests/:merge_request/reset_spent_time` https://gitlab.kitware.com/help/api/merge_requests.md#reset-spent-time-for-a-merge-request
  * `POST   /projects/:project/merge_requests/:merge_request/reset_time_estimate` https://gitlab.kitware.com/help/api/merge_requests.md#reset-the-time-estimate-for-a-merge-request
  * `GET    /projects/:project/merge_requests/:merge_request/resource_label_events/:event` https://gitlab.kitware.com/help/api/resource_label_events.md#get-single-merge-request-label-event
  * `GET    /projects/:project/merge_requests/:merge_request/reviewers` https://gitlab.kitware.com/help/api/resource_label_events.md#get-single-mr-reviewers
  * `POST   /projects/:project/merge_requests/:merge_request/subscribe` https://gitlab.kitware.com/help/api/merge_requests.md#subscribe-to-a-merge-request
  * `POST   /projects/:project/merge_requests/:merge_request/time_estimate` https://gitlab.kitware.com/help/api/merge_requests.md#set-a-time-estimate-for-a-merge-request
  * `GET    /projects/:project/merge_requests/:merge_request/time_stats` https://gitlab.kitware.com/help/api/merge_requests.md#get-time-tracking-stats
  * `POST   /projects/:project/merge_requests/:merge_request/todo` https://gitlab.kitware.com/help/api/merge_requests.md#create-a-to-do-item
  * `POST   /projects/:project/merge_requests/:merge_request/unsubscribe` https://gitlab.kitware.com/help/api/merge_requests.md#unsubscribe-from-a-merge-request
  * `GET    /projects/:project/merge_requests/:merge_request/versions` https://gitlab.kitware.com/help/api/merge_requests.md#get-mr-diff-versions
  * `GET    /projects/:project/merge_requests/:merge_request/versions/:version` https://gitlab.kitware.com/help/api/merge_requests.md#get-a-single-mr-diff-version
  * `GET    /projects/:project/merge_trains/:target_branch` https://gitlab.kitware.com/help/api/merge_trains.md#list-merge-requests-in-a-merge-train
  * `GET    /projects/:project/merge_trains/merge_requests/:merge_request` https://gitlab.kitware.com/help/api/merge_trains.md#get-the-status-of-a-merge-request-on-a-merge-train
  * `POST   /projects/:project/merge_trains/merge_requests/:merge_request` https://gitlab.kitware.com/help/api/merge_trains.md#add-a-merge-request-to-a-merge-train
  * `GET    /projects/:project/milestones` https://gitlab.kitware.com/help/api/milestones.md#list-project-milestones
  * `GET    /projects/:project/milestones/:milestone` https://gitlab.kitware.com/help/api/milestones.md#get-single-milestone
  * `PUT    /projects/:project/milestones/:milestone` https://gitlab.kitware.com/help/api/milestones.md#edit-milestone
  * `DELETE /projects/:project/milestones/:milestone` https://gitlab.kitware.com/help/api/milestones.md#delete-project-milestone
  * `GET    /projects/:project/milestones/:milestone/burndown_events` https://gitlab.kitware.com/help/api/milestones.md#get-all-burndown-chart-events-for-a-single-milestone-starter
  * `GET    /projects/:project/milestones/:milestone/issues` https://gitlab.kitware.com/help/api/milestones.md#get-all-issues-assigned-to-a-single-milestone
  * `GET    /projects/:project/milestones/:milestone/merge_requests` https://gitlab.kitware.com/help/api/milestones.md#get-all-merge-requests-assigned-to-a-single-milestone
  * `POST   /projects/:project/milestones/:milestone/promote` https://gitlab.kitware.com/help/api/milestones.md#promote-project-milestone-to-a-group-milestone
  * `GET    /projects/:project/mirror/pull` https://gitlab.kitware.com/help/api/project_pull_mirroring.md#get-a-projects-pull-mirror-details
  * `POST   /projects/:project/mirror/pull` https://gitlab.kitware.com/help/api/project_pull_mirroring.md#start-the-pull-mirroring-process-for-a-project
  * `PUT    /projects/:project/mirror/pull` https://gitlab.kitware.com/help/api/project_pull_mirroring.md#configure-pull-mirroring-for-a-project
  * `GET    /projects/:project/packages/:package/pipelines` https://gitlab.kitware.com/help/api/packages.md#list-package-pipelines
  * `PATCH  /projects/:project/protected_branches/:branch` https://gitlab.kitware.com/help/api/protected_branches.md#require-code-owner-approvals-for-a-single-branch
  * `POST   /projects/:project/pipeline` https://gitlab.kitware.com/help/api/pipelines.md#create-a-new-pipeline
  * `GET    /projects/:project/pipeline/latest` https://gitlab.kitware.com/help/api/pipelines.md#get-the-latest-pipeline
  * `PUT    /projects/:project/pipelines/:pipeline/metadata` https://gitlab.kitware.com/help/api/pipelines.md#update-pipeline-metadata
  * `GET    /projects/:project/push_rule` https://gitlab.kitware.com/help/api/project_push_rules.md#get-project-push-rules
  * `POST   /projects/:project/push_rule` https://gitlab.kitware.com/help/api/project_push_rules.md#add-project-push-rule
  * `DELETE /projects/:project/push_rule` https://gitlab.kitware.com/help/api/project_push_rules.md#delete-project-push-rule
  * `PUT    /projects/:project/releases/:tag_name` https://gitlab.kitware.com/help/api/releases/_index.md#update-a-release
  * `DELETE /projects/:project/releases/:tag_name` https://gitlab.kitware.com/help/api/releases/_index.md#delete-a-release
  * `GET    /projects/:project/releases/:tag_name/downloads/:asset_path` https://gitlab.kitware.com/help/api/releases/_index.md#download-a-release-asset
  * `POST   /projects/:project/releases/:tag_name/evidence` https://gitlab.kitware.com/help/api/releases/_index.md#collect-release-evidence
  * `GET    /projects/:project/releases/permalink/latest` https://gitlab.kitware.com/help/api/releases/_index.md#get-the-latest-release
  * `GET    /projects/:project/releases/permalink/latest/downloads/:asset_path` https://gitlab.kitware.com/help/api/releases/_index.md#get-the-latest-release
  * `POST   /projects/:project/releases/permalink/latest/evidence` https://gitlab.kitware.com/help/api/releases/_index.md#get-the-latest-release
  * `GET    /projects/:project/repository/blobs/:sha` https://gitlab.kitware.com/help/api/repositories.md#get-a-blob-from-repository
  * `GET    /projects/:project/repository/blobs/:sha/raw` https://gitlab.kitware.com/help/api/repositories.md#raw-blob-content
  * `GET    /projects/:project/repository/changelog` https://gitlab.kitware.com/help/api/repositories.md#generate-changelog-data
  * `POST   /projects/:project/repository/changelog` https://gitlab.kitware.com/help/api/repositories.md#add-changelog-data-to-a-changelog-file
  * `POST   /projects/:project/repository/commits/:sha/cherry_pick` https://gitlab.kitware.com/help/api/commits.md#cherry-pick-a-commit
  * `GET    /projects/:project/repository/commits/:sha/diff` https://gitlab.kitware.com/help/api/commits.md#get-the-diff-of-a-commit
  * `GET    /projects/:project/repository/commits/:sha/discussions` https://gitlab.kitware.com/help/api/commits.md#get-the-discussions-of-a-commit
  * `POST   /projects/:project/repository/commits/:sha/revert` https://gitlab.kitware.com/help/api/commits.md#revert-a-commit
  * `HEAD   /projects/:project/repository/files/*file_path` https://gitlab.kitware.com/help/api/repository_files.md#get-file-from-repository
  * `GET    /projects/:project/repository/files/*file_path/blame` https://gitlab.kitware.com/help/api/repository_files.md#get-file-blame-from-repository
  * `GET    /projects/:project/repository/health` https://gitlab.kitware.com/help/api/repositories.md#health
  * `GET    /projects/:project/repository/merge_base` https://gitlab.kitware.com/help/api/repositories.md#merge-base
  * `DELETE /projects/:project/repository/merged_branches` https://gitlab.kitware.com/help/api/branches.md#delete-merged-branches
    Arguably this should be `POST /projects/:project/repository/delete_merged_branches`
    https://gitlab.com/gitlab-org/gitlab/-/issues/523481
  * `GET    /projects/:project/repository/tags/:tag/signature` https://gitlab.kitware.com/help/api/tags.md#get-x509-signature-of-a-tag
  * `POST   /projects/:project/restore` https://gitlab.kitware.com/help/api/projects.md#restore-a-project-marked-for-deletion
  * `POST   /projects/:project/security_scans/sast/scan` https://gitlab.kitware.com/help/api/projects.md#real-time-security-scan
  * `GET    /projects/:project/share_locations` https://gitlab.kitware.com/help/api/projects.md#list-shareable-groups
  * `GET    /projects/:project/snapshot` https://gitlab.kitware.com/help/api/projects.md#download-snapshot-of-a-git-repository
  * `GET    /projects/:project/snippets/:snippet/award_emoji` https://gitlab.kitware.com/help/api/award_emoji.md#list-an-awardables-award-emoji
  * `POST   /projects/:project/snippets/:snippet/award_emoji` https://gitlab.kitware.com/help/api/award_emoji.md#award-a-new-emoji
  * `GET    /projects/:project/snippets/:snippet/award_emoji/:award` https://gitlab.kitware.com/help/api/award_emoji.md#get-single-award-emoji
  * `DELETE /projects/:project/snippets/:snippet/award_emoji/:award` https://gitlab.kitware.com/help/api/award_emoji.md#delete-an-award-emoji
  * `GET    /projects/:project/snippets/:snippet/discussions` https://gitlab.kitware.com/help/api/discussions.md#list-project-snippet-discussion-items
  * `POST   /projects/:project/snippets/:snippet/discussions` https://gitlab.kitware.com/help/api/discussions.md#create-new-snippet-thread
  * `GET    /projects/:project/snippets/:snippet/discussions/:discussion` https://gitlab.kitware.com/help/api/discussions.md#get-single-snippet-discussion-item
  * `POST   /projects/:project/snippets/:snippet/discussions/:discussion/notes` https://gitlab.kitware.com/help/api/discussions.md#add-note-to-existing-snippet-thread
  * `PUT    /projects/:project/snippets/:snippet/discussions/:discussion/notes/:note` https://gitlab.kitware.com/help/api/discussions.md#modify-existing-snippet-thread-note
  * `DELETE /projects/:project/snippets/:snippet/discussions/:discussion/notes/:note` https://gitlab.kitware.com/help/api/discussions.md#delete-a-snippet-thread-note
  * `GET    /projects/:project/snippets/:snippet/notes` https://gitlab.kitware.com/help/api/notes.md#snippets
  * `POST   /projects/:project/snippets/:snippet/notes` https://gitlab.kitware.com/help/api/notes.md#get-single-snippet-note
  * `GET    /projects/:project/snippets/:snippet/notes/:note` https://gitlab.kitware.com/help/api/notes.md#get-single-snippet-note
  * `PUT    /projects/:project/snippets/:snippet/notes/:note` https://gitlab.kitware.com/help/api/notes.md#modify-existing-snippet-note
  * `DELETE /projects/:project/snippets/:snippet/notes/:note` https://gitlab.kitware.com/help/api/notes.md#delete-a-snippet-note
  * `GET    /projects/:project/snippets/:snippet/notes/:note/award_emoji` https://gitlab.kitware.com/help/api/award_emoji.md#list-a-comments-award-emoji
  * `POST   /projects/:project/snippets/:snippet/notes/:note/award_emoji` https://gitlab.kitware.com/help/api/award_emoji.md#award-a-new-emoji-on-a-comment
  * `GET    /projects/:project/snippets/:snippet/notes/:note/award_emoji/:award` https://gitlab.kitware.com/help/api/award_emoji.md#get-an-award-emoji-for-a-comment
  * `DELETE /projects/:project/snippets/:snippet/notes/:note/award_emoji/:award` https://gitlab.kitware.com/help/api/award_emoji.md#delete-an-award-emoji-from-a-comment
  * `GET    /projects/:project/storage` https://gitlab.kitware.com/help/api/projects.md#get-the-path-to-repository-storage
  * `PUT    /projects/:project/transfer` https://gitlab.kitware.com/help/api/projects.md#transfer-a-project-to-a-new-namespace
  * `GET    /projects/:project/transfer_locations` https://gitlab.kitware.com/help/api/projects.md#list-groups-available-for-project-transfer
  * `POST   /projects/:project/uploads` https://gitlab.kitware.com/help/api/projects.md#upload-a-file
  * `GET    /projects/:project/users` https://gitlab.kitware.com/help/api/projects.md#list-users
  * `POST   /projects/user/:user` https://gitlab.kitware.com/help/api/projects.md#create-a-project-for-a-user
  * `GET    /runners/:runner/managers` https://gitlab.kitware.com/help/api/runners.md#ist-runners-managers
  * `GET    /service_accounts` https://gitlab.kitware.com/help/api/user_service_accounts.md#list-all-service-account-users
  * `POST   /service_accounts` https://gitlab.kitware.com/help/api/user_service_accounts.md#create-a-service-account-user
  * `GET    /user/activities` https://gitlab.kitware.com/help/api/users.md#list-a-users-activity
  * `GET    /user/avatar` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523467
  * `PUT    /user/avatar` https://gitlab.kitware.com/help/api/users.md#upload-an-avatar-for-yourself
  * `DELETE /user/avatar` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523467
  * `PATCH  /user/disable_two_factor` https://gitlab.kitware.com/help/api/users.md#disable-two-factor-authentication
  * `GET    /user/emails` https://gitlab.kitware.com/help/api/user_email_addresses.md#list-all-email-emails
  * `POST   /user/emails` https://gitlab.kitware.com/help/api/user_email_addresses.md#add-an-email-address
  * `GET    /user/emails/:email` https://gitlab.kitware.com/help/api/user_email_addresses.md#get-details-on-an-email-address
  * `DELETE /user/emails/:email` https://gitlab.kitware.com/help/api/user_email_addresses.md#delete-an-email-address
  * `GET    /user/gpg_keys` https://gitlab.kitware.com/help/api/user_keys.md#list-all-gpg-keys
  * `POST   /user/gpg_keys` https://gitlab.kitware.com/help/api/user_keys.md#add-a-gpg-key
  * `GET    /user/gpg_keys/:gpg_key` https://gitlab.kitware.com/help/api/user_keys.md#get-a-gpg-key
  * `DELETE /user/gpg_keys/:gpg_key` https://gitlab.kitware.com/help/api/user_keys.md#delete-a-gpg-key
  * `GET    /user/keys` https://gitlab.kitware.com/help/api/user_keys.md#list-all-ssh-keys
  * `POST   /user/keys` https://gitlab.kitware.com/help/api/user_keys.md#add-an-ssh-key
  * `GET    /user/keys/:key` https://gitlab.kitware.com/help/api/user_keys.md#get-an-ssh-key
  * `DELETE /user/keys/:key` https://gitlab.kitware.com/help/api/user_keys.md#delete-an-ssh-key
  * `POST   /user/personal_access_tokens` https://gitlab.kitware.com/help/api/users.md#create-a-personal-access-token-with-limited-scopes-for-the-currently-authenticated-user
  * `GET    /user/preferences` https://gitlab.kitware.com/help/api/users.md#get-your-user-preferences
  * `PUT    /user/preferences` https://gitlab.kitware.com/help/api/users.md#update-your-user-preferences
  * `GET    /user/status` https://gitlab.kitware.com/help/api/users.md#user-status
  * `PUT    /user/status` https://gitlab.kitware.com/help/api/users.md#set-user-status
    Note that this clears `emoji`, `message`, and `clear_status_after` if they're not present. Prefer `PATCH`.
  * `PATCH  /user/status` https://gitlab.kitware.com/help/api/users.md#set-user-status
  * `GET    /user/support_pin` https://gitlab.kitware.com/help/api/users.md#get-details-on-a-support-pin
  * `POST   /user/support_pin` https://gitlab.kitware.com/help/api/users.md#create-a-support-pin
  * `DELETE /users/:user` https://gitlab.kitware.com/help/api/users.md#delete-a-user
  * `PUT    /users/:user` https://gitlab.kitware.com/help/api/users.md#modify-a-user
  * `POST   /users/:user/activate` https://gitlab.kitware.com/help/api/user_moderation.md#activate-a-user
  * `GET    /users/:user/associations_count` https://gitlab.kitware.com/help/api/users.md#get-a-count-of-a-users-projects-groups-issues-and-merge-requests
  * `POST   /users/:user/approve` https://gitlab.kitware.com/help/api/user_moderation.md#approve-access-to-a-user
  * `GET    /user/:user/avatar` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523467
  * `PUT    /user/:user/avatar` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523467
  * `DELETE /user/:user/avatar` Missing, but should exist
    https://gitlab.com/gitlab-org/gitlab/-/issues/523467
  * `POST   /users/:user/ban` https://gitlab.kitware.com/help/api/user_moderation.md#ban-a-user
  * `POST   /users/:user/block` https://gitlab.kitware.com/help/api/user_moderation.md#block-access-to-a-user
  * `GET    /users/:user/contributed_projects` https://gitlab.kitware.com/help/api/projects.md#list-projects-a-user-has-contributed-to
  * `POST   /users/:user/deactivate` https://gitlab.kitware.com/help/api/user_moderation.md#deactivate-a-user
  * `PATCH  /users/:user/disable_two_factor` https://gitlab.kitware.com/help/api/users.md#disable-two-factor-authentication-for-a-user
  * `GET    /users/:user/emails` https://gitlab.kitware.com/help/api/user_email_addresses.md#list-all-emails-for-user
  * `POST   /users/:user/emails` https://gitlab.kitware.com/help/api/user_email_addresses.md#add-an-email-address-for-user
  * `DELETE /users/:user/emails/:email` https://gitlab.kitware.com/help/api/user_email_addresses.md#delete-an-email-address-for-a-user
  * `GET    /users/:user/followers` https://gitlab.kitware.com/help/api/user_follow_unfollow.md#list-all-accounts-that-follow-a-user
  * `GET    /users/:user/following` https://gitlab.kitware.com/help/api/user_follow_unfollow.md#list-all-accounts-followed-by-a-user
  * `POST   /users/:user/follow` https://gitlab.kitware.com/help/api/user_follow_unfollow.md#follow-a-user
  * `GET    /users/:user/gpg_keys` https://gitlab.kitware.com/help/api/user_keys.md#list-all-gpg-keys-for-a-user
  * `POST   /users/:user/gpg_keys` https://gitlab.kitware.com/help/api/user_keys.md#add-a-gpg-key-for-a-user
  * `GET    /users/:user/gpg_keys/:gpg_key` https://gitlab.kitware.com/help/api/user_keys.md#get-a-gpg-key-for-a-user
  * `DELETE /users/:user/gpg_keys/:gpg_key` https://gitlab.kitware.com/help/api/user_keys.md#delete-a-gpg-key-for-a-user
  * `DELETE /users/:user/identities/:provider` https://gitlab.kitware.com/help/api/users.md#delete-authentication-identity-from-a-user
  * `GET    /users/:user/keys` https://gitlab.kitware.com/help/api/user_keys.md#list-all-ssh-keys-for-a-user
  * `POST   /users/:user/keys` https://gitlab.kitware.com/help/api/user_keys.md#add-an-ssh-key-for-user
  * `GET    /users/:user/keys/:key` https://gitlab.kitware.com/help/api/user_keys.md#get-an-ssh-key-for-a-user
  * `DELETE /users/:user/keys/:key` https://gitlab.kitware.com/help/api/user_keys.md#delete-an-ssh-key-for-a-user
  * `GET    /users/:user/memberships` https://gitlab.kitware.com/help/api/users.md#list-projects-and-groups-that-a-user-is-a-member-of
  * `GET    /users/:user/project_deploy_keys` https://gitlab.kitware.com/help/api/deploy_keys.md#list-project-deploy-keys-for-user
  * `POST   /users/:user/reject` https://gitlab.kitware.com/help/api/user_moderation.md#reject-access-to-a-user
  * `GET    /users/:user/starred_projects` https://gitlab.kitware.com/help/api/project_starring.md#list-projects-starred-by-a-user
  * `GET    /users/:user/status` https://gitlab.kitware.com/help/api/users.md#get-the-status-of-a-user
  * `GET    /users/:user/support_pin` https://gitlab.kitware.com/help/api/users.md#get-a-support-pin-for-a-user
  * `POST   /users/:user/unban` https://gitlab.kitware.com/help/api/user_moderation.md#unban-a-user
  * `POST   /users/:user/unblock` https://gitlab.kitware.com/help/api/user_moderation.md#unblock-access-to-a-user
  * `POST   /users/:user/unfollow` https://gitlab.kitware.com/help/api/user_follow_unfollow.md#unfollow-a-user
  * `GET    /user_counts` https://gitlab.kitware.com/help/api/users.md#get-a-count-of-your-assigned-issues-merge-requests-and-reviews
  * `GET    /v2/_catalog` https://gitlab.kitware.com/help/api/container_registry.md#listing-all-container-repositories

## Pages to watch

These pages are separate from the standard REST API docs and could have changes in the future:

 * https://docs.gitlab.com/ee/user/packages/generic_packages/

## Endpoint groups

These pages have had their endpoints listed above:

  * https://gitlab.kitware.com/help/api/access_requests.md
  * https://gitlab.kitware.com/help/api/branches.md
  * https://gitlab.kitware.com/help/api/commits.md
  * https://gitlab.kitware.com/help/api/deploy_keys.md
  * https://gitlab.kitware.com/help/api/deployments.md
  * https://gitlab.kitware.com/help/api/discussions.md
  * https://gitlab.kitware.com/help/api/emoji_reactions.md
  * https://gitlab.kitware.com/help/api/environments.md
  * https://gitlab.kitware.com/help/api/group_level_variables.md
  * https://gitlab.kitware.com/help/api/group_milestones.md
  * https://gitlab.kitware.com/help/api/group_push_rules.md
  * https://gitlab.kitware.com/help/api/group_service_accounts.md
  * https://gitlab.kitware.com/help/api/group_webhooks.md
  * https://gitlab.kitware.com/help/api/groups.md
  * https://gitlab.kitware.com/help/api/issues.md
  * https://gitlab.kitware.com/help/api/job_artifacts.md
  * https://gitlab.kitware.com/help/api/jobs.md
  * https://gitlab.kitware.com/help/api/labels.md
  * https://gitlab.kitware.com/help/api/members.md
  * https://gitlab.kitware.com/help/api/merge_request_approvals.md
  * https://gitlab.kitware.com/help/api/merge_requests.md
  * https://gitlab.kitware.com/help/api/merge_trains.md
  * https://gitlab.kitware.com/help/api/milestones.md
  * https://gitlab.kitware.com/help/api/notes.md (finish review)
  * https://gitlab.kitware.com/help/api/packages.md
  * https://gitlab.kitware.com/help/api/personal_access_tokens.md
  * https://gitlab.kitware.com/help/api/pipeline_schedules.md
  * https://gitlab.kitware.com/help/api/pipelines.md
  * https://gitlab.kitware.com/help/api/project_access_tokens.md
  * https://gitlab.kitware.com/help/api/project_forks.md
  * https://gitlab.kitware.com/help/api/project_level_variables.md
  * https://gitlab.kitware.com/help/api/project_push_rules.md
  * https://gitlab.kitware.com/help/api/project_starring.md
  * https://gitlab.kitware.com/help/api/project_webhooks.md
  * https://gitlab.kitware.com/help/api/projects.md (finish review)
  * https://gitlab.kitware.com/help/api/protected_branches.md
  * https://gitlab.kitware.com/help/api/protected_tags.md
  * https://gitlab.kitware.com/help/api/project_pull_mirroring.md
  * https://gitlab.kitware.com/help/api/releases/_index.md
  * https://gitlab.kitware.com/help/api/releases/links.md
  * https://gitlab.kitware.com/help/api/repositories.md
  * https://gitlab.kitware.com/help/api/repository_files.md
  * https://gitlab.kitware.com/help/api/resource_label_events.md
  * https://gitlab.kitware.com/help/api/runners.md
  * https://gitlab.kitware.com/help/api/tags.md
  * https://gitlab.kitware.com/help/api/user_email_addresses.md
  * https://gitlab.kitware.com/help/api/user_follow_unfollow.md
  * https://gitlab.kitware.com/help/api/user_keys.md
  * https://gitlab.kitware.com/help/api/user_moderation.md
  * https://gitlab.kitware.com/help/api/user_service_accounts.md
  * https://gitlab.kitware.com/help/api/user_tokens.md
  * https://gitlab.kitware.com/help/api/users.md

These pages document other endpoints not mentioned above:

  * https://gitlab.kitware.com/help/api/access_tokens.md
  * https://gitlab.kitware.com/help/api/admin/token.md
  * https://gitlab.kitware.com/help/api/admin_sidekiq_queues.md
  * https://gitlab.kitware.com/help/api/alert_management_alerts.md
  * https://gitlab.kitware.com/help/api/appearance.md
  * https://gitlab.kitware.com/help/api/applications.md
  * https://gitlab.kitware.com/help/api/audit_events.md
    - keyset pagination is supported for group audit events with `order_by=id` and `sort=desc`
  * https://gitlab.kitware.com/help/api/avatar.md
  * https://gitlab.kitware.com/help/api/boards.md
  * https://gitlab.kitware.com/help/api/broadcast_messages.md
  * https://gitlab.kitware.com/help/api/bulk_imports.md
  * https://gitlab.kitware.com/help/api/chat.md
  * https://gitlab.kitware.com/help/api/cluster_agents.md
  * https://gitlab.kitware.com/help/api/cluster_discovery.md
  * https://gitlab.kitware.com/help/api/code_suggestions.md
  * https://gitlab.kitware.com/help/api/container_registry.md
    - only the bits about JWT stuff for Docker registry communication
  * https://gitlab.kitware.com/help/api/container_registry_protection_rules.md
  * https://gitlab.kitware.com/help/api/custom_attributes.md (#66)
  * https://gitlab.kitware.com/help/api/database_migrations.md
  * https://gitlab.kitware.com/help/api/dependencies.md
  * https://gitlab.kitware.com/help/api/dependency_list_export.md
  * https://gitlab.kitware.com/help/api/dependency_proxy.md
  * https://gitlab.kitware.com/help/api/deploy_tokens.md
  * https://gitlab.kitware.com/help/api/dora/metrics.md
  * https://gitlab.kitware.com/help/api/draft_notes.md
  * https://gitlab.kitware.com/help/api/epic_issues.md (deprecated in 17.0)
  * https://gitlab.kitware.com/help/api/epic_links.md (deprecated in 17.0)
  * https://gitlab.kitware.com/help/api/epics.md (deprecated in 17.0)
  * https://gitlab.kitware.com/help/api/error_tracking.md
  * https://gitlab.kitware.com/help/api/events.md (#25)
  * https://gitlab.kitware.com/help/api/experiments.md
  * https://gitlab.kitware.com/help/api/feature_flag_users_lists.md
  * https://gitlab.kitware.com/help/api/feature_flags.md
  * https://gitlab.kitware.com/help/api/features.md
  * https://gitlab.kitware.com/help/api/freeze_periods.md
  * https://gitlab.kitware.com/help/api/geo_nodes.md (deprecated in 16.0)
  * https://gitlab.kitware.com/help/api/geo_sites.md
  * https://gitlab.kitware.com/help/api/google_cloud_integration.md
  * https://gitlab.kitware.com/help/api/group_access_tokens.md
  * https://gitlab.kitware.com/help/api/group_activity_analytics.md
  * https://gitlab.kitware.com/help/api/group_badges.md
  * https://gitlab.kitware.com/help/api/group_boards.md
  * https://gitlab.kitware.com/help/api/group_clusters.md (deprecated in 14.5)
  * https://gitlab.kitware.com/help/api/group_enterprise_users.md
  * https://gitlab.kitware.com/help/api/group_epic_boards.md
  * https://gitlab.kitware.com/help/api/group_import_export.md
  * https://gitlab.kitware.com/help/api/group_integrations.md
  * https://gitlab.kitware.com/help/api/group_iterations.md
  * https://gitlab.kitware.com/help/api/group_labels.md
  * https://gitlab.kitware.com/help/api/group_ldap_links.md
  * https://gitlab.kitware.com/help/api/group_markdown_uploads.md
  * https://gitlab.kitware.com/help/api/group_protected_branches.md
  * https://gitlab.kitware.com/help/api/group_protected_environments.md
  * https://gitlab.kitware.com/help/api/group_relations_export.md
  * https://gitlab.kitware.com/help/api/group_releases.md
  * https://gitlab.kitware.com/help/api/group_repository_storage_moves.md
  * https://gitlab.kitware.com/help/api/group_security_settings.md
  * https://gitlab.kitware.com/help/api/group_ssh_certificates.md
  * https://gitlab.kitware.com/help/api/group_wikis.md
  * https://gitlab.kitware.com/help/api/import.md
  * https://gitlab.kitware.com/help/api/instance_clusters.md
  * https://gitlab.kitware.com/help/api/instance_level_ci_variables.md
  * https://gitlab.kitware.com/help/api/integrations.md
  * https://gitlab.kitware.com/help/api/invitations.md
  * https://gitlab.kitware.com/help/api/issue_links.md
  * https://gitlab.kitware.com/help/api/issues_statistics.md
  * https://gitlab.kitware.com/help/api/iterations.md
  * https://gitlab.kitware.com/help/api/keys.md
  * https://gitlab.kitware.com/help/api/license.md
  * https://gitlab.kitware.com/help/api/linked_epics.md (deprecated in 17.0)
  * https://gitlab.kitware.com/help/api/lint.md
  * https://gitlab.kitware.com/help/api/managed_licenses.md
  * https://gitlab.kitware.com/help/api/markdown.md
  * https://gitlab.kitware.com/help/api/member_roles.md
  * https://gitlab.kitware.com/help/api/merge_request_approval_settings.md
  * https://gitlab.kitware.com/help/api/merge_request_context_commits.md
  * https://gitlab.kitware.com/help/api/metadata.md
  * https://gitlab.kitware.com/help/api/model_registry.md
  * https://gitlab.kitware.com/help/api/namespaces.md
  * https://gitlab.kitware.com/help/api/notification_settings.md
  * https://gitlab.kitware.com/help/api/oauth2.md
  * https://gitlab.kitware.com/help/api/organizations.md
  * https://gitlab.kitware.com/help/api/packages/composer.md
  * https://gitlab.kitware.com/help/api/packages/conan.md
  * https://gitlab.kitware.com/help/api/packages/debian_group_distributions.md
  * https://gitlab.kitware.com/help/api/packages/debian_project_distributions.md
  * https://gitlab.kitware.com/help/api/packages/debian.md
  * https://gitlab.kitware.com/help/api/packages/go_proxy.md
  * https://gitlab.kitware.com/help/api/packages/helm.md
  * https://gitlab.kitware.com/help/api/packages/maven.md
  * https://gitlab.kitware.com/help/api/packages/npm.md
  * https://gitlab.kitware.com/help/api/packages/nuget.md
  * https://gitlab.kitware.com/help/api/packages/pypi.md
  * https://gitlab.kitware.com/help/api/packages/rubygems.md
  * https://gitlab.kitware.com/help/api/packages/terraform-modules.md
  * https://gitlab.kitware.com/help/api/pages_domains.md
  * https://gitlab.kitware.com/help/api/pipeline_triggers.md
  * https://gitlab.kitware.com/help/api/plan_limits.md
  * https://gitlab.kitware.com/help/api/product_analytics.md
  * https://gitlab.kitware.com/help/api/project_aliases.md
  * https://gitlab.kitware.com/help/api/project_badges.md
  * https://gitlab.kitware.com/help/api/project_clusters.md
  * https://gitlab.kitware.com/help/api/project_container_registry_protection_rules.md
  * https://gitlab.kitware.com/help/api/project_import_export.md
  * https://gitlab.kitware.com/help/api/project_integrations.md
  * https://gitlab.kitware.com/help/api/project_markdown_uploads.md
  * https://gitlab.kitware.com/help/api/project_packages_protection_rules.md
  * https://gitlab.kitware.com/help/api/project_relations_export.md
  * https://gitlab.kitware.com/help/api/project_repository_storage_moves.md
  * https://gitlab.kitware.com/help/api/project_security_settings.md
  * https://gitlab.kitware.com/help/api/project_snippets.md
  * https://gitlab.kitware.com/help/api/project_statistics.md
  * https://gitlab.kitware.com/help/api/project_templates.md
  * https://gitlab.kitware.com/help/api/project_vulnerabilities.md
  * https://gitlab.kitware.com/help/api/protected_environments.md
  * https://gitlab.kitware.com/help/api/remote_mirrors.md
  * https://gitlab.kitware.com/help/api/repository_submodules.md
  * https://gitlab.kitware.com/help/api/resource_groups.md
  * https://gitlab.kitware.com/help/api/resource_iteration_events.md
  * https://gitlab.kitware.com/help/api/resource_milestone_events.md
  * https://gitlab.kitware.com/help/api/resource_state_events.md
  * https://gitlab.kitware.com/help/api/resource_weight_events.md
  * https://gitlab.kitware.com/help/api/saml.md
  * https://gitlab.kitware.com/help/api/scim.md
  * https://gitlab.kitware.com/help/api/search.md
  * https://gitlab.kitware.com/help/api/search_admin.md
  * https://gitlab.kitware.com/help/api/secure_files.md
  * https://gitlab.kitware.com/help/api/settings.md
  * https://gitlab.kitware.com/help/api/sidekiq_metrics.md
  * https://gitlab.kitware.com/help/api/snippet_repository_storage_moves.md
  * https://gitlab.kitware.com/help/api/snippets.md
  * https://gitlab.kitware.com/help/api/statistics.md
  * https://gitlab.kitware.com/help/api/status_checks.md
  * https://gitlab.kitware.com/help/api/suggestions.md
  * https://gitlab.kitware.com/help/api/system_hooks.md
  * https://gitlab.kitware.com/help/api/templates/dockerfiles.md
  * https://gitlab.kitware.com/help/api/templates/gitignores.md
  * https://gitlab.kitware.com/help/api/templates/gitlab_ci_ymls.md
  * https://gitlab.kitware.com/help/api/templates/licenses.md
  * https://gitlab.kitware.com/help/api/todos.md
  * https://gitlab.kitware.com/help/api/topics.md
  * https://gitlab.kitware.com/help/api/usage_data.md
  * https://gitlab.kitware.com/help/api/version.md
  * https://gitlab.kitware.com/help/api/vulnerabilities.md
  * https://gitlab.kitware.com/help/api/vulnerability_exports.md
  * https://gitlab.kitware.com/help/api/vulnerability_findings.md
  * https://gitlab.kitware.com/help/api/web_commits.md
  * https://gitlab.kitware.com/help/api/wikis.md
