// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

//! Project Pages API endpoints.
//!
//! These endpoints are used for managing Pages.

mod edit;
mod pages;
mod unpublish;

pub use self::edit::EditPages;
pub use self::edit::EditPagesBuilder;
pub use self::edit::EditPagesBuilderError;

pub use self::pages::Pages;
pub use self::pages::PagesBuilder;
pub use self::pages::PagesBuilderError;

pub use self::unpublish::UnpublishPages;
pub use self::unpublish::UnpublishPagesBuilder;
pub use self::unpublish::UnpublishPagesBuilderError;
