#!/bin/sh

set -e

readonly version="0.34.1"

case "$( uname -s )-$(uname -m)" in
    Linux-aarch64)
        sha256sum="860b0c5b579a948e4dc227284edc008219d27943b43255c077987a91aa6e3e6f"
        platform="aarch64-unknown-linux-musl"
        ;;
    Linux-x86_64)
        sha256sum="53ce7406f85600d9e5fca539f0b424bc00ff99b7bd5de94a9a5afcc4fe0bddd9"
        platform="x86_64-unknown-linux-musl"
        ;;
    *)
        echo "Unrecognized platform $( uname -s )-$( uname -m )"
        exit 1
        ;;
esac
readonly sha256sum
readonly platform

readonly filename="cargo-tarpaulin-$platform"
readonly tarball="$filename.tar.gz"

cd .gitlab

echo "$sha256sum  $tarball" > tarpaulin.sha256sum
curl -OL "https://github.com/xd009642/tarpaulin/releases/download/$version/$tarball"
sha256sum --check tarpaulin.sha256sum
tar xf "$tarball"
