#!/bin/sh

set -e

readonly version="0.12.0"
readonly build_date="20251027.0"

case "$( uname -s )-$(uname -m)" in
    Linux-aarch64)
        shatool="sha256sum"
        sha256sum="26b5d91c537fb613c6ad4799e95dbb0aab8d35d242529cfd318734a9f1cc1861"
        platform="aarch64-unknown-linux-musl"
        ;;
    Linux-x86_64)
        shatool="sha256sum"
        sha256sum="c1488afc3ac025c847ab6df29611ef14d7b17f01a53be42c1d3d34e16eea9c36"
        platform="x86_64-unknown-linux-musl"
        ;;
    Darwin-x86_64|Darwin-arm64)
        shatool="shasum -a 256"
        sha256sum="21609c6aa55ba03be67d7b3d66a2b12c25ed9ca67c906b24a9f46de9238c3b0c"
        platform="universal-apple-darwin"
        ;;
    *)
        echo "Unrecognized platform $( uname -s )-$( uname -m )"
        exit 1
        ;;
esac
readonly shatool
readonly sha256sum
readonly platform

readonly filename="sccache-v$version-$platform"

readonly url="https://gitlab.kitware.com/api/v4/projects/6955/packages/generic/sccache/v$version-$build_date/"

cd .gitlab

echo "$sha256sum  $filename" > sccache.sha256sum
curl -OL "$url/$filename"
$shatool --check sccache.sha256sum
mv "$filename" sccache
chmod +x sccache
