#!/bin/sh

set -e

# Build dependencies.
dnf install -y --setopt=install_weak_deps=False \
    cargo git-core openssl-devel xz-devel

# Run dependencies.
dnf install -y --setopt=install_weak_deps=False \
    rsync

# Test dependencies.
dnf install -y --setopt=install_weak_deps=False \
    podman-docker which jq iproute pwgen fuse-overlayfs slirp4netns

# Use package with issue#447 fixed.
# https://github.com/containers/fuse-overlayfs/issues/447
# https://github.com/containers/fuse-overlayfs/pull/448
# https://src.fedoraproject.org/rpms/fuse-overlayfs/pull-request/6
# https://koji.fedoraproject.org/koji/taskinfo?taskID=138737861
# https://kojipkgs.fedoraproject.org//work/tasks/7975/138737975/fuse-overlayfs-1.13-5.fc44.x86_64.rpm
curl -OL https://paraview.org/files/dependencies/fuse-overlayfs-1.13-5.fc44.x86_64.rpm
cat >fuse-overlayfs.sha256sum <<EOF
c385ac9bd43bf72955596f89aba69c1599f565c70689d1977cf21e28cc29983e  fuse-overlayfs-1.13-5.fc44.x86_64.rpm
EOF
sha256sum --check fuse-overlayfs.sha256sum
dnf install -y --setopt=install_weak_deps=False \
    fuse-overlayfs-1.13-5.fc44.x86_64.rpm
rm fuse-overlayfs-1.13-5.fc44.x86_64.rpm

# Silence "podman as docker" messages.
touch /etc/containers/nodocker

# Fix some `podman` behaviors for CI purposes.
cat > /etc/containers/registries.conf.d/999-kitware-short-names.conf <<EOF
short-name-mode="disabled"
EOF

# Set up git user information.
git config --global user.name "Ghostflow Testing"
git config --global user.email "ghostflow@example.invalid"

dnf clean all
