#!/bin/bash

set -e

readonly git_url='https://gitlab.kitware.com/utils/ghostflow-director.git'
readonly git_commit='ef417996ce8fbc0141448cee4a300406804e739d' # fix for pushing merges in gitlab 16.0+

git clone "$git_url" ghostflow-director/src
pushd ghostflow-director/src
git -c advice.detachedHead=false checkout "$git_commit"
short_commit="$( git rev-parse --short "$git_commit" )"
readonly short_commit
cargo build --features systemd
popd
mv ghostflow-director/src/target/debug/ghostflow-director "ghostflow-director-$short_commit"
