#!/bin/bash

set -e

readonly git_url='https://gitlab.kitware.com/utils/ghostflow-director.git'
readonly git_commit='06c996f2e7ffe90d2f312d9f97f4b83a75725da0' # check-ignore-backport-branches

git clone "$git_url" ghostflow-director/src
pushd ghostflow-director/src
git -c advice.detachedHead=false checkout "$git_commit"
short_commit="$( git rev-parse --short "$git_commit" )"
readonly short_commit
cargo build --features systemd
cargo run -- --version
popd
mv ghostflow-director/src/target/debug/ghostflow-director "ghostflow-director-$short_commit"
