#!/bin/bash

set -e

readonly git_url='https://gitlab.kitware.com/utils/ghostflow-director.git'
readonly git_commit='c6ba756bbad4d8e9fa0eb7eff730cc5cfd639f6f' # ghostflow-gitlab-hookdate-fix
readonly cargo_features="--features systemd"

git clone "$git_url" ghostflow-director/src
pushd ghostflow-director/src
git -c advice.detachedHead=false checkout "$git_commit"
short_commit="$( git rev-parse --short "$git_commit" )"
readonly short_commit
cargo build $cargo_features
cargo run $cargo_features -- --version
popd
mv ghostflow-director/src/target/debug/ghostflow-director "ghostflow-director-$short_commit"
