include(RunCTest)

set(ENV{CTEST_OUTPUT_ON_FAILURE} 1)

function(run_NameIsAlphaNumeric1_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ abcdefghijklmnopqrstuvwxyz0123456789 ]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ abcdefghijklmnopqrstuvwxyz0123456789 ]==])
  run_ctest(NameIsAlphaNumeric1)
endfunction()
run_NameIsAlphaNumeric1_test()

function(run_NameIsAlphaNumeric2_test)
  set(CASE_CMAKELISTS_NAME_1 [==["abcdefghijklmnopqrstuvwxyz0123456789"]==])
  set(CASE_CMAKELISTS_NAME_2 [==["abcdefghijklmnopqrstuvwxyz0123456789"]==])
  run_ctest(NameIsAlphaNumeric2)
endfunction()
run_NameIsAlphaNumeric2_test()

function(run_NameIsAlphaNumeric3_test)
  set(CASE_CMAKELISTS_NAME_1 [==["abcdefghijklmnopqrstuvwxyz0123456789"]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ abcdefghijklmnopqrstuvwxyz0123456789 ]==])
  run_ctest(NameIsAlphaNumeric3)
endfunction()
run_NameIsAlphaNumeric3_test()

function(run_NameIsAlphaNumeric4_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ abcdefghijklmnopqrstuvwxyz0123456789 ]==])
  set(CASE_CMAKELISTS_NAME_2 [==["abcdefghijklmnopqrstuvwxyz0123456789"]==])
  run_ctest(NameIsAlphaNumeric4)
endfunction()
run_NameIsAlphaNumeric4_test()


function(run_NameContainsValidSpecialChars1_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ abc_.+-012 ]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ abc_.+-012 ]==])
  run_ctest(NameContainsValidSpecialChars1)
endfunction()
run_NameContainsValidSpecialChars1_test()

function(run_NameContainsValidSpecialChars2_test)
  set(CASE_CMAKELISTS_NAME_1 [==["abc_.+-012"]==])
  set(CASE_CMAKELISTS_NAME_2 [==["abc_.+-012"]==])
  run_ctest(NameContainsValidSpecialChars2)
endfunction()
run_NameContainsValidSpecialChars2_test()

function(run_NameContainsValidSpecialChars3_test)
  set(CASE_CMAKELISTS_NAME_1 [==["abc_.+-012"]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ abc_.+-012 ]==])
  run_ctest(NameContainsValidSpecialChars3)
endfunction()
run_NameContainsValidSpecialChars3_test()

function(run_NameContainsValidSpecialChars4_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ abc_.+-012 ]==])
  set(CASE_CMAKELISTS_NAME_2 [==["abc_.+-012"]==])
  run_ctest(NameContainsValidSpecialChars4)
endfunction()
run_NameContainsValidSpecialChars4_test()


function(run_NameContainsOtherSpecialChars1_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ !§$%&/ü:*😤~ ]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ !§$%&/ü:*😤~ ]==])
  run_ctest(NameContainsOtherSpecialChars1)
endfunction()
run_NameContainsOtherSpecialChars1_test()

function(run_NameContainsOtherSpecialChars2_test)
  set(CASE_CMAKELISTS_NAME_1 [==["!§$%&/ü:*😤~"]==])
  set(CASE_CMAKELISTS_NAME_2 [==["!§$%&/ü:*😤~"]==])
  run_ctest(NameContainsOtherSpecialChars2)
endfunction()
run_NameContainsOtherSpecialChars2_test()

function(run_NameContainsOtherSpecialChars3_test)
  set(CASE_CMAKELISTS_NAME_1 [==["!§$%&/ü:*😤~"]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ !§$%&/ü:*😤~ ]==])
  run_ctest(NameContainsOtherSpecialChars3)
endfunction()
run_NameContainsOtherSpecialChars3_test()

function(run_NameContainsOtherSpecialChars4_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ !§$%&/ü:*😤~ ]==])
  set(CASE_CMAKELISTS_NAME_2 [==["!§$%&/ü:*😤~"]==])
  run_ctest(NameContainsOtherSpecialChars4)
endfunction()
run_NameContainsOtherSpecialChars4_test()


function(run_NameContainsEscapedSpecialChars1_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ \(\)\ \# ]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ \(\)\ \# ]==])
  run_ctest(NameContainsEscapedSpecialChars1)
endfunction()
run_NameContainsEscapedSpecialChars1_test()

function(run_NameContainsEscapedSpecialChars2_test)
  set(CASE_CMAKELISTS_NAME_1 [==["\(\)\ \#"]==])
  set(CASE_CMAKELISTS_NAME_2 [==["\(\)\ \#"]==])
  run_ctest(NameContainsEscapedSpecialChars2)
endfunction()
run_NameContainsEscapedSpecialChars2_test()

function(run_NameContainsEscapedSpecialChars3_test)
  set(CASE_CMAKELISTS_NAME_1 [==["\(\)\ \#"]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ \(\)\ \# ]==])
  run_ctest(NameContainsEscapedSpecialChars3)
endfunction()
run_NameContainsEscapedSpecialChars3_test()

function(run_NameContainsEscapedSpecialChars4_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ \(\)\ \# ]==])
  set(CASE_CMAKELISTS_NAME_2 [==["\(\)\ \#"]==])
  run_ctest(NameContainsEscapedSpecialChars4)
endfunction()
run_NameContainsEscapedSpecialChars4_test()


function(run_NameContainsGeneratorExpressionSyntax1_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ $<BOOL:0> ]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ $<BOOL:0> ]==])
  run_ctest(NameContainsGeneratorExpressionSyntax1)
endfunction()
run_NameContainsGeneratorExpressionSyntax1_test()

function(run_NameContainsGeneratorExpressionSyntax2_test)
  set(CASE_CMAKELISTS_NAME_1 [==["$<BOOL:0>"]==])
  set(CASE_CMAKELISTS_NAME_2 [==["$<BOOL:0>"]==])
  run_ctest(NameContainsGeneratorExpressionSyntax2)
endfunction()
run_NameContainsGeneratorExpressionSyntax2_test()

function(run_NameContainsGeneratorExpressionSyntax3_test)
  set(CASE_CMAKELISTS_NAME_1 [==["$<BOOL:0>"]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ $<BOOL:0> ]==])
  run_ctest(NameContainsGeneratorExpressionSyntax3)
endfunction()
run_NameContainsGeneratorExpressionSyntax3_test()

function(run_NameContainsGeneratorExpressionSyntax4_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ $<BOOL:0> ]==])
  set(CASE_CMAKELISTS_NAME_2 [==["$<BOOL:0>"]==])
  run_ctest(NameContainsGeneratorExpressionSyntax4)
endfunction()
run_NameContainsGeneratorExpressionSyntax4_test()


function(run_NameContainsSpaces1_test)
  set(CASE_CMAKELISTS_NAME_1 [==["PrefixTest SuffixTest"]==])
  set(CASE_CMAKELISTS_NAME_2 [==["PrefixTest SuffixTest"]==])
  run_ctest(NameContainsSpaces1)
endfunction()
run_NameContainsSpaces1_test()

function(run_NameContainsSpaces2_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ PrefixTest SuffixTest ]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ PrefixTest SuffixTest ]==])
  run_ctest(NameContainsSpaces2)
endfunction()
run_NameContainsSpaces2_test()

function(run_NameContainsSpaces3_test)
  set(CASE_CMAKELISTS_NAME_1 [==["PrefixTest SuffixTest"]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ PrefixTest SuffixTest ]==])
  run_ctest(NameContainsSpaces3)
endfunction()
run_NameContainsSpaces3_test()

function(run_NameContainsSpaces4_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ PrefixTest SuffixTest ]==])
  set(CASE_CMAKELISTS_NAME_2 [==["PrefixTest SuffixTest"]==])
  run_ctest(NameContainsSpaces4)
endfunction()
run_NameContainsSpaces4_test()


function(run_NameContainsSemicolon1_test)
  set(CASE_CMAKELISTS_NAME_1 [==["PrefixTest;SuffixTest"]==])
  set(CASE_CMAKELISTS_NAME_2 [==["PrefixTest;SuffixTest"]==])
  run_ctest(NameContainsSemicolon1)
endfunction()
run_NameContainsSemicolon1_test()

function(run_NameContainsSemicolon2_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ PrefixTest;SuffixTest ]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ PrefixTest;SuffixTest ]==])
  run_ctest(NameContainsSemicolon2)
endfunction()
run_NameContainsSemicolon2_test()

function(run_NameContainsSemicolon3_test)
  set(CASE_CMAKELISTS_NAME_1 [==["PrefixTest;SuffixTest"]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ PrefixTest;SuffixTest ]==])
  run_ctest(NameContainsSemicolon3)
endfunction()
run_NameContainsSemicolon3_test()

function(run_NameContainsSemicolon4_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ PrefixTest;SuffixTest ]==])
  set(CASE_CMAKELISTS_NAME_2 [==["PrefixTest;SuffixTest"]==])
  run_ctest(NameContainsSemicolon4)
endfunction()
run_NameContainsSemicolon4_test()


function(run_NameContainsEscapedQuote1_test)
  set(CASE_CMAKELISTS_NAME_1 [==["EscapedQuote\"\"SuffixTest"]==])
  set(CASE_CMAKELISTS_NAME_2 [==["EscapedQuote\"\"SuffixTest"]==])
  run_ctest(NameContainsEscapedQuote1)
endfunction()
run_NameContainsEscapedQuote1_test()

function(run_NameContainsEscapedQuote2_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ EscapedQuote\"\"SuffixTest ]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ EscapedQuote\"\"SuffixTest ]==])
  run_ctest(NameContainsEscapedQuote2)
endfunction()
run_NameContainsEscapedQuote2_test()

function(run_NameContainsEscapedQuote3_test)
  set(CASE_CMAKELISTS_NAME_1 [==["EscapedQuote\"\"SuffixTest"]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ EscapedQuote\"\"SuffixTest ]==])
  run_ctest(NameContainsEscapedQuote3)
endfunction()
run_NameContainsEscapedQuote3_test()

function(run_NameContainsEscapedQuote4_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ EscapedQuote\"\"SuffixTest ]==])
  set(CASE_CMAKELISTS_NAME_2 [==["EscapedQuote\"\"SuffixTest"]==])
  run_ctest(NameContainsEscapedQuote4)
endfunction()
run_NameContainsEscapedQuote4_test()


function(run_NameContainsBracketArgument1_test)
  set(CASE_CMAKELISTS_NAME_1 [==["[=[BracketArgument;SuffixTest]=]"]==])
  set(CASE_CMAKELISTS_NAME_2 [==["[=[BracketArgument;SuffixTest]=]"]==])
  run_ctest(NameContainsBracketArgument1)
endfunction()
run_NameContainsBracketArgument1_test()

function(run_NameContainsBracketArgument2_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ [=[BracketArgument;SuffixTest]=] ]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ [=[BracketArgument;SuffixTest]=] ]==])
  run_ctest(NameContainsBracketArgument2)
endfunction()
run_NameContainsBracketArgument2_test()

function(run_NameContainsBracketArgument3_test)
  set(CASE_CMAKELISTS_NAME_1 [==["[=[BracketArgument;SuffixTest]=]"]==])
  set(CASE_CMAKELISTS_NAME_2 [==[ [=[BracketArgument;SuffixTest]=] ]==])
  run_ctest(NameContainsBracketArgument3)
endfunction()
run_NameContainsBracketArgument3_test()

function(run_NameContainsBracketArgument4_test)
  set(CASE_CMAKELISTS_NAME_1 [==[ [=[BracketArgument;SuffixTest]=] ]==])
  set(CASE_CMAKELISTS_NAME_2 [==["[=[BracketArgument;SuffixTest]=]"]==])
  run_ctest(NameContainsBracketArgument4)
endfunction()
run_NameContainsBracketArgument4_test()
