# Keep in sync with the common script.
$git_url = 'https://github.com/Kitware/ninja.git'
$git_commit = '51db22c9ece4cb08f6c460b3b0257ce1a6fb5d8e' # v1.10.2.g51db2.kitware.jobserver-1
$version = '1.10.2.g51db2.kitware.jobserver-1'

git clone "$git_url" ninja/src
git -C ninja/src -c advice.detachedHead=false checkout "$git_commit"

if ($env:VSCMD_ARG_TGT_ARCH -eq "x64") {
  $arch = "x86_64";
} elseif ($env:VSCMD_ARG_TGT_ARCH -eq "arm64") {
  $arch = "arm64";
} else {
  Write-Host "VSCMD_ARG_TGT_ARCH env var not recognized.  Run this from a Visual Studio Command Prompt."
  exit 1
}

New-Item -Path "ninja-$arch" -Type Directory
cd "ninja-$arch"
cmake `
  -GNinja `
  -DCMAKE_BUILD_TYPE=Release `
  -DBUILD_TESTING=OFF `
  "../ninja/src"
cmake --build .
cd ..

mv ninja-$arch/ninja.exe "ninja-$version-windows-$arch.exe"
