'''
Separate file for the text blocks to be formatted.
These strings will be formatted in generator.py, then used to
generate valid pybind11 binding code
'''


common_cpp_body= """
#include "pybind11/pybind11.h"
namespace py = pybind11;

{forwards}

PYBIND11_MODULE({name}, model)
{{
{init_funs}
}}
"""

init_fun_signature = """auto_bind_{name}(model);\n"""
init_fun_forward = """void auto_bind_{name}(py::module &model);\n"""


cppbody = """
#include "pybind11/operators.h"
#include "pybind11/pybind11.h"
#include "pybind11/stl.h"
{includes}


namespace py = pybind11;
//#include "drake/bindings/pydrake/documentation_pybind.h"
//#include "drake/bindings/pydrake/pydrake_pybind.h"

// namespace drake {{
// namespace pydrake {{
void auto_bind_{name}(py::module &m)
{{
  {class_info}
}}

// }}  // namespace pydrake
// }}  // namespace drake
"""


class_info_body = """
  py::class_<{pyclass_args}>(m, "{name}"{doc})
    {constructor}
    {funcs}
    {vars}
    {opers}
    ;
"""

module_cpp = """
#include <pybind11/pybind11.h>
{includes}
namespace py = pybind11;

void auto_bind_{namespace}(py::module &m)
{{
  {defs}
}}
"""
member_func = """{module}.def{static}(\"{fun_name}\", {fun_ref}{args}{doc}){ending}\n"""

constructor = """.def(py::init<{}>(){})\n"""
member_func_arg = """py::arg(\"{}\"){}"""
public_member_var= """.def_read{write}{static}(\"{var_name}\", {var_ref})\n"""
private_member_var = """.def_property{readonly}{static}(\"{var_name}\", {var_accessors})\n"""
member_reference = "&{classname}::{member}"
overload_template = """({decl_string}) ({fun_ref})"""
operator_template = """.def({arg1} {symbol} {arg2})\n"""
call_template = """.def("__call__", []({arg_str}){{ {fn_call} }})\n"""
enum_header = """py::enum_<{class_name}>(m,\"{name}\",{type}, "{doc}")\n"""
enum_val = """.value(\"{short_name}\", {scoped_name}, \"{doc}\")\n"""

wrap_header = """
%s
%s
namespace _wrapping_
{
  const char* const group = "%s";

  namespace wrappers
  {
    %s
  }

  void force_instantiate()
  {
    using namespace _wrapping_::wrappers;
  }
}
"""