// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#include "vtkWebGPUComputeTextureView.h"
#include "vtkObjectFactory.h"

VTK_ABI_NAMESPACE_BEGIN

vtkStandardNewMacro(vtkWebGPUComputeTextureView);

//------------------------------------------------------------------------------
vtkWebGPUComputeTextureView::vtkWebGPUComputeTextureView() = default;

//------------------------------------------------------------------------------
vtkWebGPUComputeTextureView::~vtkWebGPUComputeTextureView() = default;

//------------------------------------------------------------------------------
void vtkWebGPUComputeTextureView::PrintSelf(ostream& os, vtkIndent indent)
{
  os << indent << "BaseMipLevel: " << this->BaseMipLevel << std::endl;
  os << indent << "MipLevelCount: " << this->MipLevelCount << std::endl;
  os << indent << "Group: " << this->Group << std::endl;
  os << indent << "Binding: " << this->Binding << std::endl;

  os << indent << "Aspect: " << this->Aspect << std::endl;
  os << indent << "Dimension: " << this->Dimension << std::endl;
  os << indent << "Format: " << this->Format << std::endl;
  os << indent << "Mode: " << this->Mode << std::endl;
  os << indent << "Label: " << this->Label << std::endl;

  os << indent << "AssociatedTextureIndex: " << this->AssociatedTextureIndex << std::endl;
}

VTK_ABI_NAMESPACE_END
