// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#include "vtkWebGPUComputeBuffer.h"
#include "vtkNew.h" // for vtk new macro
#include "vtkObjectFactory.h"

VTK_ABI_NAMESPACE_BEGIN

vtkStandardNewMacro(vtkWebGPUComputeBuffer);

//------------------------------------------------------------------------------
vtkWebGPUComputeBuffer::vtkWebGPUComputeBuffer() = default;

//------------------------------------------------------------------------------
void vtkWebGPUComputeBuffer::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);

  os << indent << "Group: " << this->Group << std::endl;
  os << indent << "Binding: " << this->Binding << std::endl;
  os << indent << "Mode: " << this->Mode << std::endl;

  os << indent << "VectorDataPointer: " << this->DataPointer << std::endl;
  os << indent << "DataArrayPointer: " << this->DataArray << std::endl;

  os << indent << "ByteSize: " << this->ByteSize << std::endl;
  os << indent << "Label: " << this->Label << std::endl;
}

//------------------------------------------------------------------------------
void vtkWebGPUComputeBuffer::SetData(vtkDataArray* data)
{
  if (this->DataPointer != nullptr)
  {
    vtkLog(WARNING,
      "An std::vector has already been set for this compute buffer. You cannot have both "
      "std::vector and vtkDataArray data set at the same time. Use SetData() with an empty "
      "std::vector if you wish to remove the std::vector data from this compute buffer. Nothing "
      "was changed in the buffer by this call.");

    return;
  }

  this->DataArray = data;
  this->ByteSize = data->GetNumberOfValues() * data->GetDataTypeSize();
}

VTK_ABI_NAMESPACE_END
