/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyTubeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyTubeAttributes
//
// Purpose: 
//   This class contains attributes for the tube operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a TubeAttributes.
//
struct TubeAttributesObject
{
    PyObject_HEAD
    TubeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewTubeAttributes(int);

std::string
PyTubeAttributes_ToString(const TubeAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetScaleByVarFlag())
        SNPRINTF(tmpStr, 1000, "%sscaleByVarFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sscaleByVarFlag = 0\n", prefix);
    str += tmpStr;
    const char *tubeRadiusType_names = "FractionOfBBox, Absolute";
    switch (atts->GetTubeRadiusType())
    {
      case TubeAttributes::FractionOfBBox:
          SNPRINTF(tmpStr, 1000, "%stubeRadiusType = %sFractionOfBBox  # %s\n", prefix, prefix, tubeRadiusType_names);
          str += tmpStr;
          break;
      case TubeAttributes::Absolute:
          SNPRINTF(tmpStr, 1000, "%stubeRadiusType = %sAbsolute  # %s\n", prefix, prefix, tubeRadiusType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sradiusFractionBBox = %g\n", prefix, atts->GetRadiusFractionBBox());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sradiusAbsolute = %g\n", prefix, atts->GetRadiusAbsolute());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sscaleVariable = \"%s\"\n", prefix, atts->GetScaleVariable().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sfineness = %d\n", prefix, atts->GetFineness());
    str += tmpStr;
    if(atts->GetCapping())
        SNPRINTF(tmpStr, 1000, "%scapping = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scapping = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
TubeAttributes_Notify(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TubeAttributes_SetScaleByVarFlag(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaleByVarFlag in the object.
    obj->data->SetScaleByVarFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TubeAttributes_GetScaleByVarFlag(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetScaleByVarFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TubeAttributes_SetTubeRadiusType(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the tubeRadiusType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetTubeRadiusType(TubeAttributes::TubeRadiusType(ival));
    else
    {
        fprintf(stderr, "An invalid tubeRadiusType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "FractionOfBBox, Absolute.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TubeAttributes_GetTubeRadiusType(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTubeRadiusType()));
    return retval;
}

/*static*/ PyObject *
TubeAttributes_SetRadiusFractionBBox(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the radiusFractionBBox in the object.
    obj->data->SetRadiusFractionBBox(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TubeAttributes_GetRadiusFractionBBox(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRadiusFractionBBox());
    return retval;
}

/*static*/ PyObject *
TubeAttributes_SetRadiusAbsolute(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the radiusAbsolute in the object.
    obj->data->SetRadiusAbsolute(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TubeAttributes_GetRadiusAbsolute(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRadiusAbsolute());
    return retval;
}

/*static*/ PyObject *
TubeAttributes_SetScaleVariable(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the scaleVariable in the object.
    obj->data->SetScaleVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TubeAttributes_GetScaleVariable(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetScaleVariable().c_str());
    return retval;
}

/*static*/ PyObject *
TubeAttributes_SetFineness(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fineness in the object.
    obj->data->SetFineness((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TubeAttributes_GetFineness(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFineness()));
    return retval;
}

/*static*/ PyObject *
TubeAttributes_SetCapping(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the capping in the object.
    obj->data->SetCapping(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TubeAttributes_GetCapping(PyObject *self, PyObject *args)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCapping()?1L:0L);
    return retval;
}



PyMethodDef PyTubeAttributes_methods[TUBEATTRIBUTES_NMETH] = {
    {"Notify", TubeAttributes_Notify, METH_VARARGS},
    {"SetScaleByVarFlag", TubeAttributes_SetScaleByVarFlag, METH_VARARGS},
    {"GetScaleByVarFlag", TubeAttributes_GetScaleByVarFlag, METH_VARARGS},
    {"SetTubeRadiusType", TubeAttributes_SetTubeRadiusType, METH_VARARGS},
    {"GetTubeRadiusType", TubeAttributes_GetTubeRadiusType, METH_VARARGS},
    {"SetRadiusFractionBBox", TubeAttributes_SetRadiusFractionBBox, METH_VARARGS},
    {"GetRadiusFractionBBox", TubeAttributes_GetRadiusFractionBBox, METH_VARARGS},
    {"SetRadiusAbsolute", TubeAttributes_SetRadiusAbsolute, METH_VARARGS},
    {"GetRadiusAbsolute", TubeAttributes_GetRadiusAbsolute, METH_VARARGS},
    {"SetScaleVariable", TubeAttributes_SetScaleVariable, METH_VARARGS},
    {"GetScaleVariable", TubeAttributes_GetScaleVariable, METH_VARARGS},
    {"SetFineness", TubeAttributes_SetFineness, METH_VARARGS},
    {"GetFineness", TubeAttributes_GetFineness, METH_VARARGS},
    {"SetCapping", TubeAttributes_SetCapping, METH_VARARGS},
    {"GetCapping", TubeAttributes_GetCapping, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TubeAttributes_dealloc(PyObject *v)
{
   TubeAttributesObject *obj = (TubeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
TubeAttributes_compare(PyObject *v, PyObject *w)
{
    TubeAttributes *a = ((TubeAttributesObject *)v)->data;
    TubeAttributes *b = ((TubeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyTubeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "scaleByVarFlag") == 0)
        return TubeAttributes_GetScaleByVarFlag(self, NULL);
    if(strcmp(name, "tubeRadiusType") == 0)
        return TubeAttributes_GetTubeRadiusType(self, NULL);
    if(strcmp(name, "FractionOfBBox") == 0)
        return PyInt_FromLong(long(TubeAttributes::FractionOfBBox));
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(TubeAttributes::Absolute));

    if(strcmp(name, "radiusFractionBBox") == 0)
        return TubeAttributes_GetRadiusFractionBBox(self, NULL);
    if(strcmp(name, "radiusAbsolute") == 0)
        return TubeAttributes_GetRadiusAbsolute(self, NULL);
    if(strcmp(name, "scaleVariable") == 0)
        return TubeAttributes_GetScaleVariable(self, NULL);
    if(strcmp(name, "fineness") == 0)
        return TubeAttributes_GetFineness(self, NULL);
    if(strcmp(name, "capping") == 0)
        return TubeAttributes_GetCapping(self, NULL);

    return Py_FindMethod(PyTubeAttributes_methods, self, name);
}

int
PyTubeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "scaleByVarFlag") == 0)
        obj = TubeAttributes_SetScaleByVarFlag(self, tuple);
    else if(strcmp(name, "tubeRadiusType") == 0)
        obj = TubeAttributes_SetTubeRadiusType(self, tuple);
    else if(strcmp(name, "radiusFractionBBox") == 0)
        obj = TubeAttributes_SetRadiusFractionBBox(self, tuple);
    else if(strcmp(name, "radiusAbsolute") == 0)
        obj = TubeAttributes_SetRadiusAbsolute(self, tuple);
    else if(strcmp(name, "scaleVariable") == 0)
        obj = TubeAttributes_SetScaleVariable(self, tuple);
    else if(strcmp(name, "fineness") == 0)
        obj = TubeAttributes_SetFineness(self, tuple);
    else if(strcmp(name, "capping") == 0)
        obj = TubeAttributes_SetCapping(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
TubeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)v;
    fprintf(fp, "%s", PyTubeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
TubeAttributes_str(PyObject *v)
{
    TubeAttributesObject *obj = (TubeAttributesObject *)v;
    return PyString_FromString(PyTubeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *TubeAttributes_Purpose = "This class contains attributes for the tube operator.";
#else
static char *TubeAttributes_Purpose = "This class contains attributes for the tube operator.";
#endif

//
// The type description structure
//
static PyTypeObject TubeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TubeAttributes",                    // tp_name
    sizeof(TubeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TubeAttributes_dealloc,  // tp_dealloc
    (printfunc)TubeAttributes_print,     // tp_print
    (getattrfunc)PyTubeAttributes_getattr, // tp_getattr
    (setattrfunc)PyTubeAttributes_setattr, // tp_setattr
    (cmpfunc)TubeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)TubeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TubeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TubeAttributes *defaultAtts = 0;
static TubeAttributes *currentAtts = 0;

static PyObject *
NewTubeAttributes(int useCurrent)
{
    TubeAttributesObject *newObject;
    newObject = PyObject_NEW(TubeAttributesObject, &TubeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new TubeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new TubeAttributes(*defaultAtts);
    else
        newObject->data = new TubeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapTubeAttributes(const TubeAttributes *attr)
{
    TubeAttributesObject *newObject;
    newObject = PyObject_NEW(TubeAttributesObject, &TubeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TubeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TubeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewTubeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TubeAttributesMethods[] = {
    {"TubeAttributes", TubeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TubeAttributesObserver = 0;

std::string
PyTubeAttributes_GetLogString()
{
    std::string s("TubeAtts = TubeAttributes()\n");
    if(currentAtts != 0)
        s += PyTubeAttributes_ToString(currentAtts, "TubeAtts.");
    return s;
}

static void
PyTubeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("TubeAtts = TubeAttributes()\n");
        s += PyTubeAttributes_ToString(currentAtts, "TubeAtts.");
        cb(s);
    }
}

void
PyTubeAttributes_StartUp(TubeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyTubeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TubeAttributesObserver == 0)
    {
        TubeAttributesObserver = new ObserverToCallback(subj,
            PyTubeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyTubeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TubeAttributesObserver;
    TubeAttributesObserver = 0;
}

PyMethodDef *
PyTubeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TubeAttributesMethods;
}

bool
PyTubeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TubeAttributesType);
}

TubeAttributes *
PyTubeAttributes_FromPyObject(PyObject *obj)
{
    TubeAttributesObject *obj2 = (TubeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTubeAttributes_New()
{
    return NewTubeAttributes(0);
}

PyObject *
PyTubeAttributes_Wrap(const TubeAttributes *attr)
{
    return WrapTubeAttributes(attr);
}

void
PyTubeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    TubeAttributesObject *obj2 = (TubeAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyTubeAttributes_SetDefaults(const TubeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TubeAttributes(*atts);
}

