/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <CracksClipperAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: CracksClipperAttributes::CracksClipperAttributes
//
// Purpose: 
//   Init utility for the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void CracksClipperAttributes::Init()
{
    crack1Var = "crack1_dir";
    crack2Var = "crack2_dir";
    crack3Var = "crack3_dir";
    strainVar = "void_strain_ten";
    showCrack1 = true;
    showCrack2 = true;
    showCrack3 = true;
    inMassVar = "ems";

    CracksClipperAttributes::SelectAll();
}

// ****************************************************************************
// Method: CracksClipperAttributes::CracksClipperAttributes
//
// Purpose: 
//   Copy utility for the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void CracksClipperAttributes::Copy(const CracksClipperAttributes &obj)
{
    crack1Var = obj.crack1Var;
    crack2Var = obj.crack2Var;
    crack3Var = obj.crack3Var;
    strainVar = obj.strainVar;
    showCrack1 = obj.showCrack1;
    showCrack2 = obj.showCrack2;
    showCrack3 = obj.showCrack3;
    inMassVar = obj.inMassVar;

    CracksClipperAttributes::SelectAll();
}

// Type map format string
const char *CracksClipperAttributes::TypeMapFormatString = CRACKSCLIPPERATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t CracksClipperAttributes::TmfsStruct = {CRACKSCLIPPERATTRIBUTES_TMFS};


// ****************************************************************************
// Method: CracksClipperAttributes::CracksClipperAttributes
//
// Purpose: 
//   Default constructor for the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CracksClipperAttributes::CracksClipperAttributes() : 
    AttributeSubject(CracksClipperAttributes::TypeMapFormatString)
{
    CracksClipperAttributes::Init();
}

// ****************************************************************************
// Method: CracksClipperAttributes::CracksClipperAttributes
//
// Purpose: 
//   Constructor for the derived classes of CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CracksClipperAttributes::CracksClipperAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    CracksClipperAttributes::Init();
}

// ****************************************************************************
// Method: CracksClipperAttributes::CracksClipperAttributes
//
// Purpose: 
//   Copy constructor for the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CracksClipperAttributes::CracksClipperAttributes(const CracksClipperAttributes &obj) : 
    AttributeSubject(CracksClipperAttributes::TypeMapFormatString)
{
    CracksClipperAttributes::Copy(obj);
}

// ****************************************************************************
// Method: CracksClipperAttributes::CracksClipperAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CracksClipperAttributes::CracksClipperAttributes(const CracksClipperAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    CracksClipperAttributes::Copy(obj);
}

// ****************************************************************************
// Method: CracksClipperAttributes::~CracksClipperAttributes
//
// Purpose: 
//   Destructor for the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CracksClipperAttributes::~CracksClipperAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: CracksClipperAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CracksClipperAttributes& 
CracksClipperAttributes::operator = (const CracksClipperAttributes &obj)
{
    if (this == &obj) return *this;

    CracksClipperAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: CracksClipperAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CracksClipperAttributes::operator == (const CracksClipperAttributes &obj) const
{
    // Create the return value
    return ((crack1Var == obj.crack1Var) &&
            (crack2Var == obj.crack2Var) &&
            (crack3Var == obj.crack3Var) &&
            (strainVar == obj.strainVar) &&
            (showCrack1 == obj.showCrack1) &&
            (showCrack2 == obj.showCrack2) &&
            (showCrack3 == obj.showCrack3) &&
            (inMassVar == obj.inMassVar));
}

// ****************************************************************************
// Method: CracksClipperAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CracksClipperAttributes::operator != (const CracksClipperAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: CracksClipperAttributes::TypeName
//
// Purpose: 
//   Type name method for the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
CracksClipperAttributes::TypeName() const
{
    return "CracksClipperAttributes";
}

// ****************************************************************************
// Method: CracksClipperAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CracksClipperAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const CracksClipperAttributes *tmp = (const CracksClipperAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: CracksClipperAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
CracksClipperAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new CracksClipperAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: CracksClipperAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the CracksClipperAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
CracksClipperAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new CracksClipperAttributes(*this);
    else
        retval = new CracksClipperAttributes;

    return retval;
}

// ****************************************************************************
// Method: CracksClipperAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
CracksClipperAttributes::SelectAll()
{
    Select(ID_crack1Var,  (void *)&crack1Var);
    Select(ID_crack2Var,  (void *)&crack2Var);
    Select(ID_crack3Var,  (void *)&crack3Var);
    Select(ID_strainVar,  (void *)&strainVar);
    Select(ID_showCrack1, (void *)&showCrack1);
    Select(ID_showCrack2, (void *)&showCrack2);
    Select(ID_showCrack3, (void *)&showCrack3);
    Select(ID_inMassVar,  (void *)&inMassVar);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CracksClipperAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CracksClipperAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    CracksClipperAttributes defaultObject;
    bool addToParent = false;
    // Create a node for CracksClipperAttributes.
    DataNode *node = new DataNode("CracksClipperAttributes");

    if(completeSave || !FieldsEqual(ID_crack1Var, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("crack1Var", crack1Var));
    }

    if(completeSave || !FieldsEqual(ID_crack2Var, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("crack2Var", crack2Var));
    }

    if(completeSave || !FieldsEqual(ID_crack3Var, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("crack3Var", crack3Var));
    }

    if(completeSave || !FieldsEqual(ID_strainVar, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("strainVar", strainVar));
    }

    if(completeSave || !FieldsEqual(ID_showCrack1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showCrack1", showCrack1));
    }

    if(completeSave || !FieldsEqual(ID_showCrack2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showCrack2", showCrack2));
    }

    if(completeSave || !FieldsEqual(ID_showCrack3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showCrack3", showCrack3));
    }

    if(completeSave || !FieldsEqual(ID_inMassVar, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("inMassVar", inMassVar));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: CracksClipperAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
CracksClipperAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("CracksClipperAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("crack1Var")) != 0)
        SetCrack1Var(node->AsString());
    if((node = searchNode->GetNode("crack2Var")) != 0)
        SetCrack2Var(node->AsString());
    if((node = searchNode->GetNode("crack3Var")) != 0)
        SetCrack3Var(node->AsString());
    if((node = searchNode->GetNode("strainVar")) != 0)
        SetStrainVar(node->AsString());
    if((node = searchNode->GetNode("showCrack1")) != 0)
        SetShowCrack1(node->AsBool());
    if((node = searchNode->GetNode("showCrack2")) != 0)
        SetShowCrack2(node->AsBool());
    if((node = searchNode->GetNode("showCrack3")) != 0)
        SetShowCrack3(node->AsBool());
    if((node = searchNode->GetNode("inMassVar")) != 0)
        SetInMassVar(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
CracksClipperAttributes::SetCrack1Var(const std::string &crack1Var_)
{
    crack1Var = crack1Var_;
    Select(ID_crack1Var, (void *)&crack1Var);
}

void
CracksClipperAttributes::SetCrack2Var(const std::string &crack2Var_)
{
    crack2Var = crack2Var_;
    Select(ID_crack2Var, (void *)&crack2Var);
}

void
CracksClipperAttributes::SetCrack3Var(const std::string &crack3Var_)
{
    crack3Var = crack3Var_;
    Select(ID_crack3Var, (void *)&crack3Var);
}

void
CracksClipperAttributes::SetStrainVar(const std::string &strainVar_)
{
    strainVar = strainVar_;
    Select(ID_strainVar, (void *)&strainVar);
}

void
CracksClipperAttributes::SetShowCrack1(bool showCrack1_)
{
    showCrack1 = showCrack1_;
    Select(ID_showCrack1, (void *)&showCrack1);
}

void
CracksClipperAttributes::SetShowCrack2(bool showCrack2_)
{
    showCrack2 = showCrack2_;
    Select(ID_showCrack2, (void *)&showCrack2);
}

void
CracksClipperAttributes::SetShowCrack3(bool showCrack3_)
{
    showCrack3 = showCrack3_;
    Select(ID_showCrack3, (void *)&showCrack3);
}

void
CracksClipperAttributes::SetInMassVar(const std::string &inMassVar_)
{
    inMassVar = inMassVar_;
    Select(ID_inMassVar, (void *)&inMassVar);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
CracksClipperAttributes::GetCrack1Var() const
{
    return crack1Var;
}

std::string &
CracksClipperAttributes::GetCrack1Var()
{
    return crack1Var;
}

const std::string &
CracksClipperAttributes::GetCrack2Var() const
{
    return crack2Var;
}

std::string &
CracksClipperAttributes::GetCrack2Var()
{
    return crack2Var;
}

const std::string &
CracksClipperAttributes::GetCrack3Var() const
{
    return crack3Var;
}

std::string &
CracksClipperAttributes::GetCrack3Var()
{
    return crack3Var;
}

const std::string &
CracksClipperAttributes::GetStrainVar() const
{
    return strainVar;
}

std::string &
CracksClipperAttributes::GetStrainVar()
{
    return strainVar;
}

bool
CracksClipperAttributes::GetShowCrack1() const
{
    return showCrack1;
}

bool
CracksClipperAttributes::GetShowCrack2() const
{
    return showCrack2;
}

bool
CracksClipperAttributes::GetShowCrack3() const
{
    return showCrack3;
}

const std::string &
CracksClipperAttributes::GetInMassVar() const
{
    return inMassVar;
}

std::string &
CracksClipperAttributes::GetInMassVar()
{
    return inMassVar;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
CracksClipperAttributes::SelectCrack1Var()
{
    Select(ID_crack1Var, (void *)&crack1Var);
}

void
CracksClipperAttributes::SelectCrack2Var()
{
    Select(ID_crack2Var, (void *)&crack2Var);
}

void
CracksClipperAttributes::SelectCrack3Var()
{
    Select(ID_crack3Var, (void *)&crack3Var);
}

void
CracksClipperAttributes::SelectStrainVar()
{
    Select(ID_strainVar, (void *)&strainVar);
}

void
CracksClipperAttributes::SelectInMassVar()
{
    Select(ID_inMassVar, (void *)&inMassVar);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CracksClipperAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
CracksClipperAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_crack1Var:  return "crack1Var";
    case ID_crack2Var:  return "crack2Var";
    case ID_crack3Var:  return "crack3Var";
    case ID_strainVar:  return "strainVar";
    case ID_showCrack1: return "showCrack1";
    case ID_showCrack2: return "showCrack2";
    case ID_showCrack3: return "showCrack3";
    case ID_inMassVar:  return "inMassVar";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CracksClipperAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
CracksClipperAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_crack1Var:  return FieldType_string;
    case ID_crack2Var:  return FieldType_string;
    case ID_crack3Var:  return FieldType_string;
    case ID_strainVar:  return FieldType_string;
    case ID_showCrack1: return FieldType_bool;
    case ID_showCrack2: return FieldType_bool;
    case ID_showCrack3: return FieldType_bool;
    case ID_inMassVar:  return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: CracksClipperAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
CracksClipperAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_crack1Var:  return "string";
    case ID_crack2Var:  return "string";
    case ID_crack3Var:  return "string";
    case ID_strainVar:  return "string";
    case ID_showCrack1: return "bool";
    case ID_showCrack2: return "bool";
    case ID_showCrack3: return "bool";
    case ID_inMassVar:  return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CracksClipperAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CracksClipperAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const CracksClipperAttributes &obj = *((const CracksClipperAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_crack1Var:
        {  // new scope
        retval = (crack1Var == obj.crack1Var);
        }
        break;
    case ID_crack2Var:
        {  // new scope
        retval = (crack2Var == obj.crack2Var);
        }
        break;
    case ID_crack3Var:
        {  // new scope
        retval = (crack3Var == obj.crack3Var);
        }
        break;
    case ID_strainVar:
        {  // new scope
        retval = (strainVar == obj.strainVar);
        }
        break;
    case ID_showCrack1:
        {  // new scope
        retval = (showCrack1 == obj.showCrack1);
        }
        break;
    case ID_showCrack2:
        {  // new scope
        retval = (showCrack2 == obj.showCrack2);
        }
        break;
    case ID_showCrack3:
        {  // new scope
        retval = (showCrack3 == obj.showCrack3);
        }
        break;
    case ID_inMassVar:
        {  // new scope
        retval = (inMassVar == obj.inMassVar);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Modifications:
//
// ****************************************************************************
bool
CracksClipperAttributes::ChangesRequireRecalculation(const CracksClipperAttributes &obj) const
{
    return true;
}

