/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <EngineProperties.h>
#include <DataNode.h>

// ****************************************************************************
// Method: EngineProperties::EngineProperties
//
// Purpose: 
//   Init utility for the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void EngineProperties::Init()
{
    numNodes = -1;
    numProcessors = 1;
    numProcessorsUsingGPUs = 0;
    dynamicLoadBalancing = false;

    EngineProperties::SelectAll();
}

// ****************************************************************************
// Method: EngineProperties::EngineProperties
//
// Purpose: 
//   Copy utility for the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void EngineProperties::Copy(const EngineProperties &obj)
{
    numNodes = obj.numNodes;
    numProcessors = obj.numProcessors;
    numProcessorsUsingGPUs = obj.numProcessorsUsingGPUs;
    dynamicLoadBalancing = obj.dynamicLoadBalancing;
    loadBalancingScheme = obj.loadBalancingScheme;

    EngineProperties::SelectAll();
}

// Type map format string
const char *EngineProperties::TypeMapFormatString = ENGINEPROPERTIES_TMFS;
const AttributeGroup::private_tmfs_t EngineProperties::TmfsStruct = {ENGINEPROPERTIES_TMFS};


// ****************************************************************************
// Method: EngineProperties::EngineProperties
//
// Purpose: 
//   Default constructor for the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EngineProperties::EngineProperties() : 
    AttributeSubject(EngineProperties::TypeMapFormatString)
{
    EngineProperties::Init();
}

// ****************************************************************************
// Method: EngineProperties::EngineProperties
//
// Purpose: 
//   Constructor for the derived classes of EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EngineProperties::EngineProperties(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    EngineProperties::Init();
}

// ****************************************************************************
// Method: EngineProperties::EngineProperties
//
// Purpose: 
//   Copy constructor for the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EngineProperties::EngineProperties(const EngineProperties &obj) : 
    AttributeSubject(EngineProperties::TypeMapFormatString)
{
    EngineProperties::Copy(obj);
}

// ****************************************************************************
// Method: EngineProperties::EngineProperties
//
// Purpose: 
//   Copy constructor for derived classes of the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EngineProperties::EngineProperties(const EngineProperties &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    EngineProperties::Copy(obj);
}

// ****************************************************************************
// Method: EngineProperties::~EngineProperties
//
// Purpose: 
//   Destructor for the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EngineProperties::~EngineProperties()
{
    // nothing here
}

// ****************************************************************************
// Method: EngineProperties::operator = 
//
// Purpose: 
//   Assignment operator for the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EngineProperties& 
EngineProperties::operator = (const EngineProperties &obj)
{
    if (this == &obj) return *this;

    EngineProperties::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: EngineProperties::operator == 
//
// Purpose: 
//   Comparison operator == for the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EngineProperties::operator == (const EngineProperties &obj) const
{
    // Create the return value
    return ((numNodes == obj.numNodes) &&
            (numProcessors == obj.numProcessors) &&
            (numProcessorsUsingGPUs == obj.numProcessorsUsingGPUs) &&
            (dynamicLoadBalancing == obj.dynamicLoadBalancing) &&
            (loadBalancingScheme == obj.loadBalancingScheme));
}

// ****************************************************************************
// Method: EngineProperties::operator != 
//
// Purpose: 
//   Comparison operator != for the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EngineProperties::operator != (const EngineProperties &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: EngineProperties::TypeName
//
// Purpose: 
//   Type name method for the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
EngineProperties::TypeName() const
{
    return "EngineProperties";
}

// ****************************************************************************
// Method: EngineProperties::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EngineProperties::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const EngineProperties *tmp = (const EngineProperties *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: EngineProperties::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
EngineProperties::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new EngineProperties(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: EngineProperties::NewInstance
//
// Purpose: 
//   NewInstance method for the EngineProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
EngineProperties::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new EngineProperties(*this);
    else
        retval = new EngineProperties;

    return retval;
}

// ****************************************************************************
// Method: EngineProperties::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
EngineProperties::SelectAll()
{
    Select(ID_numNodes,               (void *)&numNodes);
    Select(ID_numProcessors,          (void *)&numProcessors);
    Select(ID_numProcessorsUsingGPUs, (void *)&numProcessorsUsingGPUs);
    Select(ID_dynamicLoadBalancing,   (void *)&dynamicLoadBalancing);
    Select(ID_loadBalancingScheme,    (void *)&loadBalancingScheme);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: EngineProperties::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EngineProperties::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    EngineProperties defaultObject;
    bool addToParent = false;
    // Create a node for EngineProperties.
    DataNode *node = new DataNode("EngineProperties");

    if(completeSave || !FieldsEqual(ID_numNodes, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numNodes", numNodes));
    }

    if(completeSave || !FieldsEqual(ID_numProcessors, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numProcessors", numProcessors));
    }

    if(completeSave || !FieldsEqual(ID_numProcessorsUsingGPUs, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numProcessorsUsingGPUs", numProcessorsUsingGPUs));
    }

    if(completeSave || !FieldsEqual(ID_dynamicLoadBalancing, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("dynamicLoadBalancing", dynamicLoadBalancing));
    }

    if(completeSave || !FieldsEqual(ID_loadBalancingScheme, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("loadBalancingScheme", loadBalancingScheme));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: EngineProperties::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
EngineProperties::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("EngineProperties");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("numNodes")) != 0)
        SetNumNodes(node->AsInt());
    if((node = searchNode->GetNode("numProcessors")) != 0)
        SetNumProcessors(node->AsInt());
    if((node = searchNode->GetNode("numProcessorsUsingGPUs")) != 0)
        SetNumProcessorsUsingGPUs(node->AsInt());
    if((node = searchNode->GetNode("dynamicLoadBalancing")) != 0)
        SetDynamicLoadBalancing(node->AsBool());
    if((node = searchNode->GetNode("loadBalancingScheme")) != 0)
        SetLoadBalancingScheme(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
EngineProperties::SetNumNodes(int numNodes_)
{
    numNodes = numNodes_;
    Select(ID_numNodes, (void *)&numNodes);
}

void
EngineProperties::SetNumProcessors(int numProcessors_)
{
    numProcessors = numProcessors_;
    Select(ID_numProcessors, (void *)&numProcessors);
}

void
EngineProperties::SetNumProcessorsUsingGPUs(int numProcessorsUsingGPUs_)
{
    numProcessorsUsingGPUs = numProcessorsUsingGPUs_;
    Select(ID_numProcessorsUsingGPUs, (void *)&numProcessorsUsingGPUs);
}

void
EngineProperties::SetDynamicLoadBalancing(bool dynamicLoadBalancing_)
{
    dynamicLoadBalancing = dynamicLoadBalancing_;
    Select(ID_dynamicLoadBalancing, (void *)&dynamicLoadBalancing);
}

void
EngineProperties::SetLoadBalancingScheme(const std::string &loadBalancingScheme_)
{
    loadBalancingScheme = loadBalancingScheme_;
    Select(ID_loadBalancingScheme, (void *)&loadBalancingScheme);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
EngineProperties::GetNumNodes() const
{
    return numNodes;
}

int
EngineProperties::GetNumProcessors() const
{
    return numProcessors;
}

int
EngineProperties::GetNumProcessorsUsingGPUs() const
{
    return numProcessorsUsingGPUs;
}

bool
EngineProperties::GetDynamicLoadBalancing() const
{
    return dynamicLoadBalancing;
}

const std::string &
EngineProperties::GetLoadBalancingScheme() const
{
    return loadBalancingScheme;
}

std::string &
EngineProperties::GetLoadBalancingScheme()
{
    return loadBalancingScheme;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
EngineProperties::SelectLoadBalancingScheme()
{
    Select(ID_loadBalancingScheme, (void *)&loadBalancingScheme);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: EngineProperties::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
EngineProperties::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_numNodes:               return "numNodes";
    case ID_numProcessors:          return "numProcessors";
    case ID_numProcessorsUsingGPUs: return "numProcessorsUsingGPUs";
    case ID_dynamicLoadBalancing:   return "dynamicLoadBalancing";
    case ID_loadBalancingScheme:    return "loadBalancingScheme";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: EngineProperties::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
EngineProperties::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_numNodes:               return FieldType_int;
    case ID_numProcessors:          return FieldType_int;
    case ID_numProcessorsUsingGPUs: return FieldType_int;
    case ID_dynamicLoadBalancing:   return FieldType_bool;
    case ID_loadBalancingScheme:    return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: EngineProperties::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
EngineProperties::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_numNodes:               return "int";
    case ID_numProcessors:          return "int";
    case ID_numProcessorsUsingGPUs: return "int";
    case ID_dynamicLoadBalancing:   return "bool";
    case ID_loadBalancingScheme:    return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: EngineProperties::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EngineProperties::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const EngineProperties &obj = *((const EngineProperties*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_numNodes:
        {  // new scope
        retval = (numNodes == obj.numNodes);
        }
        break;
    case ID_numProcessors:
        {  // new scope
        retval = (numProcessors == obj.numProcessors);
        }
        break;
    case ID_numProcessorsUsingGPUs:
        {  // new scope
        retval = (numProcessorsUsingGPUs == obj.numProcessorsUsingGPUs);
        }
        break;
    case ID_dynamicLoadBalancing:
        {  // new scope
        retval = (dynamicLoadBalancing == obj.dynamicLoadBalancing);
        }
        break;
    case ID_loadBalancingScheme:
        {  // new scope
        retval = (loadBalancingScheme == obj.loadBalancingScheme);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

