/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PySimulationUIValues.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PySimulationUIValues
//
// Purpose: 
//   Contains UI values from a simulation.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SimulationUIValues.
//
struct SimulationUIValuesObject
{
    PyObject_HEAD
    SimulationUIValues *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSimulationUIValues(int);

std::string
PySimulationUIValues_ToString(const SimulationUIValues *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%shost = \"%s\"\n", prefix, atts->GetHost().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssim = \"%s\"\n", prefix, atts->GetSim().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sname = \"%s\"\n", prefix, atts->GetName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sivalue = %d\n", prefix, atts->GetIvalue());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssvalue = \"%s\"\n", prefix, atts->GetSvalue().c_str());
    str += tmpStr;
    if(atts->GetEnabled())
        SNPRINTF(tmpStr, 1000, "%senabled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%senabled = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
SimulationUIValues_Notify(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SimulationUIValues_SetHost(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the host in the object.
    obj->data->SetHost(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SimulationUIValues_GetHost(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetHost().c_str());
    return retval;
}

/*static*/ PyObject *
SimulationUIValues_SetSim(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the sim in the object.
    obj->data->SetSim(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SimulationUIValues_GetSim(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSim().c_str());
    return retval;
}

/*static*/ PyObject *
SimulationUIValues_SetName(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the name in the object.
    obj->data->SetName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SimulationUIValues_GetName(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetName().c_str());
    return retval;
}

/*static*/ PyObject *
SimulationUIValues_SetIvalue(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the ivalue in the object.
    obj->data->SetIvalue((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SimulationUIValues_GetIvalue(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIvalue()));
    return retval;
}

/*static*/ PyObject *
SimulationUIValues_SetSvalue(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the svalue in the object.
    obj->data->SetSvalue(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SimulationUIValues_GetSvalue(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSvalue().c_str());
    return retval;
}

/*static*/ PyObject *
SimulationUIValues_SetEnabled(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the enabled in the object.
    obj->data->SetEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SimulationUIValues_GetEnabled(PyObject *self, PyObject *args)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetEnabled()?1L:0L);
    return retval;
}



PyMethodDef PySimulationUIValues_methods[SIMULATIONUIVALUES_NMETH] = {
    {"Notify", SimulationUIValues_Notify, METH_VARARGS},
    {"SetHost", SimulationUIValues_SetHost, METH_VARARGS},
    {"GetHost", SimulationUIValues_GetHost, METH_VARARGS},
    {"SetSim", SimulationUIValues_SetSim, METH_VARARGS},
    {"GetSim", SimulationUIValues_GetSim, METH_VARARGS},
    {"SetName", SimulationUIValues_SetName, METH_VARARGS},
    {"GetName", SimulationUIValues_GetName, METH_VARARGS},
    {"SetIvalue", SimulationUIValues_SetIvalue, METH_VARARGS},
    {"GetIvalue", SimulationUIValues_GetIvalue, METH_VARARGS},
    {"SetSvalue", SimulationUIValues_SetSvalue, METH_VARARGS},
    {"GetSvalue", SimulationUIValues_GetSvalue, METH_VARARGS},
    {"SetEnabled", SimulationUIValues_SetEnabled, METH_VARARGS},
    {"GetEnabled", SimulationUIValues_GetEnabled, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SimulationUIValues_dealloc(PyObject *v)
{
   SimulationUIValuesObject *obj = (SimulationUIValuesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SimulationUIValues_compare(PyObject *v, PyObject *w)
{
    SimulationUIValues *a = ((SimulationUIValuesObject *)v)->data;
    SimulationUIValues *b = ((SimulationUIValuesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySimulationUIValues_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "host") == 0)
        return SimulationUIValues_GetHost(self, NULL);
    if(strcmp(name, "sim") == 0)
        return SimulationUIValues_GetSim(self, NULL);
    if(strcmp(name, "name") == 0)
        return SimulationUIValues_GetName(self, NULL);
    if(strcmp(name, "ivalue") == 0)
        return SimulationUIValues_GetIvalue(self, NULL);
    if(strcmp(name, "svalue") == 0)
        return SimulationUIValues_GetSvalue(self, NULL);
    if(strcmp(name, "enabled") == 0)
        return SimulationUIValues_GetEnabled(self, NULL);

    return Py_FindMethod(PySimulationUIValues_methods, self, name);
}

int
PySimulationUIValues_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "host") == 0)
        obj = SimulationUIValues_SetHost(self, tuple);
    else if(strcmp(name, "sim") == 0)
        obj = SimulationUIValues_SetSim(self, tuple);
    else if(strcmp(name, "name") == 0)
        obj = SimulationUIValues_SetName(self, tuple);
    else if(strcmp(name, "ivalue") == 0)
        obj = SimulationUIValues_SetIvalue(self, tuple);
    else if(strcmp(name, "svalue") == 0)
        obj = SimulationUIValues_SetSvalue(self, tuple);
    else if(strcmp(name, "enabled") == 0)
        obj = SimulationUIValues_SetEnabled(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SimulationUIValues_print(PyObject *v, FILE *fp, int flags)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)v;
    fprintf(fp, "%s", PySimulationUIValues_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SimulationUIValues_str(PyObject *v)
{
    SimulationUIValuesObject *obj = (SimulationUIValuesObject *)v;
    return PyString_FromString(PySimulationUIValues_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SimulationUIValues_Purpose = "Contains UI values from a simulation.";
#else
static char *SimulationUIValues_Purpose = "Contains UI values from a simulation.";
#endif

//
// The type description structure
//
static PyTypeObject SimulationUIValuesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SimulationUIValues",                    // tp_name
    sizeof(SimulationUIValuesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SimulationUIValues_dealloc,  // tp_dealloc
    (printfunc)SimulationUIValues_print,     // tp_print
    (getattrfunc)PySimulationUIValues_getattr, // tp_getattr
    (setattrfunc)PySimulationUIValues_setattr, // tp_setattr
    (cmpfunc)SimulationUIValues_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SimulationUIValues_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SimulationUIValues_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SimulationUIValues *defaultAtts = 0;
static SimulationUIValues *currentAtts = 0;

static PyObject *
NewSimulationUIValues(int useCurrent)
{
    SimulationUIValuesObject *newObject;
    newObject = PyObject_NEW(SimulationUIValuesObject, &SimulationUIValuesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SimulationUIValues(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SimulationUIValues(*defaultAtts);
    else
        newObject->data = new SimulationUIValues;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSimulationUIValues(const SimulationUIValues *attr)
{
    SimulationUIValuesObject *newObject;
    newObject = PyObject_NEW(SimulationUIValuesObject, &SimulationUIValuesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SimulationUIValues *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SimulationUIValues_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSimulationUIValues(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SimulationUIValuesMethods[] = {
    {"SimulationUIValues", SimulationUIValues_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SimulationUIValuesObserver = 0;

std::string
PySimulationUIValues_GetLogString()
{
    std::string s("SimulationUIValues = SimulationUIValues()\n");
    if(currentAtts != 0)
        s += PySimulationUIValues_ToString(currentAtts, "SimulationUIValues.");
    return s;
}

static void
PySimulationUIValues_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SimulationUIValues = SimulationUIValues()\n");
        s += PySimulationUIValues_ToString(currentAtts, "SimulationUIValues.");
        cb(s);
    }
}

void
PySimulationUIValues_StartUp(SimulationUIValues *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySimulationUIValues_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SimulationUIValuesObserver == 0)
    {
        SimulationUIValuesObserver = new ObserverToCallback(subj,
            PySimulationUIValues_CallLogRoutine, (void *)data);
    }

}

void
PySimulationUIValues_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SimulationUIValuesObserver;
    SimulationUIValuesObserver = 0;
}

PyMethodDef *
PySimulationUIValues_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SimulationUIValuesMethods;
}

bool
PySimulationUIValues_Check(PyObject *obj)
{
    return (obj->ob_type == &SimulationUIValuesType);
}

SimulationUIValues *
PySimulationUIValues_FromPyObject(PyObject *obj)
{
    SimulationUIValuesObject *obj2 = (SimulationUIValuesObject *)obj;
    return obj2->data;
}

PyObject *
PySimulationUIValues_New()
{
    return NewSimulationUIValues(0);
}

PyObject *
PySimulationUIValues_Wrap(const SimulationUIValues *attr)
{
    return WrapSimulationUIValues(attr);
}

void
PySimulationUIValues_SetParent(PyObject *obj, PyObject *parent)
{
    SimulationUIValuesObject *obj2 = (SimulationUIValuesObject *)obj;
    obj2->parent = parent;
}

void
PySimulationUIValues_SetDefaults(const SimulationUIValues *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SimulationUIValues(*atts);
}

