/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ProcessAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ProcessAttributes::ProcessAttributes
//
// Purpose: 
//   Init utility for the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ProcessAttributes::Init()
{
    isParallel = false;

    ProcessAttributes::SelectAll();
}

// ****************************************************************************
// Method: ProcessAttributes::ProcessAttributes
//
// Purpose: 
//   Copy utility for the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ProcessAttributes::Copy(const ProcessAttributes &obj)
{
    pids = obj.pids;
    ppids = obj.ppids;
    hosts = obj.hosts;
    isParallel = obj.isParallel;
    memory = obj.memory;
    times = obj.times;

    ProcessAttributes::SelectAll();
}

// Type map format string
const char *ProcessAttributes::TypeMapFormatString = PROCESSATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ProcessAttributes::TmfsStruct = {PROCESSATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ProcessAttributes::ProcessAttributes
//
// Purpose: 
//   Default constructor for the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProcessAttributes::ProcessAttributes() : 
    AttributeSubject(ProcessAttributes::TypeMapFormatString)
{
    ProcessAttributes::Init();
}

// ****************************************************************************
// Method: ProcessAttributes::ProcessAttributes
//
// Purpose: 
//   Constructor for the derived classes of ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProcessAttributes::ProcessAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ProcessAttributes::Init();
}

// ****************************************************************************
// Method: ProcessAttributes::ProcessAttributes
//
// Purpose: 
//   Copy constructor for the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProcessAttributes::ProcessAttributes(const ProcessAttributes &obj) : 
    AttributeSubject(ProcessAttributes::TypeMapFormatString)
{
    ProcessAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ProcessAttributes::ProcessAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProcessAttributes::ProcessAttributes(const ProcessAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ProcessAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ProcessAttributes::~ProcessAttributes
//
// Purpose: 
//   Destructor for the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProcessAttributes::~ProcessAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ProcessAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProcessAttributes& 
ProcessAttributes::operator = (const ProcessAttributes &obj)
{
    if (this == &obj) return *this;

    ProcessAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ProcessAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProcessAttributes::operator == (const ProcessAttributes &obj) const
{
    // Create the return value
    return ((pids == obj.pids) &&
            (ppids == obj.ppids) &&
            (hosts == obj.hosts) &&
            (isParallel == obj.isParallel) &&
            (memory == obj.memory) &&
            (times == obj.times));
}

// ****************************************************************************
// Method: ProcessAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProcessAttributes::operator != (const ProcessAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ProcessAttributes::TypeName
//
// Purpose: 
//   Type name method for the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ProcessAttributes::TypeName() const
{
    return "ProcessAttributes";
}

// ****************************************************************************
// Method: ProcessAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProcessAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ProcessAttributes *tmp = (const ProcessAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ProcessAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ProcessAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ProcessAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ProcessAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ProcessAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ProcessAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ProcessAttributes(*this);
    else
        retval = new ProcessAttributes;

    return retval;
}

// ****************************************************************************
// Method: ProcessAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ProcessAttributes::SelectAll()
{
    Select(ID_pids,       (void *)&pids);
    Select(ID_ppids,      (void *)&ppids);
    Select(ID_hosts,      (void *)&hosts);
    Select(ID_isParallel, (void *)&isParallel);
    Select(ID_memory,     (void *)&memory);
    Select(ID_times,      (void *)&times);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ProcessAttributes::SetPids(const intVector &pids_)
{
    pids = pids_;
    Select(ID_pids, (void *)&pids);
}

void
ProcessAttributes::SetPpids(const intVector &ppids_)
{
    ppids = ppids_;
    Select(ID_ppids, (void *)&ppids);
}

void
ProcessAttributes::SetHosts(const stringVector &hosts_)
{
    hosts = hosts_;
    Select(ID_hosts, (void *)&hosts);
}

void
ProcessAttributes::SetIsParallel(bool isParallel_)
{
    isParallel = isParallel_;
    Select(ID_isParallel, (void *)&isParallel);
}

void
ProcessAttributes::SetMemory(const intVector &memory_)
{
    memory = memory_;
    Select(ID_memory, (void *)&memory);
}

void
ProcessAttributes::SetTimes(const doubleVector &times_)
{
    times = times_;
    Select(ID_times, (void *)&times);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const intVector &
ProcessAttributes::GetPids() const
{
    return pids;
}

intVector &
ProcessAttributes::GetPids()
{
    return pids;
}

const intVector &
ProcessAttributes::GetPpids() const
{
    return ppids;
}

intVector &
ProcessAttributes::GetPpids()
{
    return ppids;
}

const stringVector &
ProcessAttributes::GetHosts() const
{
    return hosts;
}

stringVector &
ProcessAttributes::GetHosts()
{
    return hosts;
}

bool
ProcessAttributes::GetIsParallel() const
{
    return isParallel;
}

const intVector &
ProcessAttributes::GetMemory() const
{
    return memory;
}

intVector &
ProcessAttributes::GetMemory()
{
    return memory;
}

const doubleVector &
ProcessAttributes::GetTimes() const
{
    return times;
}

doubleVector &
ProcessAttributes::GetTimes()
{
    return times;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ProcessAttributes::SelectPids()
{
    Select(ID_pids, (void *)&pids);
}

void
ProcessAttributes::SelectPpids()
{
    Select(ID_ppids, (void *)&ppids);
}

void
ProcessAttributes::SelectHosts()
{
    Select(ID_hosts, (void *)&hosts);
}

void
ProcessAttributes::SelectMemory()
{
    Select(ID_memory, (void *)&memory);
}

void
ProcessAttributes::SelectTimes()
{
    Select(ID_times, (void *)&times);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ProcessAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ProcessAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_pids:       return "pids";
    case ID_ppids:      return "ppids";
    case ID_hosts:      return "hosts";
    case ID_isParallel: return "isParallel";
    case ID_memory:     return "memory";
    case ID_times:      return "times";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ProcessAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ProcessAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_pids:       return FieldType_intVector;
    case ID_ppids:      return FieldType_intVector;
    case ID_hosts:      return FieldType_stringVector;
    case ID_isParallel: return FieldType_bool;
    case ID_memory:     return FieldType_intVector;
    case ID_times:      return FieldType_doubleVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ProcessAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ProcessAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_pids:       return "intVector";
    case ID_ppids:      return "intVector";
    case ID_hosts:      return "stringVector";
    case ID_isParallel: return "bool";
    case ID_memory:     return "intVector";
    case ID_times:      return "doubleVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ProcessAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProcessAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ProcessAttributes &obj = *((const ProcessAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_pids:
        {  // new scope
        retval = (pids == obj.pids);
        }
        break;
    case ID_ppids:
        {  // new scope
        retval = (ppids == obj.ppids);
        }
        break;
    case ID_hosts:
        {  // new scope
        retval = (hosts == obj.hosts);
        }
        break;
    case ID_isParallel:
        {  // new scope
        retval = (isParallel == obj.isParallel);
        }
        break;
    case ID_memory:
        {  // new scope
        retval = (memory == obj.memory);
        }
        break;
    case ID_times:
        {  // new scope
        retval = (times == obj.times);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

