/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyDisplaceAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyDisplaceAttributes
//
// Purpose: 
//   This class contains attributes for the displace operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a DisplaceAttributes.
//
struct DisplaceAttributesObject
{
    PyObject_HEAD
    DisplaceAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewDisplaceAttributes(int);

std::string
PyDisplaceAttributes_ToString(const DisplaceAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%sfactor = %g\n", prefix, atts->GetFactor());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svariable = \"%s\"\n", prefix, atts->GetVariable().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
DisplaceAttributes_Notify(PyObject *self, PyObject *args)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DisplaceAttributes_SetFactor(PyObject *self, PyObject *args)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the factor in the object.
    obj->data->SetFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DisplaceAttributes_GetFactor(PyObject *self, PyObject *args)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetFactor());
    return retval;
}

/*static*/ PyObject *
DisplaceAttributes_SetVariable(PyObject *self, PyObject *args)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DisplaceAttributes_GetVariable(PyObject *self, PyObject *args)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}



PyMethodDef PyDisplaceAttributes_methods[DISPLACEATTRIBUTES_NMETH] = {
    {"Notify", DisplaceAttributes_Notify, METH_VARARGS},
    {"SetFactor", DisplaceAttributes_SetFactor, METH_VARARGS},
    {"GetFactor", DisplaceAttributes_GetFactor, METH_VARARGS},
    {"SetVariable", DisplaceAttributes_SetVariable, METH_VARARGS},
    {"GetVariable", DisplaceAttributes_GetVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
DisplaceAttributes_dealloc(PyObject *v)
{
   DisplaceAttributesObject *obj = (DisplaceAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
DisplaceAttributes_compare(PyObject *v, PyObject *w)
{
    DisplaceAttributes *a = ((DisplaceAttributesObject *)v)->data;
    DisplaceAttributes *b = ((DisplaceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyDisplaceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "factor") == 0)
        return DisplaceAttributes_GetFactor(self, NULL);
    if(strcmp(name, "variable") == 0)
        return DisplaceAttributes_GetVariable(self, NULL);

    return Py_FindMethod(PyDisplaceAttributes_methods, self, name);
}

int
PyDisplaceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "factor") == 0)
        obj = DisplaceAttributes_SetFactor(self, tuple);
    else if(strcmp(name, "variable") == 0)
        obj = DisplaceAttributes_SetVariable(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
DisplaceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)v;
    fprintf(fp, "%s", PyDisplaceAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
DisplaceAttributes_str(PyObject *v)
{
    DisplaceAttributesObject *obj = (DisplaceAttributesObject *)v;
    return PyString_FromString(PyDisplaceAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *DisplaceAttributes_Purpose = "This class contains attributes for the displace operator.";
#else
static char *DisplaceAttributes_Purpose = "This class contains attributes for the displace operator.";
#endif

//
// The type description structure
//
static PyTypeObject DisplaceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "DisplaceAttributes",                    // tp_name
    sizeof(DisplaceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)DisplaceAttributes_dealloc,  // tp_dealloc
    (printfunc)DisplaceAttributes_print,     // tp_print
    (getattrfunc)PyDisplaceAttributes_getattr, // tp_getattr
    (setattrfunc)PyDisplaceAttributes_setattr, // tp_setattr
    (cmpfunc)DisplaceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)DisplaceAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    DisplaceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static DisplaceAttributes *defaultAtts = 0;
static DisplaceAttributes *currentAtts = 0;

static PyObject *
NewDisplaceAttributes(int useCurrent)
{
    DisplaceAttributesObject *newObject;
    newObject = PyObject_NEW(DisplaceAttributesObject, &DisplaceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new DisplaceAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new DisplaceAttributes(*defaultAtts);
    else
        newObject->data = new DisplaceAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapDisplaceAttributes(const DisplaceAttributes *attr)
{
    DisplaceAttributesObject *newObject;
    newObject = PyObject_NEW(DisplaceAttributesObject, &DisplaceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (DisplaceAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
DisplaceAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewDisplaceAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef DisplaceAttributesMethods[] = {
    {"DisplaceAttributes", DisplaceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *DisplaceAttributesObserver = 0;

std::string
PyDisplaceAttributes_GetLogString()
{
    std::string s("DisplaceAtts = DisplaceAttributes()\n");
    if(currentAtts != 0)
        s += PyDisplaceAttributes_ToString(currentAtts, "DisplaceAtts.");
    return s;
}

static void
PyDisplaceAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("DisplaceAtts = DisplaceAttributes()\n");
        s += PyDisplaceAttributes_ToString(currentAtts, "DisplaceAtts.");
        cb(s);
    }
}

void
PyDisplaceAttributes_StartUp(DisplaceAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyDisplaceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(DisplaceAttributesObserver == 0)
    {
        DisplaceAttributesObserver = new ObserverToCallback(subj,
            PyDisplaceAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyDisplaceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete DisplaceAttributesObserver;
    DisplaceAttributesObserver = 0;
}

PyMethodDef *
PyDisplaceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return DisplaceAttributesMethods;
}

bool
PyDisplaceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &DisplaceAttributesType);
}

DisplaceAttributes *
PyDisplaceAttributes_FromPyObject(PyObject *obj)
{
    DisplaceAttributesObject *obj2 = (DisplaceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyDisplaceAttributes_New()
{
    return NewDisplaceAttributes(0);
}

PyObject *
PyDisplaceAttributes_Wrap(const DisplaceAttributes *attr)
{
    return WrapDisplaceAttributes(attr);
}

void
PyDisplaceAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    DisplaceAttributesObject *obj2 = (DisplaceAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyDisplaceAttributes_SetDefaults(const DisplaceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new DisplaceAttributes(*atts);
}

