// ***************************************************************************
//
// Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
// Produced at the Lawrence Livermore National Laboratory
// LLNL-CODE-442911
// All rights reserved.
//
// This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
// full copyright notice is contained in the file COPYRIGHT located at the root
// of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
//
// Redistribution  and  use  in  source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of  source code must  retain the above  copyright notice,
//    this list of conditions and the disclaimer below.
//  - Redistributions in binary form must reproduce the above copyright notice,
//    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
//    documentation and/or other materials provided with the distribution.
//  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
//    be used to endorse or promote products derived from this software without
//    specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
// ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
// LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
// DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
// SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
// CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
// LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
// OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ***************************************************************************

package llnl.visit;


// ****************************************************************************
// Class: SurfaceFilterAttributes
//
// Purpose:
//    Attributes for the surface filter
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

public class SurfaceFilterAttributes extends AttributeSubject
{
    private static int SurfaceFilterAttributes_numAdditionalAtts = 11;

    // Enum values
    public final static int SCALING_LINEAR = 0;
    public final static int SCALING_LOG = 1;
    public final static int SCALING_SKEW = 2;

    public final static int LIMITSMODE_ORIGINALDATA = 0;
    public final static int LIMITSMODE_CURRENTPLOT = 1;


    public SurfaceFilterAttributes()
    {
        super(SurfaceFilterAttributes_numAdditionalAtts);

        limitsMode = LIMITSMODE_ORIGINALDATA;
        minFlag = false;
        maxFlag = false;
        scaling = SCALING_LINEAR;
        skewFactor = 1;
        min = 0;
        max = 1;
        zeroFlag = false;
        variable = new String("default");
        useXYLimits = true;
        generateNodalOutput = true;
    }

    public SurfaceFilterAttributes(int nMoreFields)
    {
        super(SurfaceFilterAttributes_numAdditionalAtts + nMoreFields);

        limitsMode = LIMITSMODE_ORIGINALDATA;
        minFlag = false;
        maxFlag = false;
        scaling = SCALING_LINEAR;
        skewFactor = 1;
        min = 0;
        max = 1;
        zeroFlag = false;
        variable = new String("default");
        useXYLimits = true;
        generateNodalOutput = true;
    }

    public SurfaceFilterAttributes(SurfaceFilterAttributes obj)
    {
        super(obj);

        limitsMode = obj.limitsMode;
        minFlag = obj.minFlag;
        maxFlag = obj.maxFlag;
        scaling = obj.scaling;
        skewFactor = obj.skewFactor;
        min = obj.min;
        max = obj.max;
        zeroFlag = obj.zeroFlag;
        variable = new String(obj.variable);
        useXYLimits = obj.useXYLimits;
        generateNodalOutput = obj.generateNodalOutput;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return SurfaceFilterAttributes_numAdditionalAtts;
    }

    public boolean equals(SurfaceFilterAttributes obj)
    {
        // Create the return value
        return ((limitsMode == obj.limitsMode) &&
                (minFlag == obj.minFlag) &&
                (maxFlag == obj.maxFlag) &&
                (scaling == obj.scaling) &&
                (skewFactor == obj.skewFactor) &&
                (min == obj.min) &&
                (max == obj.max) &&
                (zeroFlag == obj.zeroFlag) &&
                (variable.equals(obj.variable)) &&
                (useXYLimits == obj.useXYLimits) &&
                (generateNodalOutput == obj.generateNodalOutput));
    }

    // Property setting methods
    public void SetLimitsMode(int limitsMode_)
    {
        limitsMode = limitsMode_;
        Select(0);
    }

    public void SetMinFlag(boolean minFlag_)
    {
        minFlag = minFlag_;
        Select(1);
    }

    public void SetMaxFlag(boolean maxFlag_)
    {
        maxFlag = maxFlag_;
        Select(2);
    }

    public void SetScaling(int scaling_)
    {
        scaling = scaling_;
        Select(3);
    }

    public void SetSkewFactor(double skewFactor_)
    {
        skewFactor = skewFactor_;
        Select(4);
    }

    public void SetMin(double min_)
    {
        min = min_;
        Select(5);
    }

    public void SetMax(double max_)
    {
        max = max_;
        Select(6);
    }

    public void SetZeroFlag(boolean zeroFlag_)
    {
        zeroFlag = zeroFlag_;
        Select(7);
    }

    public void SetVariable(String variable_)
    {
        variable = variable_;
        Select(8);
    }

    public void SetUseXYLimits(boolean useXYLimits_)
    {
        useXYLimits = useXYLimits_;
        Select(9);
    }

    public void SetGenerateNodalOutput(boolean generateNodalOutput_)
    {
        generateNodalOutput = generateNodalOutput_;
        Select(10);
    }

    // Property getting methods
    public int     GetLimitsMode() { return limitsMode; }
    public boolean GetMinFlag() { return minFlag; }
    public boolean GetMaxFlag() { return maxFlag; }
    public int     GetScaling() { return scaling; }
    public double  GetSkewFactor() { return skewFactor; }
    public double  GetMin() { return min; }
    public double  GetMax() { return max; }
    public boolean GetZeroFlag() { return zeroFlag; }
    public String  GetVariable() { return variable; }
    public boolean GetUseXYLimits() { return useXYLimits; }
    public boolean GetGenerateNodalOutput() { return generateNodalOutput; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(limitsMode);
        if(WriteSelect(1, buf))
            buf.WriteBool(minFlag);
        if(WriteSelect(2, buf))
            buf.WriteBool(maxFlag);
        if(WriteSelect(3, buf))
            buf.WriteInt(scaling);
        if(WriteSelect(4, buf))
            buf.WriteDouble(skewFactor);
        if(WriteSelect(5, buf))
            buf.WriteDouble(min);
        if(WriteSelect(6, buf))
            buf.WriteDouble(max);
        if(WriteSelect(7, buf))
            buf.WriteBool(zeroFlag);
        if(WriteSelect(8, buf))
            buf.WriteString(variable);
        if(WriteSelect(9, buf))
            buf.WriteBool(useXYLimits);
        if(WriteSelect(10, buf))
            buf.WriteBool(generateNodalOutput);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetLimitsMode(buf.ReadInt());
            break;
        case 1:
            SetMinFlag(buf.ReadBool());
            break;
        case 2:
            SetMaxFlag(buf.ReadBool());
            break;
        case 3:
            SetScaling(buf.ReadInt());
            break;
        case 4:
            SetSkewFactor(buf.ReadDouble());
            break;
        case 5:
            SetMin(buf.ReadDouble());
            break;
        case 6:
            SetMax(buf.ReadDouble());
            break;
        case 7:
            SetZeroFlag(buf.ReadBool());
            break;
        case 8:
            SetVariable(buf.ReadString());
            break;
        case 9:
            SetUseXYLimits(buf.ReadBool());
            break;
        case 10:
            SetGenerateNodalOutput(buf.ReadBool());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "limitsMode = ";
        if(limitsMode == LIMITSMODE_ORIGINALDATA)
            str = str + "LIMITSMODE_ORIGINALDATA";
        if(limitsMode == LIMITSMODE_CURRENTPLOT)
            str = str + "LIMITSMODE_CURRENTPLOT";
        str = str + "\n";
        str = str + boolToString("minFlag", minFlag, indent) + "\n";
        str = str + boolToString("maxFlag", maxFlag, indent) + "\n";
        str = str + indent + "scaling = ";
        if(scaling == SCALING_LINEAR)
            str = str + "SCALING_LINEAR";
        if(scaling == SCALING_LOG)
            str = str + "SCALING_LOG";
        if(scaling == SCALING_SKEW)
            str = str + "SCALING_SKEW";
        str = str + "\n";
        str = str + doubleToString("skewFactor", skewFactor, indent) + "\n";
        str = str + doubleToString("min", min, indent) + "\n";
        str = str + doubleToString("max", max, indent) + "\n";
        str = str + boolToString("zeroFlag", zeroFlag, indent) + "\n";
        str = str + stringToString("variable", variable, indent) + "\n";
        str = str + boolToString("useXYLimits", useXYLimits, indent) + "\n";
        str = str + boolToString("generateNodalOutput", generateNodalOutput, indent) + "\n";
        return str;
    }


    // Attributes
    private int     limitsMode;
    private boolean minFlag;
    private boolean maxFlag;
    private int     scaling;
    private double  skewFactor;
    private double  min;
    private double  max;
    private boolean zeroFlag;
    private String  variable;
    private boolean useXYLimits;
    private boolean generateNodalOutput;
}

