/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyFiveFoldTetSubdivisionAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyFiveFoldTetSubdivisionAttributes
//
// Purpose: 
//   Attributes for five fold tetrahedral subdivision operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a FiveFoldTetSubdivisionAttributes.
//
struct FiveFoldTetSubdivisionAttributesObject
{
    PyObject_HEAD
    FiveFoldTetSubdivisionAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewFiveFoldTetSubdivisionAttributes(int);

std::string
PyFiveFoldTetSubdivisionAttributes_ToString(const FiveFoldTetSubdivisionAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetOddParityHasSixNeighborhood())
        SNPRINTF(tmpStr, 1000, "%soddParityHasSixNeighborhood = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%soddParityHasSixNeighborhood = 0\n", prefix);
    str += tmpStr;
    if(atts->GetAddComponentInformation())
        SNPRINTF(tmpStr, 1000, "%saddComponentInformation = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%saddComponentInformation = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sidVar = \"%s\"\n", prefix, atts->GetIdVar().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svalueVar = \"%s\"\n", prefix, atts->GetValueVar().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scontourTreeFilename = \"%s\"\n", prefix, atts->GetContourTreeFilename().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sisovalue = %g\n", prefix, atts->GetIsovalue());
    str += tmpStr;
    {   const intVector &selectedIds = atts->GetSelectedIds();
        SNPRINTF(tmpStr, 1000, "%sselectedIds = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < selectedIds.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", selectedIds[i]);
            str += tmpStr;
            if(i < selectedIds.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &highlightedIds = atts->GetHighlightedIds();
        SNPRINTF(tmpStr, 1000, "%shighlightedIds = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < highlightedIds.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", highlightedIds[i]);
            str += tmpStr;
            if(i < highlightedIds.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
FiveFoldTetSubdivisionAttributes_Notify(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_SetOddParityHasSixNeighborhood(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the oddParityHasSixNeighborhood in the object.
    obj->data->SetOddParityHasSixNeighborhood(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_GetOddParityHasSixNeighborhood(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOddParityHasSixNeighborhood()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_SetAddComponentInformation(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the addComponentInformation in the object.
    obj->data->SetAddComponentInformation(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_GetAddComponentInformation(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAddComponentInformation()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_SetIdVar(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the idVar in the object.
    obj->data->SetIdVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_GetIdVar(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetIdVar().c_str());
    return retval;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_SetValueVar(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the valueVar in the object.
    obj->data->SetValueVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_GetValueVar(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetValueVar().c_str());
    return retval;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_SetContourTreeFilename(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the contourTreeFilename in the object.
    obj->data->SetContourTreeFilename(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_GetContourTreeFilename(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetContourTreeFilename().c_str());
    return retval;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_SetIsovalue(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the isovalue in the object.
    obj->data->SetIsovalue(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_GetIsovalue(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetIsovalue());
    return retval;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_SetSelectedIds(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;

    intVector  &vec = obj->data->GetSelectedIds();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the selectedIds in the object as modified.
    obj->data->SelectSelectedIds();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_GetSelectedIds(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the selectedIds.
    const intVector &selectedIds = obj->data->GetSelectedIds();
    PyObject *retval = PyTuple_New(selectedIds.size());
    for(size_t i = 0; i < selectedIds.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(selectedIds[i])));
    return retval;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_SetHighlightedIds(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;

    intVector  &vec = obj->data->GetHighlightedIds();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the highlightedIds in the object as modified.
    obj->data->SelectHighlightedIds();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FiveFoldTetSubdivisionAttributes_GetHighlightedIds(PyObject *self, PyObject *args)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the highlightedIds.
    const intVector &highlightedIds = obj->data->GetHighlightedIds();
    PyObject *retval = PyTuple_New(highlightedIds.size());
    for(size_t i = 0; i < highlightedIds.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(highlightedIds[i])));
    return retval;
}



PyMethodDef PyFiveFoldTetSubdivisionAttributes_methods[FIVEFOLDTETSUBDIVISIONATTRIBUTES_NMETH] = {
    {"Notify", FiveFoldTetSubdivisionAttributes_Notify, METH_VARARGS},
    {"SetOddParityHasSixNeighborhood", FiveFoldTetSubdivisionAttributes_SetOddParityHasSixNeighborhood, METH_VARARGS},
    {"GetOddParityHasSixNeighborhood", FiveFoldTetSubdivisionAttributes_GetOddParityHasSixNeighborhood, METH_VARARGS},
    {"SetAddComponentInformation", FiveFoldTetSubdivisionAttributes_SetAddComponentInformation, METH_VARARGS},
    {"GetAddComponentInformation", FiveFoldTetSubdivisionAttributes_GetAddComponentInformation, METH_VARARGS},
    {"SetIdVar", FiveFoldTetSubdivisionAttributes_SetIdVar, METH_VARARGS},
    {"GetIdVar", FiveFoldTetSubdivisionAttributes_GetIdVar, METH_VARARGS},
    {"SetValueVar", FiveFoldTetSubdivisionAttributes_SetValueVar, METH_VARARGS},
    {"GetValueVar", FiveFoldTetSubdivisionAttributes_GetValueVar, METH_VARARGS},
    {"SetContourTreeFilename", FiveFoldTetSubdivisionAttributes_SetContourTreeFilename, METH_VARARGS},
    {"GetContourTreeFilename", FiveFoldTetSubdivisionAttributes_GetContourTreeFilename, METH_VARARGS},
    {"SetIsovalue", FiveFoldTetSubdivisionAttributes_SetIsovalue, METH_VARARGS},
    {"GetIsovalue", FiveFoldTetSubdivisionAttributes_GetIsovalue, METH_VARARGS},
    {"SetSelectedIds", FiveFoldTetSubdivisionAttributes_SetSelectedIds, METH_VARARGS},
    {"GetSelectedIds", FiveFoldTetSubdivisionAttributes_GetSelectedIds, METH_VARARGS},
    {"SetHighlightedIds", FiveFoldTetSubdivisionAttributes_SetHighlightedIds, METH_VARARGS},
    {"GetHighlightedIds", FiveFoldTetSubdivisionAttributes_GetHighlightedIds, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
FiveFoldTetSubdivisionAttributes_dealloc(PyObject *v)
{
   FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
FiveFoldTetSubdivisionAttributes_compare(PyObject *v, PyObject *w)
{
    FiveFoldTetSubdivisionAttributes *a = ((FiveFoldTetSubdivisionAttributesObject *)v)->data;
    FiveFoldTetSubdivisionAttributes *b = ((FiveFoldTetSubdivisionAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyFiveFoldTetSubdivisionAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "oddParityHasSixNeighborhood") == 0)
        return FiveFoldTetSubdivisionAttributes_GetOddParityHasSixNeighborhood(self, NULL);
    if(strcmp(name, "addComponentInformation") == 0)
        return FiveFoldTetSubdivisionAttributes_GetAddComponentInformation(self, NULL);
    if(strcmp(name, "idVar") == 0)
        return FiveFoldTetSubdivisionAttributes_GetIdVar(self, NULL);
    if(strcmp(name, "valueVar") == 0)
        return FiveFoldTetSubdivisionAttributes_GetValueVar(self, NULL);
    if(strcmp(name, "contourTreeFilename") == 0)
        return FiveFoldTetSubdivisionAttributes_GetContourTreeFilename(self, NULL);
    if(strcmp(name, "isovalue") == 0)
        return FiveFoldTetSubdivisionAttributes_GetIsovalue(self, NULL);
    if(strcmp(name, "selectedIds") == 0)
        return FiveFoldTetSubdivisionAttributes_GetSelectedIds(self, NULL);
    if(strcmp(name, "highlightedIds") == 0)
        return FiveFoldTetSubdivisionAttributes_GetHighlightedIds(self, NULL);

    return Py_FindMethod(PyFiveFoldTetSubdivisionAttributes_methods, self, name);
}

int
PyFiveFoldTetSubdivisionAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "oddParityHasSixNeighborhood") == 0)
        obj = FiveFoldTetSubdivisionAttributes_SetOddParityHasSixNeighborhood(self, tuple);
    else if(strcmp(name, "addComponentInformation") == 0)
        obj = FiveFoldTetSubdivisionAttributes_SetAddComponentInformation(self, tuple);
    else if(strcmp(name, "idVar") == 0)
        obj = FiveFoldTetSubdivisionAttributes_SetIdVar(self, tuple);
    else if(strcmp(name, "valueVar") == 0)
        obj = FiveFoldTetSubdivisionAttributes_SetValueVar(self, tuple);
    else if(strcmp(name, "contourTreeFilename") == 0)
        obj = FiveFoldTetSubdivisionAttributes_SetContourTreeFilename(self, tuple);
    else if(strcmp(name, "isovalue") == 0)
        obj = FiveFoldTetSubdivisionAttributes_SetIsovalue(self, tuple);
    else if(strcmp(name, "selectedIds") == 0)
        obj = FiveFoldTetSubdivisionAttributes_SetSelectedIds(self, tuple);
    else if(strcmp(name, "highlightedIds") == 0)
        obj = FiveFoldTetSubdivisionAttributes_SetHighlightedIds(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
FiveFoldTetSubdivisionAttributes_print(PyObject *v, FILE *fp, int flags)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)v;
    fprintf(fp, "%s", PyFiveFoldTetSubdivisionAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
FiveFoldTetSubdivisionAttributes_str(PyObject *v)
{
    FiveFoldTetSubdivisionAttributesObject *obj = (FiveFoldTetSubdivisionAttributesObject *)v;
    return PyString_FromString(PyFiveFoldTetSubdivisionAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *FiveFoldTetSubdivisionAttributes_Purpose = "Attributes for five fold tetrahedral subdivision operator";
#else
static char *FiveFoldTetSubdivisionAttributes_Purpose = "Attributes for five fold tetrahedral subdivision operator";
#endif

//
// The type description structure
//
static PyTypeObject FiveFoldTetSubdivisionAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "FiveFoldTetSubdivisionAttributes",                    // tp_name
    sizeof(FiveFoldTetSubdivisionAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)FiveFoldTetSubdivisionAttributes_dealloc,  // tp_dealloc
    (printfunc)FiveFoldTetSubdivisionAttributes_print,     // tp_print
    (getattrfunc)PyFiveFoldTetSubdivisionAttributes_getattr, // tp_getattr
    (setattrfunc)PyFiveFoldTetSubdivisionAttributes_setattr, // tp_setattr
    (cmpfunc)FiveFoldTetSubdivisionAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)FiveFoldTetSubdivisionAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    FiveFoldTetSubdivisionAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static FiveFoldTetSubdivisionAttributes *defaultAtts = 0;
static FiveFoldTetSubdivisionAttributes *currentAtts = 0;

static PyObject *
NewFiveFoldTetSubdivisionAttributes(int useCurrent)
{
    FiveFoldTetSubdivisionAttributesObject *newObject;
    newObject = PyObject_NEW(FiveFoldTetSubdivisionAttributesObject, &FiveFoldTetSubdivisionAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new FiveFoldTetSubdivisionAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new FiveFoldTetSubdivisionAttributes(*defaultAtts);
    else
        newObject->data = new FiveFoldTetSubdivisionAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapFiveFoldTetSubdivisionAttributes(const FiveFoldTetSubdivisionAttributes *attr)
{
    FiveFoldTetSubdivisionAttributesObject *newObject;
    newObject = PyObject_NEW(FiveFoldTetSubdivisionAttributesObject, &FiveFoldTetSubdivisionAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (FiveFoldTetSubdivisionAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
FiveFoldTetSubdivisionAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewFiveFoldTetSubdivisionAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef FiveFoldTetSubdivisionAttributesMethods[] = {
    {"FiveFoldTetSubdivisionAttributes", FiveFoldTetSubdivisionAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *FiveFoldTetSubdivisionAttributesObserver = 0;

std::string
PyFiveFoldTetSubdivisionAttributes_GetLogString()
{
    std::string s("FiveFoldTetSubdivisionAtts = FiveFoldTetSubdivisionAttributes()\n");
    if(currentAtts != 0)
        s += PyFiveFoldTetSubdivisionAttributes_ToString(currentAtts, "FiveFoldTetSubdivisionAtts.");
    return s;
}

static void
PyFiveFoldTetSubdivisionAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("FiveFoldTetSubdivisionAtts = FiveFoldTetSubdivisionAttributes()\n");
        s += PyFiveFoldTetSubdivisionAttributes_ToString(currentAtts, "FiveFoldTetSubdivisionAtts.");
        cb(s);
    }
}

void
PyFiveFoldTetSubdivisionAttributes_StartUp(FiveFoldTetSubdivisionAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyFiveFoldTetSubdivisionAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(FiveFoldTetSubdivisionAttributesObserver == 0)
    {
        FiveFoldTetSubdivisionAttributesObserver = new ObserverToCallback(subj,
            PyFiveFoldTetSubdivisionAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyFiveFoldTetSubdivisionAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete FiveFoldTetSubdivisionAttributesObserver;
    FiveFoldTetSubdivisionAttributesObserver = 0;
}

PyMethodDef *
PyFiveFoldTetSubdivisionAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return FiveFoldTetSubdivisionAttributesMethods;
}

bool
PyFiveFoldTetSubdivisionAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &FiveFoldTetSubdivisionAttributesType);
}

FiveFoldTetSubdivisionAttributes *
PyFiveFoldTetSubdivisionAttributes_FromPyObject(PyObject *obj)
{
    FiveFoldTetSubdivisionAttributesObject *obj2 = (FiveFoldTetSubdivisionAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyFiveFoldTetSubdivisionAttributes_New()
{
    return NewFiveFoldTetSubdivisionAttributes(0);
}

PyObject *
PyFiveFoldTetSubdivisionAttributes_Wrap(const FiveFoldTetSubdivisionAttributes *attr)
{
    return WrapFiveFoldTetSubdivisionAttributes(attr);
}

void
PyFiveFoldTetSubdivisionAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    FiveFoldTetSubdivisionAttributesObject *obj2 = (FiveFoldTetSubdivisionAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyFiveFoldTetSubdivisionAttributes_SetDefaults(const FiveFoldTetSubdivisionAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new FiveFoldTetSubdivisionAttributes(*atts);
}

