/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SphereAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: SphereAttributes::SphereAttributes
//
// Purpose: 
//   Init utility for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SphereAttributes::Init()
{
    origin[0] = 0;
    origin[1] = 0;
    origin[2] = 0;
    radius = 1;

    SphereAttributes::SelectAll();
}

// ****************************************************************************
// Method: SphereAttributes::SphereAttributes
//
// Purpose: 
//   Copy utility for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SphereAttributes::Copy(const SphereAttributes &obj)
{
    origin[0] = obj.origin[0];
    origin[1] = obj.origin[1];
    origin[2] = obj.origin[2];

    radius = obj.radius;

    SphereAttributes::SelectAll();
}

// Type map format string
const char *SphereAttributes::TypeMapFormatString = SPHEREATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t SphereAttributes::TmfsStruct = {SPHEREATTRIBUTES_TMFS};


// ****************************************************************************
// Method: SphereAttributes::SphereAttributes
//
// Purpose: 
//   Default constructor for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SphereAttributes::SphereAttributes() : 
    AttributeSubject(SphereAttributes::TypeMapFormatString)
{
    SphereAttributes::Init();
}

// ****************************************************************************
// Method: SphereAttributes::SphereAttributes
//
// Purpose: 
//   Constructor for the derived classes of SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SphereAttributes::SphereAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SphereAttributes::Init();
}

// ****************************************************************************
// Method: SphereAttributes::SphereAttributes
//
// Purpose: 
//   Copy constructor for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SphereAttributes::SphereAttributes(const SphereAttributes &obj) : 
    AttributeSubject(SphereAttributes::TypeMapFormatString)
{
    SphereAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SphereAttributes::SphereAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SphereAttributes::SphereAttributes(const SphereAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SphereAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SphereAttributes::~SphereAttributes
//
// Purpose: 
//   Destructor for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SphereAttributes::~SphereAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SphereAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SphereAttributes& 
SphereAttributes::operator = (const SphereAttributes &obj)
{
    if (this == &obj) return *this;

    SphereAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SphereAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SphereAttributes::operator == (const SphereAttributes &obj) const
{
    // Compare the origin arrays.
    bool origin_equal = true;
    for(int i = 0; i < 3 && origin_equal; ++i)
        origin_equal = (origin[i] == obj.origin[i]);

    // Create the return value
    return (origin_equal &&
            (radius == obj.radius));
}

// ****************************************************************************
// Method: SphereAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SphereAttributes::operator != (const SphereAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SphereAttributes::TypeName
//
// Purpose: 
//   Type name method for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SphereAttributes::TypeName() const
{
    return "SphereAttributes";
}

// ****************************************************************************
// Method: SphereAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SphereAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SphereAttributes *tmp = (const SphereAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SphereAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SphereAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SphereAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SphereAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SphereAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SphereAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SphereAttributes(*this);
    else
        retval = new SphereAttributes;

    return retval;
}

// ****************************************************************************
// Method: SphereAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SphereAttributes::SelectAll()
{
    Select(ID_origin, (void *)origin, 3);
    Select(ID_radius, (void *)&radius);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SphereAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SphereAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SphereAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SphereAttributes.
    DataNode *node = new DataNode("SphereAttributes");

    if(completeSave || !FieldsEqual(ID_origin, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("origin", origin, 3));
    }

    if(completeSave || !FieldsEqual(ID_radius, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("radius", radius));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SphereAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SphereAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SphereAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("origin")) != 0)
        SetOrigin(node->AsDoubleArray());
    if((node = searchNode->GetNode("radius")) != 0)
        SetRadius(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SphereAttributes::SetOrigin(const double *origin_)
{
    origin[0] = origin_[0];
    origin[1] = origin_[1];
    origin[2] = origin_[2];
    Select(ID_origin, (void *)origin, 3);
}

void
SphereAttributes::SetRadius(double radius_)
{
    radius = radius_;
    Select(ID_radius, (void *)&radius);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
SphereAttributes::GetOrigin() const
{
    return origin;
}

double *
SphereAttributes::GetOrigin()
{
    return origin;
}

double
SphereAttributes::GetRadius() const
{
    return radius;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SphereAttributes::SelectOrigin()
{
    Select(ID_origin, (void *)origin, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SphereAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SphereAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_origin: return "origin";
    case ID_radius: return "radius";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SphereAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SphereAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_origin: return FieldType_doubleArray;
    case ID_radius: return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SphereAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SphereAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_origin: return "doubleArray";
    case ID_radius: return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SphereAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SphereAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SphereAttributes &obj = *((const SphereAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_origin:
        {  // new scope
        // Compare the origin arrays.
        bool origin_equal = true;
        for(int i = 0; i < 3 && origin_equal; ++i)
            origin_equal = (origin[i] == obj.origin[i]);

        retval = origin_equal;
        }
        break;
    case ID_radius:
        {  // new scope
        retval = (radius == obj.radius);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

