/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyavtSymmetricTensorMetaData.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyavtSymmetricTensorMetaData
//
// Purpose: 
//   Contains symmetricTensor metadata attributes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtSymmetricTensorMetaData.
//
struct avtSymmetricTensorMetaDataObject
{
    PyObject_HEAD
    avtSymmetricTensorMetaData *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtSymmetricTensorMetaData(int);

std::string
PyavtSymmetricTensorMetaData_ToString(const avtSymmetricTensorMetaData *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    str = PyavtVarMetaData_ToString(atts, prefix);

    SNPRINTF(tmpStr, 1000, "%sdim = %d\n", prefix, atts->dim);
    str += tmpStr;
    return str;
}

static PyObject *
avtSymmetricTensorMetaData_Notify(PyObject *self, PyObject *args)
{
    avtSymmetricTensorMetaDataObject *obj = (avtSymmetricTensorMetaDataObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSymmetricTensorMetaData_SetDim(PyObject *self, PyObject *args)
{
    avtSymmetricTensorMetaDataObject *obj = (avtSymmetricTensorMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dim in the object.
    obj->data->dim = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSymmetricTensorMetaData_GetDim(PyObject *self, PyObject *args)
{
    avtSymmetricTensorMetaDataObject *obj = (avtSymmetricTensorMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->dim));
    return retval;
}



PyMethodDef PyavtSymmetricTensorMetaData_methods[AVTSYMMETRICTENSORMETADATA_NMETH] = {
    {"Notify", avtSymmetricTensorMetaData_Notify, METH_VARARGS},
    {"SetDim", avtSymmetricTensorMetaData_SetDim, METH_VARARGS},
    {"GetDim", avtSymmetricTensorMetaData_GetDim, METH_VARARGS},
    {NULL, NULL}
};

static void PyavtSymmetricTensorMetaData_ExtendSetGetMethodTable()
{
    static bool extended = false;
    if (extended) return;
    extended = true;

    int i = 0;
    while (PyavtSymmetricTensorMetaData_methods[i].ml_name)
        i++;
    int n = i;
    while (PyavtVarMetaData_methods[i-n+1].ml_name)
    {
        PyavtSymmetricTensorMetaData_methods[i] = PyavtVarMetaData_methods[i-n+1];
        i++;
    }

    PyMethodDef nullMethod = {NULL, NULL};
    PyavtSymmetricTensorMetaData_methods[i] = nullMethod;
}

//
// Type functions
//

static void
avtSymmetricTensorMetaData_dealloc(PyObject *v)
{
   avtSymmetricTensorMetaDataObject *obj = (avtSymmetricTensorMetaDataObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtSymmetricTensorMetaData_compare(PyObject *v, PyObject *w)
{
    avtSymmetricTensorMetaData *a = ((avtSymmetricTensorMetaDataObject *)v)->data;
    avtSymmetricTensorMetaData *b = ((avtSymmetricTensorMetaDataObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtSymmetricTensorMetaData_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "dim") == 0)
        return avtSymmetricTensorMetaData_GetDim(self, NULL);

    if(strcmp(name, "__methods__") != 0)
    {
        PyObject *retval = PyavtVarMetaData_getattr(self, name);
        if (retval) return retval;
    }

    PyavtSymmetricTensorMetaData_ExtendSetGetMethodTable();

    return Py_FindMethod(PyavtSymmetricTensorMetaData_methods, self, name);
}

int
PyavtSymmetricTensorMetaData_setattr(PyObject *self, char *name, PyObject *args)
{
    if (PyavtVarMetaData_setattr(self, name, args) != -1)
        return 0;
    else
        PyErr_Clear();

    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "dim") == 0)
        obj = avtSymmetricTensorMetaData_SetDim(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
avtSymmetricTensorMetaData_print(PyObject *v, FILE *fp, int flags)
{
    avtSymmetricTensorMetaDataObject *obj = (avtSymmetricTensorMetaDataObject *)v;
    fprintf(fp, "%s", PyavtSymmetricTensorMetaData_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtSymmetricTensorMetaData_str(PyObject *v)
{
    avtSymmetricTensorMetaDataObject *obj = (avtSymmetricTensorMetaDataObject *)v;
    return PyString_FromString(PyavtSymmetricTensorMetaData_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtSymmetricTensorMetaData_Purpose = "Contains symmetricTensor metadata attributes";
#else
static char *avtSymmetricTensorMetaData_Purpose = "Contains symmetricTensor metadata attributes";
#endif

//
// The type description structure
//
static PyTypeObject avtSymmetricTensorMetaDataType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtSymmetricTensorMetaData",                    // tp_name
    sizeof(avtSymmetricTensorMetaDataObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtSymmetricTensorMetaData_dealloc,  // tp_dealloc
    (printfunc)avtSymmetricTensorMetaData_print,     // tp_print
    (getattrfunc)PyavtSymmetricTensorMetaData_getattr, // tp_getattr
    (setattrfunc)PyavtSymmetricTensorMetaData_setattr, // tp_setattr
    (cmpfunc)avtSymmetricTensorMetaData_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtSymmetricTensorMetaData_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtSymmetricTensorMetaData_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtSymmetricTensorMetaData *defaultAtts = 0;
static avtSymmetricTensorMetaData *currentAtts = 0;

static PyObject *
NewavtSymmetricTensorMetaData(int useCurrent)
{
    avtSymmetricTensorMetaDataObject *newObject;
    newObject = PyObject_NEW(avtSymmetricTensorMetaDataObject, &avtSymmetricTensorMetaDataType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtSymmetricTensorMetaData(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtSymmetricTensorMetaData(*defaultAtts);
    else
        newObject->data = new avtSymmetricTensorMetaData;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtSymmetricTensorMetaData(const avtSymmetricTensorMetaData *attr)
{
    avtSymmetricTensorMetaDataObject *newObject;
    newObject = PyObject_NEW(avtSymmetricTensorMetaDataObject, &avtSymmetricTensorMetaDataType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtSymmetricTensorMetaData *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtSymmetricTensorMetaData_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtSymmetricTensorMetaData(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtSymmetricTensorMetaDataMethods[] = {
    {"avtSymmetricTensorMetaData", avtSymmetricTensorMetaData_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtSymmetricTensorMetaDataObserver = 0;

std::string
PyavtSymmetricTensorMetaData_GetLogString()
{
    std::string s("avtSymmetricTensorMetaData = avtSymmetricTensorMetaData()\n");
    if(currentAtts != 0)
        s += PyavtSymmetricTensorMetaData_ToString(currentAtts, "avtSymmetricTensorMetaData.");
    return s;
}

static void
PyavtSymmetricTensorMetaData_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtSymmetricTensorMetaData = avtSymmetricTensorMetaData()\n");
        s += PyavtSymmetricTensorMetaData_ToString(currentAtts, "avtSymmetricTensorMetaData.");
        cb(s);
    }
}

void
PyavtSymmetricTensorMetaData_StartUp(avtSymmetricTensorMetaData *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtSymmetricTensorMetaData_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtSymmetricTensorMetaDataObserver == 0)
    {
        avtSymmetricTensorMetaDataObserver = new ObserverToCallback(subj,
            PyavtSymmetricTensorMetaData_CallLogRoutine, (void *)data);
    }

}

void
PyavtSymmetricTensorMetaData_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtSymmetricTensorMetaDataObserver;
    avtSymmetricTensorMetaDataObserver = 0;
}

PyMethodDef *
PyavtSymmetricTensorMetaData_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtSymmetricTensorMetaDataMethods;
}

bool
PyavtSymmetricTensorMetaData_Check(PyObject *obj)
{
    return (obj->ob_type == &avtSymmetricTensorMetaDataType);
}

avtSymmetricTensorMetaData *
PyavtSymmetricTensorMetaData_FromPyObject(PyObject *obj)
{
    avtSymmetricTensorMetaDataObject *obj2 = (avtSymmetricTensorMetaDataObject *)obj;
    return obj2->data;
}

PyObject *
PyavtSymmetricTensorMetaData_New()
{
    return NewavtSymmetricTensorMetaData(0);
}

PyObject *
PyavtSymmetricTensorMetaData_Wrap(const avtSymmetricTensorMetaData *attr)
{
    return WrapavtSymmetricTensorMetaData(attr);
}

void
PyavtSymmetricTensorMetaData_SetParent(PyObject *obj, PyObject *parent)
{
    avtSymmetricTensorMetaDataObject *obj2 = (avtSymmetricTensorMetaDataObject *)obj;
    obj2->parent = parent;
}

void
PyavtSymmetricTensorMetaData_SetDefaults(const avtSymmetricTensorMetaData *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtSymmetricTensorMetaData(*atts);
}

