/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyavtLabelMetaData.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyavtLabelMetaData
//
// Purpose: 
//   Contains label metadata attributes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtLabelMetaData.
//
struct avtLabelMetaDataObject
{
    PyObject_HEAD
    avtLabelMetaData *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtLabelMetaData(int);

std::string
PyavtLabelMetaData_ToString(const avtLabelMetaData *atts, const char *prefix)
{
    std::string str;

    str = PyavtVarMetaData_ToString(atts, prefix);

    return str;
}

static PyObject *
avtLabelMetaData_Notify(PyObject *self, PyObject *args)
{
    avtLabelMetaDataObject *obj = (avtLabelMetaDataObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}



PyMethodDef PyavtLabelMetaData_methods[AVTLABELMETADATA_NMETH] = {
    {"Notify", avtLabelMetaData_Notify, METH_VARARGS},
    {NULL, NULL}
};

static void PyavtLabelMetaData_ExtendSetGetMethodTable()
{
    static bool extended = false;
    if (extended) return;
    extended = true;

    int i = 0;
    while (PyavtLabelMetaData_methods[i].ml_name)
        i++;
    int n = i;
    while (PyavtVarMetaData_methods[i-n+1].ml_name)
    {
        PyavtLabelMetaData_methods[i] = PyavtVarMetaData_methods[i-n+1];
        i++;
    }

    PyMethodDef nullMethod = {NULL, NULL};
    PyavtLabelMetaData_methods[i] = nullMethod;
}

//
// Type functions
//

static void
avtLabelMetaData_dealloc(PyObject *v)
{
   avtLabelMetaDataObject *obj = (avtLabelMetaDataObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtLabelMetaData_compare(PyObject *v, PyObject *w)
{
    avtLabelMetaData *a = ((avtLabelMetaDataObject *)v)->data;
    avtLabelMetaData *b = ((avtLabelMetaDataObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtLabelMetaData_getattr(PyObject *self, char *name)
{

    if(strcmp(name, "__methods__") != 0)
    {
        PyObject *retval = PyavtVarMetaData_getattr(self, name);
        if (retval) return retval;
    }

    PyavtLabelMetaData_ExtendSetGetMethodTable();

    return Py_FindMethod(PyavtLabelMetaData_methods, self, name);
}

int
PyavtLabelMetaData_setattr(PyObject *self, char *name, PyObject *args)
{
    if (PyavtVarMetaData_setattr(self, name, args) != -1)
        return 0;
    else
        PyErr_Clear();

    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;


    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
avtLabelMetaData_print(PyObject *v, FILE *fp, int flags)
{
    avtLabelMetaDataObject *obj = (avtLabelMetaDataObject *)v;
    fprintf(fp, "%s", PyavtLabelMetaData_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtLabelMetaData_str(PyObject *v)
{
    avtLabelMetaDataObject *obj = (avtLabelMetaDataObject *)v;
    return PyString_FromString(PyavtLabelMetaData_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtLabelMetaData_Purpose = "Contains label metadata attributes";
#else
static char *avtLabelMetaData_Purpose = "Contains label metadata attributes";
#endif

//
// The type description structure
//
static PyTypeObject avtLabelMetaDataType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtLabelMetaData",                    // tp_name
    sizeof(avtLabelMetaDataObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtLabelMetaData_dealloc,  // tp_dealloc
    (printfunc)avtLabelMetaData_print,     // tp_print
    (getattrfunc)PyavtLabelMetaData_getattr, // tp_getattr
    (setattrfunc)PyavtLabelMetaData_setattr, // tp_setattr
    (cmpfunc)avtLabelMetaData_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtLabelMetaData_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtLabelMetaData_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtLabelMetaData *defaultAtts = 0;
static avtLabelMetaData *currentAtts = 0;

static PyObject *
NewavtLabelMetaData(int useCurrent)
{
    avtLabelMetaDataObject *newObject;
    newObject = PyObject_NEW(avtLabelMetaDataObject, &avtLabelMetaDataType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtLabelMetaData(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtLabelMetaData(*defaultAtts);
    else
        newObject->data = new avtLabelMetaData;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtLabelMetaData(const avtLabelMetaData *attr)
{
    avtLabelMetaDataObject *newObject;
    newObject = PyObject_NEW(avtLabelMetaDataObject, &avtLabelMetaDataType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtLabelMetaData *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtLabelMetaData_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtLabelMetaData(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtLabelMetaDataMethods[] = {
    {"avtLabelMetaData", avtLabelMetaData_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtLabelMetaDataObserver = 0;

std::string
PyavtLabelMetaData_GetLogString()
{
    std::string s("avtLabelMetaData = avtLabelMetaData()\n");
    if(currentAtts != 0)
        s += PyavtLabelMetaData_ToString(currentAtts, "avtLabelMetaData.");
    return s;
}

static void
PyavtLabelMetaData_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtLabelMetaData = avtLabelMetaData()\n");
        s += PyavtLabelMetaData_ToString(currentAtts, "avtLabelMetaData.");
        cb(s);
    }
}

void
PyavtLabelMetaData_StartUp(avtLabelMetaData *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtLabelMetaData_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtLabelMetaDataObserver == 0)
    {
        avtLabelMetaDataObserver = new ObserverToCallback(subj,
            PyavtLabelMetaData_CallLogRoutine, (void *)data);
    }

}

void
PyavtLabelMetaData_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtLabelMetaDataObserver;
    avtLabelMetaDataObserver = 0;
}

PyMethodDef *
PyavtLabelMetaData_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtLabelMetaDataMethods;
}

bool
PyavtLabelMetaData_Check(PyObject *obj)
{
    return (obj->ob_type == &avtLabelMetaDataType);
}

avtLabelMetaData *
PyavtLabelMetaData_FromPyObject(PyObject *obj)
{
    avtLabelMetaDataObject *obj2 = (avtLabelMetaDataObject *)obj;
    return obj2->data;
}

PyObject *
PyavtLabelMetaData_New()
{
    return NewavtLabelMetaData(0);
}

PyObject *
PyavtLabelMetaData_Wrap(const avtLabelMetaData *attr)
{
    return WrapavtLabelMetaData(attr);
}

void
PyavtLabelMetaData_SetParent(PyObject *obj, PyObject *parent)
{
    avtLabelMetaDataObject *obj2 = (avtLabelMetaDataObject *)obj;
    obj2->parent = parent;
}

void
PyavtLabelMetaData_SetDefaults(const avtLabelMetaData *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtLabelMetaData(*atts);
}

