/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisExternalSurfaceWindow.h"

#include <ExternalSurfaceAttributes.h>

#include <QCheckBox>
#include <QLayout>


// ****************************************************************************
// Method: QvisExternalSurfaceWindow::QvisExternalSurfaceWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisExternalSurfaceWindow::QvisExternalSurfaceWindow(const int type,
                         ExternalSurfaceAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisExternalSurfaceWindow::~QvisExternalSurfaceWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisExternalSurfaceWindow::~QvisExternalSurfaceWindow()
{
}


// ****************************************************************************
// Method: QvisExternalSurfaceWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisExternalSurfaceWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    removeGhosts = new QCheckBox(tr("Remove ghost faces?"), central);
    connect(removeGhosts, SIGNAL(toggled(bool)),
            this, SLOT(removeGhostsChanged(bool)));
    mainLayout->addWidget(removeGhosts, 0,0);

    edgesIn2D = new QCheckBox(tr("Find external edges for 2D datasets"), central);
    connect(edgesIn2D, SIGNAL(toggled(bool)),
            this, SLOT(edgesIn2DChanged(bool)));
    mainLayout->addWidget(edgesIn2D, 1,0);

}


// ****************************************************************************
// Method: QvisExternalSurfaceWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisExternalSurfaceWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case ExternalSurfaceAttributes::ID_removeGhosts:
            removeGhosts->blockSignals(true);
            removeGhosts->setChecked(atts->GetRemoveGhosts());
            removeGhosts->blockSignals(false);
            break;
          case ExternalSurfaceAttributes::ID_edgesIn2D:
            edgesIn2D->blockSignals(true);
            edgesIn2D->setChecked(atts->GetEdgesIn2D());
            edgesIn2D->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisExternalSurfaceWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisExternalSurfaceWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisExternalSurfaceWindow::removeGhostsChanged(bool val)
{
    atts->SetRemoveGhosts(val);
    SetUpdate(false);
    Apply();
}


void
QvisExternalSurfaceWindow::edgesIn2DChanged(bool val)
{
    atts->SetEdgesIn2D(val);
    SetUpdate(false);
    Apply();
}


