/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyCartographicProjectionAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyCartographicProjectionAttributes
//
// Purpose: 
//   
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a CartographicProjectionAttributes.
//
struct CartographicProjectionAttributesObject
{
    PyObject_HEAD
    CartographicProjectionAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewCartographicProjectionAttributes(int);

std::string
PyCartographicProjectionAttributes_ToString(const CartographicProjectionAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *projectionID_names = "aitoff, eck4, eqdc, hammer, laea, "
        "lcc, merc, mill, moll, "
        "ortho, wink2";
    switch (atts->GetProjectionID())
    {
      case CartographicProjectionAttributes::aitoff:
          SNPRINTF(tmpStr, 1000, "%sprojectionID = %saitoff  # %s\n", prefix, prefix, projectionID_names);
          str += tmpStr;
          break;
      case CartographicProjectionAttributes::eck4:
          SNPRINTF(tmpStr, 1000, "%sprojectionID = %seck4  # %s\n", prefix, prefix, projectionID_names);
          str += tmpStr;
          break;
      case CartographicProjectionAttributes::eqdc:
          SNPRINTF(tmpStr, 1000, "%sprojectionID = %seqdc  # %s\n", prefix, prefix, projectionID_names);
          str += tmpStr;
          break;
      case CartographicProjectionAttributes::hammer:
          SNPRINTF(tmpStr, 1000, "%sprojectionID = %shammer  # %s\n", prefix, prefix, projectionID_names);
          str += tmpStr;
          break;
      case CartographicProjectionAttributes::laea:
          SNPRINTF(tmpStr, 1000, "%sprojectionID = %slaea  # %s\n", prefix, prefix, projectionID_names);
          str += tmpStr;
          break;
      case CartographicProjectionAttributes::lcc:
          SNPRINTF(tmpStr, 1000, "%sprojectionID = %slcc  # %s\n", prefix, prefix, projectionID_names);
          str += tmpStr;
          break;
      case CartographicProjectionAttributes::merc:
          SNPRINTF(tmpStr, 1000, "%sprojectionID = %smerc  # %s\n", prefix, prefix, projectionID_names);
          str += tmpStr;
          break;
      case CartographicProjectionAttributes::mill:
          SNPRINTF(tmpStr, 1000, "%sprojectionID = %smill  # %s\n", prefix, prefix, projectionID_names);
          str += tmpStr;
          break;
      case CartographicProjectionAttributes::moll:
          SNPRINTF(tmpStr, 1000, "%sprojectionID = %smoll  # %s\n", prefix, prefix, projectionID_names);
          str += tmpStr;
          break;
      case CartographicProjectionAttributes::ortho:
          SNPRINTF(tmpStr, 1000, "%sprojectionID = %sortho  # %s\n", prefix, prefix, projectionID_names);
          str += tmpStr;
          break;
      case CartographicProjectionAttributes::wink2:
          SNPRINTF(tmpStr, 1000, "%sprojectionID = %swink2  # %s\n", prefix, prefix, projectionID_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%scentralMeridian = %g\n", prefix, atts->GetCentralMeridian());
    str += tmpStr;
    return str;
}

static PyObject *
CartographicProjectionAttributes_Notify(PyObject *self, PyObject *args)
{
    CartographicProjectionAttributesObject *obj = (CartographicProjectionAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CartographicProjectionAttributes_SetProjectionID(PyObject *self, PyObject *args)
{
    CartographicProjectionAttributesObject *obj = (CartographicProjectionAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the projectionID in the object.
    if(ival >= 0 && ival < 11)
        obj->data->SetProjectionID(CartographicProjectionAttributes::ProjectionID(ival));
    else
    {
        fprintf(stderr, "An invalid projectionID value was given. "
                        "Valid values are in the range of [0,10]. "
                        "You can also use the following names: "
                        "aitoff, eck4, eqdc, hammer, laea, "
                        "lcc, merc, mill, moll, "
                        "ortho, wink2.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CartographicProjectionAttributes_GetProjectionID(PyObject *self, PyObject *args)
{
    CartographicProjectionAttributesObject *obj = (CartographicProjectionAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetProjectionID()));
    return retval;
}

/*static*/ PyObject *
CartographicProjectionAttributes_SetCentralMeridian(PyObject *self, PyObject *args)
{
    CartographicProjectionAttributesObject *obj = (CartographicProjectionAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the centralMeridian in the object.
    obj->data->SetCentralMeridian(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CartographicProjectionAttributes_GetCentralMeridian(PyObject *self, PyObject *args)
{
    CartographicProjectionAttributesObject *obj = (CartographicProjectionAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCentralMeridian());
    return retval;
}



PyMethodDef PyCartographicProjectionAttributes_methods[CARTOGRAPHICPROJECTIONATTRIBUTES_NMETH] = {
    {"Notify", CartographicProjectionAttributes_Notify, METH_VARARGS},
    {"SetProjectionID", CartographicProjectionAttributes_SetProjectionID, METH_VARARGS},
    {"GetProjectionID", CartographicProjectionAttributes_GetProjectionID, METH_VARARGS},
    {"SetCentralMeridian", CartographicProjectionAttributes_SetCentralMeridian, METH_VARARGS},
    {"GetCentralMeridian", CartographicProjectionAttributes_GetCentralMeridian, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
CartographicProjectionAttributes_dealloc(PyObject *v)
{
   CartographicProjectionAttributesObject *obj = (CartographicProjectionAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
CartographicProjectionAttributes_compare(PyObject *v, PyObject *w)
{
    CartographicProjectionAttributes *a = ((CartographicProjectionAttributesObject *)v)->data;
    CartographicProjectionAttributes *b = ((CartographicProjectionAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyCartographicProjectionAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "projectionID") == 0)
        return CartographicProjectionAttributes_GetProjectionID(self, NULL);
    if(strcmp(name, "aitoff") == 0)
        return PyInt_FromLong(long(CartographicProjectionAttributes::aitoff));
    if(strcmp(name, "eck4") == 0)
        return PyInt_FromLong(long(CartographicProjectionAttributes::eck4));
    if(strcmp(name, "eqdc") == 0)
        return PyInt_FromLong(long(CartographicProjectionAttributes::eqdc));
    if(strcmp(name, "hammer") == 0)
        return PyInt_FromLong(long(CartographicProjectionAttributes::hammer));
    if(strcmp(name, "laea") == 0)
        return PyInt_FromLong(long(CartographicProjectionAttributes::laea));
    if(strcmp(name, "lcc") == 0)
        return PyInt_FromLong(long(CartographicProjectionAttributes::lcc));
    if(strcmp(name, "merc") == 0)
        return PyInt_FromLong(long(CartographicProjectionAttributes::merc));
    if(strcmp(name, "mill") == 0)
        return PyInt_FromLong(long(CartographicProjectionAttributes::mill));
    if(strcmp(name, "moll") == 0)
        return PyInt_FromLong(long(CartographicProjectionAttributes::moll));
    if(strcmp(name, "ortho") == 0)
        return PyInt_FromLong(long(CartographicProjectionAttributes::ortho));
    if(strcmp(name, "wink2") == 0)
        return PyInt_FromLong(long(CartographicProjectionAttributes::wink2));

    if(strcmp(name, "centralMeridian") == 0)
        return CartographicProjectionAttributes_GetCentralMeridian(self, NULL);

    return Py_FindMethod(PyCartographicProjectionAttributes_methods, self, name);
}

int
PyCartographicProjectionAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "projectionID") == 0)
        obj = CartographicProjectionAttributes_SetProjectionID(self, tuple);
    else if(strcmp(name, "centralMeridian") == 0)
        obj = CartographicProjectionAttributes_SetCentralMeridian(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
CartographicProjectionAttributes_print(PyObject *v, FILE *fp, int flags)
{
    CartographicProjectionAttributesObject *obj = (CartographicProjectionAttributesObject *)v;
    fprintf(fp, "%s", PyCartographicProjectionAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
CartographicProjectionAttributes_str(PyObject *v)
{
    CartographicProjectionAttributesObject *obj = (CartographicProjectionAttributesObject *)v;
    return PyString_FromString(PyCartographicProjectionAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *CartographicProjectionAttributes_Purpose = "";
#else
static char *CartographicProjectionAttributes_Purpose = "";
#endif

//
// The type description structure
//
static PyTypeObject CartographicProjectionAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "CartographicProjectionAttributes",                    // tp_name
    sizeof(CartographicProjectionAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)CartographicProjectionAttributes_dealloc,  // tp_dealloc
    (printfunc)CartographicProjectionAttributes_print,     // tp_print
    (getattrfunc)PyCartographicProjectionAttributes_getattr, // tp_getattr
    (setattrfunc)PyCartographicProjectionAttributes_setattr, // tp_setattr
    (cmpfunc)CartographicProjectionAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)CartographicProjectionAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    CartographicProjectionAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static CartographicProjectionAttributes *defaultAtts = 0;
static CartographicProjectionAttributes *currentAtts = 0;

static PyObject *
NewCartographicProjectionAttributes(int useCurrent)
{
    CartographicProjectionAttributesObject *newObject;
    newObject = PyObject_NEW(CartographicProjectionAttributesObject, &CartographicProjectionAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new CartographicProjectionAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new CartographicProjectionAttributes(*defaultAtts);
    else
        newObject->data = new CartographicProjectionAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapCartographicProjectionAttributes(const CartographicProjectionAttributes *attr)
{
    CartographicProjectionAttributesObject *newObject;
    newObject = PyObject_NEW(CartographicProjectionAttributesObject, &CartographicProjectionAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (CartographicProjectionAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
CartographicProjectionAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewCartographicProjectionAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef CartographicProjectionAttributesMethods[] = {
    {"CartographicProjectionAttributes", CartographicProjectionAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *CartographicProjectionAttributesObserver = 0;

std::string
PyCartographicProjectionAttributes_GetLogString()
{
    std::string s("CartographicProjectionAtts = CartographicProjectionAttributes()\n");
    if(currentAtts != 0)
        s += PyCartographicProjectionAttributes_ToString(currentAtts, "CartographicProjectionAtts.");
    return s;
}

static void
PyCartographicProjectionAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("CartographicProjectionAtts = CartographicProjectionAttributes()\n");
        s += PyCartographicProjectionAttributes_ToString(currentAtts, "CartographicProjectionAtts.");
        cb(s);
    }
}

void
PyCartographicProjectionAttributes_StartUp(CartographicProjectionAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyCartographicProjectionAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(CartographicProjectionAttributesObserver == 0)
    {
        CartographicProjectionAttributesObserver = new ObserverToCallback(subj,
            PyCartographicProjectionAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyCartographicProjectionAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete CartographicProjectionAttributesObserver;
    CartographicProjectionAttributesObserver = 0;
}

PyMethodDef *
PyCartographicProjectionAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return CartographicProjectionAttributesMethods;
}

bool
PyCartographicProjectionAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &CartographicProjectionAttributesType);
}

CartographicProjectionAttributes *
PyCartographicProjectionAttributes_FromPyObject(PyObject *obj)
{
    CartographicProjectionAttributesObject *obj2 = (CartographicProjectionAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyCartographicProjectionAttributes_New()
{
    return NewCartographicProjectionAttributes(0);
}

PyObject *
PyCartographicProjectionAttributes_Wrap(const CartographicProjectionAttributes *attr)
{
    return WrapCartographicProjectionAttributes(attr);
}

void
PyCartographicProjectionAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    CartographicProjectionAttributesObject *obj2 = (CartographicProjectionAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyCartographicProjectionAttributes_SetDefaults(const CartographicProjectionAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new CartographicProjectionAttributes(*atts);
}

