/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <CartographicProjectionAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for CartographicProjectionAttributes::ProjectionID
//

static const char *ProjectionID_strings[] = {
"aitoff", "eck4", "eqdc", 
"hammer", "laea", "lcc", 
"merc", "mill", "moll", 
"ortho", "wink2"};

std::string
CartographicProjectionAttributes::ProjectionID_ToString(CartographicProjectionAttributes::ProjectionID t)
{
    int index = int(t);
    if(index < 0 || index >= 11) index = 0;
    return ProjectionID_strings[index];
}

std::string
CartographicProjectionAttributes::ProjectionID_ToString(int t)
{
    int index = (t < 0 || t >= 11) ? 0 : t;
    return ProjectionID_strings[index];
}

bool
CartographicProjectionAttributes::ProjectionID_FromString(const std::string &s, CartographicProjectionAttributes::ProjectionID &val)
{
    val = CartographicProjectionAttributes::aitoff;
    for(int i = 0; i < 11; ++i)
    {
        if(s == ProjectionID_strings[i])
        {
            val = (ProjectionID)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::CartographicProjectionAttributes
//
// Purpose: 
//   Init utility for the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void CartographicProjectionAttributes::Init()
{
    projectionID = aitoff;
    centralMeridian = 0;

    CartographicProjectionAttributes::SelectAll();
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::CartographicProjectionAttributes
//
// Purpose: 
//   Copy utility for the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void CartographicProjectionAttributes::Copy(const CartographicProjectionAttributes &obj)
{
    projectionID = obj.projectionID;
    centralMeridian = obj.centralMeridian;

    CartographicProjectionAttributes::SelectAll();
}

// Type map format string
const char *CartographicProjectionAttributes::TypeMapFormatString = CARTOGRAPHICPROJECTIONATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t CartographicProjectionAttributes::TmfsStruct = {CARTOGRAPHICPROJECTIONATTRIBUTES_TMFS};


// ****************************************************************************
// Method: CartographicProjectionAttributes::CartographicProjectionAttributes
//
// Purpose: 
//   Default constructor for the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CartographicProjectionAttributes::CartographicProjectionAttributes() : 
    AttributeSubject(CartographicProjectionAttributes::TypeMapFormatString)
{
    CartographicProjectionAttributes::Init();
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::CartographicProjectionAttributes
//
// Purpose: 
//   Constructor for the derived classes of CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CartographicProjectionAttributes::CartographicProjectionAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    CartographicProjectionAttributes::Init();
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::CartographicProjectionAttributes
//
// Purpose: 
//   Copy constructor for the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CartographicProjectionAttributes::CartographicProjectionAttributes(const CartographicProjectionAttributes &obj) : 
    AttributeSubject(CartographicProjectionAttributes::TypeMapFormatString)
{
    CartographicProjectionAttributes::Copy(obj);
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::CartographicProjectionAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CartographicProjectionAttributes::CartographicProjectionAttributes(const CartographicProjectionAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    CartographicProjectionAttributes::Copy(obj);
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::~CartographicProjectionAttributes
//
// Purpose: 
//   Destructor for the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CartographicProjectionAttributes::~CartographicProjectionAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CartographicProjectionAttributes& 
CartographicProjectionAttributes::operator = (const CartographicProjectionAttributes &obj)
{
    if (this == &obj) return *this;

    CartographicProjectionAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CartographicProjectionAttributes::operator == (const CartographicProjectionAttributes &obj) const
{
    // Create the return value
    return ((projectionID == obj.projectionID) &&
            (centralMeridian == obj.centralMeridian));
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CartographicProjectionAttributes::operator != (const CartographicProjectionAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::TypeName
//
// Purpose: 
//   Type name method for the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
CartographicProjectionAttributes::TypeName() const
{
    return "CartographicProjectionAttributes";
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CartographicProjectionAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const CartographicProjectionAttributes *tmp = (const CartographicProjectionAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
CartographicProjectionAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new CartographicProjectionAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the CartographicProjectionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
CartographicProjectionAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new CartographicProjectionAttributes(*this);
    else
        retval = new CartographicProjectionAttributes;

    return retval;
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
CartographicProjectionAttributes::SelectAll()
{
    Select(ID_projectionID,    (void *)&projectionID);
    Select(ID_centralMeridian, (void *)&centralMeridian);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CartographicProjectionAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CartographicProjectionAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    CartographicProjectionAttributes defaultObject;
    bool addToParent = false;
    // Create a node for CartographicProjectionAttributes.
    DataNode *node = new DataNode("CartographicProjectionAttributes");

    if(completeSave || !FieldsEqual(ID_projectionID, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("projectionID", ProjectionID_ToString(projectionID)));
    }

    if(completeSave || !FieldsEqual(ID_centralMeridian, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("centralMeridian", centralMeridian));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
CartographicProjectionAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("CartographicProjectionAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("projectionID")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 11)
                SetProjectionID(ProjectionID(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ProjectionID value;
            if(ProjectionID_FromString(node->AsString(), value))
                SetProjectionID(value);
        }
    }
    if((node = searchNode->GetNode("centralMeridian")) != 0)
        SetCentralMeridian(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
CartographicProjectionAttributes::SetProjectionID(CartographicProjectionAttributes::ProjectionID projectionID_)
{
    projectionID = projectionID_;
    Select(ID_projectionID, (void *)&projectionID);
}

void
CartographicProjectionAttributes::SetCentralMeridian(double centralMeridian_)
{
    centralMeridian = centralMeridian_;
    Select(ID_centralMeridian, (void *)&centralMeridian);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

CartographicProjectionAttributes::ProjectionID
CartographicProjectionAttributes::GetProjectionID() const
{
    return ProjectionID(projectionID);
}

double
CartographicProjectionAttributes::GetCentralMeridian() const
{
    return centralMeridian;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CartographicProjectionAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
CartographicProjectionAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_projectionID:    return "projectionID";
    case ID_centralMeridian: return "centralMeridian";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
CartographicProjectionAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_projectionID:    return FieldType_enum;
    case ID_centralMeridian: return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
CartographicProjectionAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_projectionID:    return "enum";
    case ID_centralMeridian: return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CartographicProjectionAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CartographicProjectionAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const CartographicProjectionAttributes &obj = *((const CartographicProjectionAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_projectionID:
        {  // new scope
        retval = (projectionID == obj.projectionID);
        }
        break;
    case ID_centralMeridian:
        {  // new scope
        retval = (centralMeridian == obj.centralMeridian);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

