/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ProgrammableOpAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ProgrammableOpAttributes::ProgrammableOpAttributes
//
// Purpose: 
//   Init utility for the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ProgrammableOpAttributes::Init()
{

    ProgrammableOpAttributes::SelectAll();
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::ProgrammableOpAttributes
//
// Purpose: 
//   Copy utility for the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ProgrammableOpAttributes::Copy(const ProgrammableOpAttributes &obj)
{
    scriptMap = obj.scriptMap;

    ProgrammableOpAttributes::SelectAll();
}

// Type map format string
const char *ProgrammableOpAttributes::TypeMapFormatString = PROGRAMMABLEOPATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ProgrammableOpAttributes::TmfsStruct = {PROGRAMMABLEOPATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ProgrammableOpAttributes::ProgrammableOpAttributes
//
// Purpose: 
//   Default constructor for the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProgrammableOpAttributes::ProgrammableOpAttributes() : 
    AttributeSubject(ProgrammableOpAttributes::TypeMapFormatString)
{
    ProgrammableOpAttributes::Init();
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::ProgrammableOpAttributes
//
// Purpose: 
//   Constructor for the derived classes of ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProgrammableOpAttributes::ProgrammableOpAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ProgrammableOpAttributes::Init();
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::ProgrammableOpAttributes
//
// Purpose: 
//   Copy constructor for the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProgrammableOpAttributes::ProgrammableOpAttributes(const ProgrammableOpAttributes &obj) : 
    AttributeSubject(ProgrammableOpAttributes::TypeMapFormatString)
{
    ProgrammableOpAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::ProgrammableOpAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProgrammableOpAttributes::ProgrammableOpAttributes(const ProgrammableOpAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ProgrammableOpAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::~ProgrammableOpAttributes
//
// Purpose: 
//   Destructor for the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProgrammableOpAttributes::~ProgrammableOpAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProgrammableOpAttributes& 
ProgrammableOpAttributes::operator = (const ProgrammableOpAttributes &obj)
{
    if (this == &obj) return *this;

    ProgrammableOpAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProgrammableOpAttributes::operator == (const ProgrammableOpAttributes &obj) const
{
    // Create the return value
    return ((scriptMap == obj.scriptMap));
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProgrammableOpAttributes::operator != (const ProgrammableOpAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::TypeName
//
// Purpose: 
//   Type name method for the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ProgrammableOpAttributes::TypeName() const
{
    return "ProgrammableOpAttributes";
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProgrammableOpAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ProgrammableOpAttributes *tmp = (const ProgrammableOpAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ProgrammableOpAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ProgrammableOpAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ProgrammableOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ProgrammableOpAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ProgrammableOpAttributes(*this);
    else
        retval = new ProgrammableOpAttributes;

    return retval;
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ProgrammableOpAttributes::SelectAll()
{
    Select(ID_scriptMap, (void *)&scriptMap);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ProgrammableOpAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProgrammableOpAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ProgrammableOpAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ProgrammableOpAttributes.
    DataNode *node = new DataNode("ProgrammableOpAttributes");

    if(completeSave || !FieldsEqual(ID_scriptMap, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scriptMap", scriptMap));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ProgrammableOpAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ProgrammableOpAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("scriptMap")) != 0)
        SetScriptMap(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ProgrammableOpAttributes::SetScriptMap(const std::string &scriptMap_)
{
    scriptMap = scriptMap_;
    Select(ID_scriptMap, (void *)&scriptMap);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
ProgrammableOpAttributes::GetScriptMap() const
{
    return scriptMap;
}

std::string &
ProgrammableOpAttributes::GetScriptMap()
{
    return scriptMap;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ProgrammableOpAttributes::SelectScriptMap()
{
    Select(ID_scriptMap, (void *)&scriptMap);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ProgrammableOpAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ProgrammableOpAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_scriptMap: return "scriptMap";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ProgrammableOpAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_scriptMap: return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ProgrammableOpAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_scriptMap: return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ProgrammableOpAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProgrammableOpAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ProgrammableOpAttributes &obj = *((const ProgrammableOpAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_scriptMap:
        {  // new scope
        retval = (scriptMap == obj.scriptMap);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

void
ProgrammableOpAttributes::AddConstant(const std::string& name, const std::string& constant)
{
    JSONNode node;
    
    JSONNode vars = JSONNode::JSONArray();
    node["vars"] = vars;

    char buf[1024];
    sprintf(buf,"setout(%s)",constant.c_str());
    node["source"] = buf;

    /// register constant also as a node..
    JSONNode cnode;
    cnode["type"] = name;

    script["nodes"][name] = cnode;
    script["scripts"][name] = node;

    //update scriptmap
    scriptMap = script.ToString();
    Select(ID_scriptMap, (void *)&scriptMap);
}

void
ProgrammableOpAttributes::AddFunction(const std::string& name, const stringVector& atts)
{
    JSONNode vars = JSONNode::JSONArray();
    for(int i = 0; i < atts.size(); ++i)
        vars.Append(atts[i]);

    JSONNode node;
    node["vars"] = vars;

    std::string argstring = "";
    for(size_t i = 0; i < atts.size(); ++i)
        argstring += atts[i] + (i == atts.size()-1 ? "" : ",");

   // char buf[1024];
   // sprintf(buf,"import visit_internal_funcs\nsetout(visit_internal_funcs.%s(%s))",name.c_str(),argstring.c_str());

    std::ostringstream ostr;

    ostr << "import visit_internal_funcs\n"
         << "setout(visit_internal_funcs." << name << "(" << argstring << "))" << std::endl;

    std::string escapedCode = ostr.str();
    //std::cout << escapedCode << std::endl;
    replace(escapedCode, "\n", "\\n");

    node["source"] = escapedCode;

    script["scripts"][name] = node;

    //update scriptmap
    scriptMap = script.ToString();
    Select(ID_scriptMap, (void *)&scriptMap);
}

void
ProgrammableOpAttributes::AddRScript(const std::string& name, const stringVector& atts, const std::string& code)
{
    JSONNode vars = JSONNode::JSONArray();
    for(int i = 0; i < atts.size(); ++i)
        vars.Append(atts[i]);

    JSONNode node;
    node["vars"] = vars;

    std::string argstring = "";
    for(size_t i = 0; i < atts.size(); ++i)
        argstring += atts[i] + (i == atts.size()-1 ? "" : ",");

    std::ostringstream rwrapper;

    rwrapper << "import rpy2,numpy\n"
             << "import rpy2.robjects as robjects\n"
             << "import rpy2.robjects.numpy2ri\n"
             << "rpy2.robjects.numpy2ri.activate()\n"
             << "_r_output = None\n"
             << "def _r_setout(out):\n"
             << "  global _r_output\n"
             << "  _r_output = out\n"
             << "r_setout = rpy2.rinterface.rternalize(_r_setout)\n"
             << "rpy2.robjects.globalenv['setout'] = r_setout\n"
             << "r_f = robjects.r('''\n"
             << "(function(" + argstring + ") { \n"
             << code
             << "})\n"
             << "''')\n"
             << "r=r_f("+ argstring + ")\n"
             << "setout(numpy.asarray(_r_output))\n";

    std::string escapedCode = rwrapper.str();
    replace(escapedCode, "\n", "\\n");

    node["source"] = escapedCode;

    script["scripts"][name] = node;

    //update scriptmap
    scriptMap = script.ToString();
    Select(ID_scriptMap, (void *)&scriptMap);
}

void 
ProgrammableOpAttributes::AddPythonScript(const std::string& name, const stringVector& atts, const std::string& code)
{
    JSONNode vars = JSONNode::JSONArray();
    for(int i = 0; i < atts.size(); ++i)
        vars.Append(atts[i]);

    JSONNode node;
    node["vars"] = vars;

    std::ostringstream pwrapper;

    pwrapper << "from visit_internal_funcs import *\n"
             << code
             << "\n";
    std::string escapedCode = pwrapper.str();
    replace(escapedCode, "\n", "\\n");

    node["source"] = escapedCode;

    script["scripts"][name] = node;

    //update scriptmap
    scriptMap = script.ToString();
    Select(ID_scriptMap, (void *)&scriptMap);
}

void
ProgrammableOpAttributes::AddNode(const std::string& name, const std::string& type)
{
    JSONNode node;
    node["type"] = type;
    script["nodes"][name] = node;

    scriptMap = script.ToString();
    Select(ID_scriptMap, (void *)&scriptMap);
}

void
ProgrammableOpAttributes::AddConnection(const std::string& from, const std::string& to, const std::string& portName)
{
    JSONNode conn;
    conn["from"] = from;
    conn["to"] = to;
    conn["port"] = portName;

    if(!script.HasKey("connections"))
        script["connections"] = JSONNode::JSONArray();

    script["connections"].Append(conn);

    scriptMap = script.ToString();
    Select(ID_scriptMap, (void *)&scriptMap);
}

void
ProgrammableOpAttributes::AddFinalOutputConnection(const std::string &from)
{
    JSONNode node;
    node["type"] = "<sink>";
    script["nodes"]["sink"] = node;

    JSONNode conn;
    conn["from"] = from;
    conn["to"] = "sink";
    conn["port"] = "in";

    if(!script.HasKey("connections"))
        script["connections"] = JSONNode::JSONArray();

    script["connections"].Append(conn);

    scriptMap = script.ToString();
    Select(ID_scriptMap, (void *)&scriptMap);
}

bool
ProgrammableOpAttributes::SetupPipeline(const JSONNode& atts, stringVector& args, const std::string& parent)
{
    if(atts.GetType() != JSONNode::JSONARRAY)
        return false;

    const JSONNode::JSONArray& array = atts.GetArray();

    for(int i = 0; i < array.size(); ++i)
    {
        /// need key, value pair
        /// this can be in the form of a dictionary, "a = b", pair tuple (a,b), or a pair array [a,b]
        JSONNode node = array[i];
        JSONNode key,value;
        if(node.GetType() == JSONNode::JSONARRAY)
        {
            if(node.GetArray().size() != 2) continue;

            key = node.GetArray()[0];
            value = node.GetArray()[1];
        }
        else if(node.GetType() == JSONNode::JSONOBJECT)
        {
            /// parse through dictionary and compute arguments from names..
            const JSONNode::JSONObject& obj = node.GetJsonObject();
            if(obj.size() != 1) continue;

            const JSONNode::JSONObject::const_iterator itr = obj.begin();
            key = itr->first;
            value = itr->second;
        }
        else if(node.GetType() == JSONNode::JSONSTRING)
        {
            std::string pair = node.GetString();
            int index = pair.find("=");
            if(index == std::string::npos) continue;
            key = pair.substr(0,index);

            value = trim(pair.substr(index+1));
         }

        if(key.GetType() != JSONNode::JSONSTRING) continue;

        std::string keystr = trim(key.GetString());

        std::ostringstream str;
        str << "import json\n";
        if(value.GetType() == JSONNode::JSONSTRING)
        {
            std::string v = trim(value.GetString());

            ///character at 0 and has :
            if(v.find(":") != std::string::npos && v.find(":") == 0)
            {
                /// optionally handle whether it can be as_vtkarray, as_ndarray, or as_rarray

                size_t index = v.find(":as_ndarray");

                if(index == std::string::npos)
                    index = v.find(":as_rarray");

                if(index != std::string::npos)
                {
                    std::string newName = getNextName();
                    v = v.substr(0,index);
                    AddNode(newName, "as_ndarray");
                    AddConnection(v, newName, "in");
                    AddConnection(newName,parent,keystr);
                }
                else
                {
                    index = v.find(":as_vtkarray");
                    if(index != std::string::npos)
                        v = v.substr(0,index);
                    AddConnection(v,parent,keystr);
                }
            }
            else
            {
                std::string escapedCode = trim(value.GetString());
                replace(escapedCode,"\n","\\\n");
                replace(escapedCode,"'","\"");
                escapedCode = "'" + escapedCode + "'";

                str << "try:\n"
                    << " a = json.loads(" << escapedCode << ")\n"
                    << "except:\n"
                    << " a = " << escapedCode << "\n"
                    << "setout(a)\n";

                AddPythonScript(keystr,stringVector(),str.str());
                AddNode(keystr,keystr);
                AddConnection(keystr,parent,keystr);
            }
        }
        else
        {
            str << "setout(json.loads('" << trim(value.ToString()) << "'))\n";

            AddPythonScript(keystr,stringVector(),str.str());
            AddNode(keystr,keystr);
            AddConnection(keystr,parent,keystr);
        }
        args.push_back(keystr);
    }
    return true;
}

void
ProgrammableOpAttributes::LoadRKernel(const std::string& name, const JSONNode &atts, const std::string& code)
{
    script = JSONNode();
    scriptMap = "";

    stringVector args;
    SetupPipeline(atts,args,name);

    JSONNode vars = JSONNode::JSONArray();
    for(int i = 0; i < args.size(); ++i)
        vars.Append(args[i]);

    JSONNode node;
    node["vars"] = vars;

    std::string argstring = "";
    for(size_t i = 0; i < args.size(); ++i)
        argstring += args[i] + (i == args.size()-1 ? "" : ",");

    std::ostringstream rwrapper;

    rwrapper << "import rpy2,numpy\n"
             << "import rpy2.robjects as robjects\n"
             << "import rpy2.robjects.numpy2ri\n"
             << "rpy2.robjects.numpy2ri.activate()\n"
             << name << " = robjects.r('''\n"
             << code << "\n"
             << "''')\n"
             << "setout(numpy.asarray(" << name << "(" << argstring << ")))\n";

    std::string escapedCode = rwrapper.str();
    //std::cout << escapedCode << std::endl;
    replace(escapedCode, "\n", "\\n");

    node["source"] = escapedCode;

    script["scripts"][name] = node;

    //update scriptmap
    scriptMap = script.ToString();

    AddNode(name,name);
    AddFinalOutputConnection(name);

}

void
ProgrammableOpAttributes::LoadPythonKernel(const std::string& name, const JSONNode& atts, const std::string& code)
{
    script = JSONNode();
    scriptMap = "";

    stringVector args;
    SetupPipeline(atts,args,name);

    std::string arglist = "";

    JSONNode vars = JSONNode::JSONArray();

    for(int i = 0; i < args.size(); ++i)
    {
        vars.Append(args[i]);
        arglist += args[i] + (i == args.size()-1 ? "" : ",");
    }

    JSONNode node;
    node["vars"] = vars;

    std::ostringstream pwrapper;

    pwrapper << "from visit_internal_funcs import *\n"
             //<< "exec('''" << "\n"
             //<< code << "''',globals())\n"
             << code << "\n"
             << "setout(" << name << "(" << arglist << "))\n";

    std::string escapedCode = pwrapper.str();
    //std::cout << escapedCode << std::endl;
    //replace(escapedCode, "'", "\"");
    //replace(escapedCode, "\"", "\\\"");
    //replace(escapedCode, "\n", "\\n");

    node["source"] = escapedCode;

    script["scripts"][name] = node;
    scriptMap = script.ToString();

    AddNode(name,name);
    AddFinalOutputConnection(name);
}

std::string 
ProgrammableOpAttributes::trim(const std::string &s) 
{
        return ltrim(rtrim(s));
}

std::string 
ProgrammableOpAttributes::rtrim(const std::string &ts) 
{
        std::string s = ts;
        s.erase(std::find_if(s.rbegin(), s.rend(), std::not1(std::ptr_fun<int, int>(std::isspace))).base(), s.end());
        return s;
}

std::string 
ProgrammableOpAttributes::ltrim(const std::string &ts) 
{
        std::string s = ts;
        s.erase(s.begin(), std::find_if(s.begin(), s.end(), std::not1(std::ptr_fun<int, int>(std::isspace))));
        return s;
}

std::string 
ProgrammableOpAttributes::getNextName()
{
    static int index = 0;
    char buf[1024];
    sprintf(buf,"auto_name_%d",index);
    index += 1;
    return buf;
}

void 
ProgrammableOpAttributes::replace(std::string& str, const std::string& oldStr, const std::string& newStr)
{
  size_t pos = 0;
  while((pos = str.find(oldStr, pos)) != std::string::npos)
  {
     str.replace(pos, oldStr.length(), newStr);
     pos += newStr.length();
  }
}

