/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtModelFitFilter.h
// ************************************************************************* //

#ifndef AVT_MODELFIT_FILTER_H
#define AVT_MODELFIT_FILTER_H

#define BINS 100

#include <avtPluginDataTreeIterator.h>

#include <ModelFitAtts.h>

#include <vtkPointData.h>
#include <vtkCellData.h>

class vtkDataSet;

typedef struct histogram{
    double *range_ends;
    int count;
    int mod_number;
} histogram;

typedef struct variableStats{
    int    num_points;
    char   *name;
    double sum;
    double average;
    double max;
    double min;
    double non_zero_min;
    double variance;
    double scaled_variance;
    bool   calculate_stats;
    bool   calculate_hists;
    histogram hist;
} variableStats;


// ****************************************************************************
//  Class: avtModelFitFilter
//
//  Purpose:
//      A plugin operator for ModelFit.
//
//  Programmer: rob -- generated by xml2avt
//  Creation:   Wed Feb 3 16:15:29 PST 2010
//
//  Modifications:
//    Eric Brugger, Wed Jul 30 19:34:09 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtModelFitFilter : public avtPluginDataTreeIterator
{
  public:
                         avtModelFitFilter();
    virtual             ~avtModelFitFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtModelFitFilter"; };
    virtual const char  *GetDescription(void)
                             { return "ModelFit"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    ModelFitAtts   atts;

    virtual      avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual      avtContract_p ModifyContract(avtContract_p);
    virtual      void          UpdateDataObjectInfo();
    virtual      void          PostExecute();

    void   calculateVariableStats();
    void   createVS(char *);
    void   grabOnePoint       (doubleVector *, int, 
        int, int, int, vtkPointData *, vtkCellData *);
    void   findMatches        (doubleVector *, intVector *, 
        doubleVector, int, int, int, int);
    double calculateDistance  (doubleVector, int);
    double spaceConvert (double, size_t, int);
    double convertToVariableSpace(double, size_t, int);

    avtCentering             Centering;
    std::vector<vtkDataSet        *>out_ds;
    std::vector<variableStats     *>VS;
    //vector<relationshipStats *>RS;
    int        activeTs;
    int        num_relats;
    int        numTimesteps;
    int        entire_data;
    char       *new_pipelineVar;
    const char *pipelineVar;

    int        max_blk_num;
    int        max_blk_size;
    int        total_blk_num;
};


#endif
