// ***************************************************************************
//
// Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
// Produced at the Lawrence Livermore National Laboratory
// LLNL-CODE-442911
// All rights reserved.
//
// This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
// full copyright notice is contained in the file COPYRIGHT located at the root
// of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
//
// Redistribution  and  use  in  source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of  source code must  retain the above  copyright notice,
//    this list of conditions and the disclaimer below.
//  - Redistributions in binary form must reproduce the above copyright notice,
//    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
//    documentation and/or other materials provided with the distribution.
//  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
//    be used to endorse or promote products derived from this software without
//    specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
// ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
// LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
// DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
// SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
// CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
// LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
// OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ***************************************************************************

package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorControlPointList;
import java.lang.Byte;
import java.util.Vector;
import llnl.visit.ColorAttribute;
import llnl.visit.ColorAttributeList;

// ****************************************************************************
// Class: MultiCurveAttributes
//
// Purpose:
//    This class contains the plot attributes for the MultiCurve plot.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

public class MultiCurveAttributes extends AttributeSubject implements Plugin
{
    private static int MultiCurveAttributes_numAdditionalAtts = 17;

    // Enum values
    public final static int COLORINGMETHOD_COLORBYSINGLECOLOR = 0;
    public final static int COLORINGMETHOD_COLORBYMULTIPLECOLORS = 1;


    public MultiCurveAttributes()
    {
        super(MultiCurveAttributes_numAdditionalAtts);

        defaultPalette = new ColorControlPointList();
        changedColors = new Vector();
        colorType = COLORINGMETHOD_COLORBYMULTIPLECOLORS;
        singleColor = new ColorAttribute(255, 0, 0);
        multiColor = new ColorAttributeList();
        lineStyle = 0;
        lineWidth = 0;
        yAxisTitleFormat = new String("%g");
        useYAxisTickSpacing = false;
        yAxisTickSpacing = 1;
        displayMarkers = true;
        markerScale = 1;
        markerLineWidth = 0;
        markerVariable = new String("default");
        displayIds = false;
        idVariable = new String("default");
        legendFlag = true;
    }

    public MultiCurveAttributes(int nMoreFields)
    {
        super(MultiCurveAttributes_numAdditionalAtts + nMoreFields);

        defaultPalette = new ColorControlPointList();
        changedColors = new Vector();
        colorType = COLORINGMETHOD_COLORBYMULTIPLECOLORS;
        singleColor = new ColorAttribute(255, 0, 0);
        multiColor = new ColorAttributeList();
        lineStyle = 0;
        lineWidth = 0;
        yAxisTitleFormat = new String("%g");
        useYAxisTickSpacing = false;
        yAxisTickSpacing = 1;
        displayMarkers = true;
        markerScale = 1;
        markerLineWidth = 0;
        markerVariable = new String("default");
        displayIds = false;
        idVariable = new String("default");
        legendFlag = true;
    }

    public MultiCurveAttributes(MultiCurveAttributes obj)
    {
        super(obj);

        int i;

        defaultPalette = new ColorControlPointList(obj.defaultPalette);
        changedColors = new Vector(obj.changedColors.size());
        for(i = 0; i < obj.changedColors.size(); ++i)
        {
            Byte bv = (Byte)obj.changedColors.elementAt(i);
            changedColors.addElement(new Byte(bv.byteValue()));
        }

        colorType = obj.colorType;
        singleColor = new ColorAttribute(obj.singleColor);
        multiColor = new ColorAttributeList(obj.multiColor);
        lineStyle = obj.lineStyle;
        lineWidth = obj.lineWidth;
        yAxisTitleFormat = new String(obj.yAxisTitleFormat);
        useYAxisTickSpacing = obj.useYAxisTickSpacing;
        yAxisTickSpacing = obj.yAxisTickSpacing;
        displayMarkers = obj.displayMarkers;
        markerScale = obj.markerScale;
        markerLineWidth = obj.markerLineWidth;
        markerVariable = new String(obj.markerVariable);
        displayIds = obj.displayIds;
        idVariable = new String(obj.idVariable);
        legendFlag = obj.legendFlag;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return MultiCurveAttributes_numAdditionalAtts;
    }

    public boolean equals(MultiCurveAttributes obj)
    {
        int i;

        // Create the return value
        return (true /* can ignore defaultPalette */ &&
                true /* can ignore changedColors */ &&
                (colorType == obj.colorType) &&
                (singleColor == obj.singleColor) &&
                (multiColor.equals(obj.multiColor)) &&
                (lineStyle == obj.lineStyle) &&
                (lineWidth == obj.lineWidth) &&
                (yAxisTitleFormat.equals(obj.yAxisTitleFormat)) &&
                (useYAxisTickSpacing == obj.useYAxisTickSpacing) &&
                (yAxisTickSpacing == obj.yAxisTickSpacing) &&
                (displayMarkers == obj.displayMarkers) &&
                (markerScale == obj.markerScale) &&
                (markerLineWidth == obj.markerLineWidth) &&
                (markerVariable.equals(obj.markerVariable)) &&
                (displayIds == obj.displayIds) &&
                (idVariable.equals(obj.idVariable)) &&
                (legendFlag == obj.legendFlag));
    }

    public String GetName() { return "MultiCurve"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetDefaultPalette(ColorControlPointList defaultPalette_)
    {
        defaultPalette = defaultPalette_;
        Select(0);
    }

    public void SetChangedColors(Vector changedColors_)
    {
        changedColors = changedColors_;
        Select(1);
    }

    public void SetColorType(int colorType_)
    {
        colorType = colorType_;
        Select(2);
    }

    public void SetSingleColor(ColorAttribute singleColor_)
    {
        singleColor = singleColor_;
        Select(3);
    }

    public void SetMultiColor(ColorAttributeList multiColor_)
    {
        multiColor = multiColor_;
        Select(4);
    }

    public void SetLineStyle(int lineStyle_)
    {
        lineStyle = lineStyle_;
        Select(5);
    }

    public void SetLineWidth(int lineWidth_)
    {
        lineWidth = lineWidth_;
        Select(6);
    }

    public void SetYAxisTitleFormat(String yAxisTitleFormat_)
    {
        yAxisTitleFormat = yAxisTitleFormat_;
        Select(7);
    }

    public void SetUseYAxisTickSpacing(boolean useYAxisTickSpacing_)
    {
        useYAxisTickSpacing = useYAxisTickSpacing_;
        Select(8);
    }

    public void SetYAxisTickSpacing(double yAxisTickSpacing_)
    {
        yAxisTickSpacing = yAxisTickSpacing_;
        Select(9);
    }

    public void SetDisplayMarkers(boolean displayMarkers_)
    {
        displayMarkers = displayMarkers_;
        Select(10);
    }

    public void SetMarkerScale(double markerScale_)
    {
        markerScale = markerScale_;
        Select(11);
    }

    public void SetMarkerLineWidth(int markerLineWidth_)
    {
        markerLineWidth = markerLineWidth_;
        Select(12);
    }

    public void SetMarkerVariable(String markerVariable_)
    {
        markerVariable = markerVariable_;
        Select(13);
    }

    public void SetDisplayIds(boolean displayIds_)
    {
        displayIds = displayIds_;
        Select(14);
    }

    public void SetIdVariable(String idVariable_)
    {
        idVariable = idVariable_;
        Select(15);
    }

    public void SetLegendFlag(boolean legendFlag_)
    {
        legendFlag = legendFlag_;
        Select(16);
    }

    // Property getting methods
    public ColorControlPointList GetDefaultPalette() { return defaultPalette; }
    public Vector                GetChangedColors() { return changedColors; }
    public int                   GetColorType() { return colorType; }
    public ColorAttribute        GetSingleColor() { return singleColor; }
    public ColorAttributeList    GetMultiColor() { return multiColor; }
    public int                   GetLineStyle() { return lineStyle; }
    public int                   GetLineWidth() { return lineWidth; }
    public String                GetYAxisTitleFormat() { return yAxisTitleFormat; }
    public boolean               GetUseYAxisTickSpacing() { return useYAxisTickSpacing; }
    public double                GetYAxisTickSpacing() { return yAxisTickSpacing; }
    public boolean               GetDisplayMarkers() { return displayMarkers; }
    public double                GetMarkerScale() { return markerScale; }
    public int                   GetMarkerLineWidth() { return markerLineWidth; }
    public String                GetMarkerVariable() { return markerVariable; }
    public boolean               GetDisplayIds() { return displayIds; }
    public String                GetIdVariable() { return idVariable; }
    public boolean               GetLegendFlag() { return legendFlag; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            defaultPalette.Write(buf);
        if(WriteSelect(1, buf))
            buf.WriteByteVector(changedColors);
        if(WriteSelect(2, buf))
            buf.WriteInt(colorType);
        if(WriteSelect(3, buf))
            singleColor.Write(buf);
        if(WriteSelect(4, buf))
            multiColor.Write(buf);
        if(WriteSelect(5, buf))
            buf.WriteInt(lineStyle);
        if(WriteSelect(6, buf))
            buf.WriteInt(lineWidth);
        if(WriteSelect(7, buf))
            buf.WriteString(yAxisTitleFormat);
        if(WriteSelect(8, buf))
            buf.WriteBool(useYAxisTickSpacing);
        if(WriteSelect(9, buf))
            buf.WriteDouble(yAxisTickSpacing);
        if(WriteSelect(10, buf))
            buf.WriteBool(displayMarkers);
        if(WriteSelect(11, buf))
            buf.WriteDouble(markerScale);
        if(WriteSelect(12, buf))
            buf.WriteInt(markerLineWidth);
        if(WriteSelect(13, buf))
            buf.WriteString(markerVariable);
        if(WriteSelect(14, buf))
            buf.WriteBool(displayIds);
        if(WriteSelect(15, buf))
            buf.WriteString(idVariable);
        if(WriteSelect(16, buf))
            buf.WriteBool(legendFlag);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            defaultPalette.Read(buf);
            Select(0);
            break;
        case 1:
            SetChangedColors(buf.ReadByteVector());
            break;
        case 2:
            SetColorType(buf.ReadInt());
            break;
        case 3:
            singleColor.Read(buf);
            Select(3);
            break;
        case 4:
            multiColor.Read(buf);
            Select(4);
            break;
        case 5:
            SetLineStyle(buf.ReadInt());
            break;
        case 6:
            SetLineWidth(buf.ReadInt());
            break;
        case 7:
            SetYAxisTitleFormat(buf.ReadString());
            break;
        case 8:
            SetUseYAxisTickSpacing(buf.ReadBool());
            break;
        case 9:
            SetYAxisTickSpacing(buf.ReadDouble());
            break;
        case 10:
            SetDisplayMarkers(buf.ReadBool());
            break;
        case 11:
            SetMarkerScale(buf.ReadDouble());
            break;
        case 12:
            SetMarkerLineWidth(buf.ReadInt());
            break;
        case 13:
            SetMarkerVariable(buf.ReadString());
            break;
        case 14:
            SetDisplayIds(buf.ReadBool());
            break;
        case 15:
            SetIdVariable(buf.ReadString());
            break;
        case 16:
            SetLegendFlag(buf.ReadBool());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "defaultPalette = {\n" + defaultPalette.toString(indent + "    ") + indent + "}\n";
        str = str + ucharVectorToString("changedColors", changedColors, indent) + "\n";
        str = str + indent + "colorType = ";
        if(colorType == COLORINGMETHOD_COLORBYSINGLECOLOR)
            str = str + "COLORINGMETHOD_COLORBYSINGLECOLOR";
        if(colorType == COLORINGMETHOD_COLORBYMULTIPLECOLORS)
            str = str + "COLORINGMETHOD_COLORBYMULTIPLECOLORS";
        str = str + "\n";
        str = str + indent + "singleColor = {" + singleColor.Red() + ", " + singleColor.Green() + ", " + singleColor.Blue() + ", " + singleColor.Alpha() + "}\n";
        str = str + indent + "multiColor = {\n" + multiColor.toString(indent + "    ") + indent + "}\n";
        str = str + intToString("lineStyle", lineStyle, indent) + "\n";
        str = str + intToString("lineWidth", lineWidth, indent) + "\n";
        str = str + stringToString("yAxisTitleFormat", yAxisTitleFormat, indent) + "\n";
        str = str + boolToString("useYAxisTickSpacing", useYAxisTickSpacing, indent) + "\n";
        str = str + doubleToString("yAxisTickSpacing", yAxisTickSpacing, indent) + "\n";
        str = str + boolToString("displayMarkers", displayMarkers, indent) + "\n";
        str = str + doubleToString("markerScale", markerScale, indent) + "\n";
        str = str + intToString("markerLineWidth", markerLineWidth, indent) + "\n";
        str = str + stringToString("markerVariable", markerVariable, indent) + "\n";
        str = str + boolToString("displayIds", displayIds, indent) + "\n";
        str = str + stringToString("idVariable", idVariable, indent) + "\n";
        str = str + boolToString("legendFlag", legendFlag, indent) + "\n";
        return str;
    }


    // Attributes
    private ColorControlPointList defaultPalette;
    private Vector                changedColors; // vector of Byte objects
    private int                   colorType;
    private ColorAttribute        singleColor;
    private ColorAttributeList    multiColor;
    private int                   lineStyle;
    private int                   lineWidth;
    private String                yAxisTitleFormat;
    private boolean               useYAxisTickSpacing;
    private double                yAxisTickSpacing;
    private boolean               displayMarkers;
    private double                markerScale;
    private int                   markerLineWidth;
    private String                markerVariable;
    private boolean               displayIds;
    private String                idVariable;
    private boolean               legendFlag;
}

