/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: HistogramViewerEnginePluginInfo.C
// ************************************************************************* //

#include <HistogramPluginInfo.h>
#include <avtHistogramPlot.h>
#include <HistogramAttributes.h>

//
// Storage for static data elements.
//
HistogramAttributes *HistogramViewerEnginePluginInfo::clientAtts = NULL;
HistogramAttributes *HistogramViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  HistogramViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
HistogramViewerEnginePluginInfo::InitializeGlobalObjects()
{
    HistogramViewerEnginePluginInfo::clientAtts  = new HistogramAttributes;
    HistogramViewerEnginePluginInfo::defaultAtts = new HistogramAttributes;
}

// ****************************************************************************
//  Method: HistogramViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
HistogramViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: HistogramViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
HistogramViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: HistogramViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
HistogramViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(HistogramAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: HistogramViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
HistogramViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(HistogramAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: HistogramViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
HistogramViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtHistogramPlot;
}

bool
HistogramViewerEnginePluginInfo::ProvidesLegend() const
{
    return false;
}

// ****************************************************************************
//  Method: HistogramViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed May 24 09:22:33 PDT 2006
//
//  Modifications:
//    Hank Childs, Wed May 24 08:45:06 PDT 2006
//    Populated with custom code.
//
//    Brad Whitlock, Wed Feb 21 14:26:13 PST 2007
//    Changed API.
//
// ****************************************************************************
#include <avtPlotMetaData.h>
#include <avtDatabaseMetaData.h>

void
HistogramViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &plot)
{
    *(HistogramAttributes*)atts = *defaultAtts;
    HistogramAttributes *hatts = (HistogramAttributes *) atts;

    //
    // Get the meta-data and initialize the variable type in the atts.
    //
    const avtDatabaseMetaData *md = plot.GetMetaData();
    if (md == NULL)
    {
        hatts->SetBasedOn(HistogramAttributes::ManyZonesForSingleVar);
        return;
    }

    avtVarType t = md->DetermineVarType(plot.GetVariableName());
    if (t == AVT_SCALAR_VAR)
        hatts->SetBasedOn(HistogramAttributes::ManyZonesForSingleVar);
    else if (t == AVT_ARRAY_VAR)
        hatts->SetBasedOn(HistogramAttributes::ManyVarsForSingleZone);
    else
        hatts->SetBasedOn(HistogramAttributes::ManyZonesForSingleVar);
}

// ****************************************************************************
//  Method: HistogramViewerEnginePluginInfo::ReInitializePlotAtts
//
//  Purpose:
//    ReInitialize the plot attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: Hank Childs
//  Creation:   May 24, 2006
//
//  Modifications:
//    Brad Whitlock, Wed Feb 21 14:25:26 PST 2007
//    Changed API.
//
// ****************************************************************************

void
HistogramViewerEnginePluginInfo::ReInitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &plot)
{
    HistogramAttributes *hatts = (HistogramAttributes *) atts;

    //
    // Get the meta-data and initialize the variable type in the atts.
    //
    const avtDatabaseMetaData *md = plot.GetMetaData();
    if (md == NULL)
    {
        hatts->SetBasedOn(HistogramAttributes::ManyZonesForSingleVar);
        return;
    }

    avtVarType t = md->DetermineVarType(plot.GetVariableName());
    if (t == AVT_SCALAR_VAR)
        hatts->SetBasedOn(HistogramAttributes::ManyZonesForSingleVar);
    else if (t == AVT_ARRAY_VAR)
        hatts->SetBasedOn(HistogramAttributes::ManyVarsForSingleZone);
    else
        hatts->SetBasedOn(HistogramAttributes::ManyZonesForSingleVar);
}

// ****************************************************************************
//  Method: HistogramViewerEnginePluginInfo::ResetPlotAtts
//
//  Purpose:
//    Reset the plot attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: Hank Childs
//  Creation:   May 24, 2006
//
//  Modifications:
//    Brad Whitlock, Wed Feb 21 14:26:31 PST 2007
//    Changed API.
//
// ****************************************************************************
void
HistogramViewerEnginePluginInfo::ResetPlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &plot)
{
    ReInitializePlotAtts(atts, plot);
}

// ****************************************************************************
//  Method: HistogramViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
HistogramViewerEnginePluginInfo::GetMenuName() const
{
    return "Histogram";
}

