/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyResampleAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyResampleAttributes
//
// Purpose: 
//   Atts for Resample operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ResampleAttributes.
//
struct ResampleAttributesObject
{
    PyObject_HEAD
    ResampleAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewResampleAttributes(int);

std::string
PyResampleAttributes_ToString(const ResampleAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetUseExtents())
        SNPRINTF(tmpStr, 1000, "%suseExtents = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseExtents = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstartX = %g\n", prefix, atts->GetStartX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendX = %g\n", prefix, atts->GetEndX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssamplesX = %d\n", prefix, atts->GetSamplesX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstartY = %g\n", prefix, atts->GetStartY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendY = %g\n", prefix, atts->GetEndY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssamplesY = %d\n", prefix, atts->GetSamplesY());
    str += tmpStr;
    if(atts->GetIs3D())
        SNPRINTF(tmpStr, 1000, "%sis3D = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sis3D = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstartZ = %g\n", prefix, atts->GetStartZ());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendZ = %g\n", prefix, atts->GetEndZ());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssamplesZ = %d\n", prefix, atts->GetSamplesZ());
    str += tmpStr;
    const char *tieResolver_names = "random, largest, smallest";
    switch (atts->GetTieResolver())
    {
      case ResampleAttributes::random:
          SNPRINTF(tmpStr, 1000, "%stieResolver = %srandom  # %s\n", prefix, prefix, tieResolver_names);
          str += tmpStr;
          break;
      case ResampleAttributes::largest:
          SNPRINTF(tmpStr, 1000, "%stieResolver = %slargest  # %s\n", prefix, prefix, tieResolver_names);
          str += tmpStr;
          break;
      case ResampleAttributes::smallest:
          SNPRINTF(tmpStr, 1000, "%stieResolver = %ssmallest  # %s\n", prefix, prefix, tieResolver_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%stieResolverVariable = \"%s\"\n", prefix, atts->GetTieResolverVariable().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdefaultValue = %g\n", prefix, atts->GetDefaultValue());
    str += tmpStr;
    if(atts->GetDistributedResample())
        SNPRINTF(tmpStr, 1000, "%sdistributedResample = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdistributedResample = 0\n", prefix);
    str += tmpStr;
    if(atts->GetCellCenteredOutput())
        SNPRINTF(tmpStr, 1000, "%scellCenteredOutput = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scellCenteredOutput = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
ResampleAttributes_Notify(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_SetUseExtents(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useExtents in the object.
    obj->data->SetUseExtents(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetUseExtents(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseExtents()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetStartX(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startX in the object.
    obj->data->SetStartX(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetStartX(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartX());
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetEndX(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endX in the object.
    obj->data->SetEndX(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetEndX(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndX());
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetSamplesX(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the samplesX in the object.
    obj->data->SetSamplesX((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetSamplesX(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSamplesX()));
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetStartY(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startY in the object.
    obj->data->SetStartY(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetStartY(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartY());
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetEndY(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endY in the object.
    obj->data->SetEndY(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetEndY(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndY());
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetSamplesY(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the samplesY in the object.
    obj->data->SetSamplesY((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetSamplesY(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSamplesY()));
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetIs3D(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the is3D in the object.
    obj->data->SetIs3D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetIs3D(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIs3D()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetStartZ(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startZ in the object.
    obj->data->SetStartZ(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetStartZ(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartZ());
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetEndZ(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endZ in the object.
    obj->data->SetEndZ(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetEndZ(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndZ());
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetSamplesZ(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the samplesZ in the object.
    obj->data->SetSamplesZ((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetSamplesZ(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSamplesZ()));
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetTieResolver(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the tieResolver in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetTieResolver(ResampleAttributes::TieResolver(ival));
    else
    {
        fprintf(stderr, "An invalid tieResolver value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "random, largest, smallest.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetTieResolver(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTieResolver()));
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetTieResolverVariable(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the tieResolverVariable in the object.
    obj->data->SetTieResolverVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetTieResolverVariable(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTieResolverVariable().c_str());
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetDefaultValue(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the defaultValue in the object.
    obj->data->SetDefaultValue(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetDefaultValue(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDefaultValue());
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetDistributedResample(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the distributedResample in the object.
    obj->data->SetDistributedResample(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetDistributedResample(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDistributedResample()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ResampleAttributes_SetCellCenteredOutput(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cellCenteredOutput in the object.
    obj->data->SetCellCenteredOutput(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ResampleAttributes_GetCellCenteredOutput(PyObject *self, PyObject *args)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCellCenteredOutput()?1L:0L);
    return retval;
}



PyMethodDef PyResampleAttributes_methods[RESAMPLEATTRIBUTES_NMETH] = {
    {"Notify", ResampleAttributes_Notify, METH_VARARGS},
    {"SetUseExtents", ResampleAttributes_SetUseExtents, METH_VARARGS},
    {"GetUseExtents", ResampleAttributes_GetUseExtents, METH_VARARGS},
    {"SetStartX", ResampleAttributes_SetStartX, METH_VARARGS},
    {"GetStartX", ResampleAttributes_GetStartX, METH_VARARGS},
    {"SetEndX", ResampleAttributes_SetEndX, METH_VARARGS},
    {"GetEndX", ResampleAttributes_GetEndX, METH_VARARGS},
    {"SetSamplesX", ResampleAttributes_SetSamplesX, METH_VARARGS},
    {"GetSamplesX", ResampleAttributes_GetSamplesX, METH_VARARGS},
    {"SetStartY", ResampleAttributes_SetStartY, METH_VARARGS},
    {"GetStartY", ResampleAttributes_GetStartY, METH_VARARGS},
    {"SetEndY", ResampleAttributes_SetEndY, METH_VARARGS},
    {"GetEndY", ResampleAttributes_GetEndY, METH_VARARGS},
    {"SetSamplesY", ResampleAttributes_SetSamplesY, METH_VARARGS},
    {"GetSamplesY", ResampleAttributes_GetSamplesY, METH_VARARGS},
    {"SetIs3D", ResampleAttributes_SetIs3D, METH_VARARGS},
    {"GetIs3D", ResampleAttributes_GetIs3D, METH_VARARGS},
    {"SetStartZ", ResampleAttributes_SetStartZ, METH_VARARGS},
    {"GetStartZ", ResampleAttributes_GetStartZ, METH_VARARGS},
    {"SetEndZ", ResampleAttributes_SetEndZ, METH_VARARGS},
    {"GetEndZ", ResampleAttributes_GetEndZ, METH_VARARGS},
    {"SetSamplesZ", ResampleAttributes_SetSamplesZ, METH_VARARGS},
    {"GetSamplesZ", ResampleAttributes_GetSamplesZ, METH_VARARGS},
    {"SetTieResolver", ResampleAttributes_SetTieResolver, METH_VARARGS},
    {"GetTieResolver", ResampleAttributes_GetTieResolver, METH_VARARGS},
    {"SetTieResolverVariable", ResampleAttributes_SetTieResolverVariable, METH_VARARGS},
    {"GetTieResolverVariable", ResampleAttributes_GetTieResolverVariable, METH_VARARGS},
    {"SetDefaultValue", ResampleAttributes_SetDefaultValue, METH_VARARGS},
    {"GetDefaultValue", ResampleAttributes_GetDefaultValue, METH_VARARGS},
    {"SetDistributedResample", ResampleAttributes_SetDistributedResample, METH_VARARGS},
    {"GetDistributedResample", ResampleAttributes_GetDistributedResample, METH_VARARGS},
    {"SetCellCenteredOutput", ResampleAttributes_SetCellCenteredOutput, METH_VARARGS},
    {"GetCellCenteredOutput", ResampleAttributes_GetCellCenteredOutput, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ResampleAttributes_dealloc(PyObject *v)
{
   ResampleAttributesObject *obj = (ResampleAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ResampleAttributes_compare(PyObject *v, PyObject *w)
{
    ResampleAttributes *a = ((ResampleAttributesObject *)v)->data;
    ResampleAttributes *b = ((ResampleAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyResampleAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "useExtents") == 0)
        return ResampleAttributes_GetUseExtents(self, NULL);
    if(strcmp(name, "startX") == 0)
        return ResampleAttributes_GetStartX(self, NULL);
    if(strcmp(name, "endX") == 0)
        return ResampleAttributes_GetEndX(self, NULL);
    if(strcmp(name, "samplesX") == 0)
        return ResampleAttributes_GetSamplesX(self, NULL);
    if(strcmp(name, "startY") == 0)
        return ResampleAttributes_GetStartY(self, NULL);
    if(strcmp(name, "endY") == 0)
        return ResampleAttributes_GetEndY(self, NULL);
    if(strcmp(name, "samplesY") == 0)
        return ResampleAttributes_GetSamplesY(self, NULL);
    if(strcmp(name, "is3D") == 0)
        return ResampleAttributes_GetIs3D(self, NULL);
    if(strcmp(name, "startZ") == 0)
        return ResampleAttributes_GetStartZ(self, NULL);
    if(strcmp(name, "endZ") == 0)
        return ResampleAttributes_GetEndZ(self, NULL);
    if(strcmp(name, "samplesZ") == 0)
        return ResampleAttributes_GetSamplesZ(self, NULL);
    if(strcmp(name, "tieResolver") == 0)
        return ResampleAttributes_GetTieResolver(self, NULL);
    if(strcmp(name, "random") == 0)
        return PyInt_FromLong(long(ResampleAttributes::random));
    if(strcmp(name, "largest") == 0)
        return PyInt_FromLong(long(ResampleAttributes::largest));
    if(strcmp(name, "smallest") == 0)
        return PyInt_FromLong(long(ResampleAttributes::smallest));

    if(strcmp(name, "tieResolverVariable") == 0)
        return ResampleAttributes_GetTieResolverVariable(self, NULL);
    if(strcmp(name, "defaultValue") == 0)
        return ResampleAttributes_GetDefaultValue(self, NULL);
    if(strcmp(name, "distributedResample") == 0)
        return ResampleAttributes_GetDistributedResample(self, NULL);
    if(strcmp(name, "cellCenteredOutput") == 0)
        return ResampleAttributes_GetCellCenteredOutput(self, NULL);

    return Py_FindMethod(PyResampleAttributes_methods, self, name);
}

int
PyResampleAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "useExtents") == 0)
        obj = ResampleAttributes_SetUseExtents(self, tuple);
    else if(strcmp(name, "startX") == 0)
        obj = ResampleAttributes_SetStartX(self, tuple);
    else if(strcmp(name, "endX") == 0)
        obj = ResampleAttributes_SetEndX(self, tuple);
    else if(strcmp(name, "samplesX") == 0)
        obj = ResampleAttributes_SetSamplesX(self, tuple);
    else if(strcmp(name, "startY") == 0)
        obj = ResampleAttributes_SetStartY(self, tuple);
    else if(strcmp(name, "endY") == 0)
        obj = ResampleAttributes_SetEndY(self, tuple);
    else if(strcmp(name, "samplesY") == 0)
        obj = ResampleAttributes_SetSamplesY(self, tuple);
    else if(strcmp(name, "is3D") == 0)
        obj = ResampleAttributes_SetIs3D(self, tuple);
    else if(strcmp(name, "startZ") == 0)
        obj = ResampleAttributes_SetStartZ(self, tuple);
    else if(strcmp(name, "endZ") == 0)
        obj = ResampleAttributes_SetEndZ(self, tuple);
    else if(strcmp(name, "samplesZ") == 0)
        obj = ResampleAttributes_SetSamplesZ(self, tuple);
    else if(strcmp(name, "tieResolver") == 0)
        obj = ResampleAttributes_SetTieResolver(self, tuple);
    else if(strcmp(name, "tieResolverVariable") == 0)
        obj = ResampleAttributes_SetTieResolverVariable(self, tuple);
    else if(strcmp(name, "defaultValue") == 0)
        obj = ResampleAttributes_SetDefaultValue(self, tuple);
    else if(strcmp(name, "distributedResample") == 0)
        obj = ResampleAttributes_SetDistributedResample(self, tuple);
    else if(strcmp(name, "cellCenteredOutput") == 0)
        obj = ResampleAttributes_SetCellCenteredOutput(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ResampleAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)v;
    fprintf(fp, "%s", PyResampleAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ResampleAttributes_str(PyObject *v)
{
    ResampleAttributesObject *obj = (ResampleAttributesObject *)v;
    return PyString_FromString(PyResampleAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ResampleAttributes_Purpose = "Atts for Resample operator";
#else
static char *ResampleAttributes_Purpose = "Atts for Resample operator";
#endif

//
// The type description structure
//
static PyTypeObject ResampleAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ResampleAttributes",                    // tp_name
    sizeof(ResampleAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ResampleAttributes_dealloc,  // tp_dealloc
    (printfunc)ResampleAttributes_print,     // tp_print
    (getattrfunc)PyResampleAttributes_getattr, // tp_getattr
    (setattrfunc)PyResampleAttributes_setattr, // tp_setattr
    (cmpfunc)ResampleAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ResampleAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ResampleAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ResampleAttributes *defaultAtts = 0;
static ResampleAttributes *currentAtts = 0;

static PyObject *
NewResampleAttributes(int useCurrent)
{
    ResampleAttributesObject *newObject;
    newObject = PyObject_NEW(ResampleAttributesObject, &ResampleAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ResampleAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ResampleAttributes(*defaultAtts);
    else
        newObject->data = new ResampleAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapResampleAttributes(const ResampleAttributes *attr)
{
    ResampleAttributesObject *newObject;
    newObject = PyObject_NEW(ResampleAttributesObject, &ResampleAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ResampleAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ResampleAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewResampleAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ResampleAttributesMethods[] = {
    {"ResampleAttributes", ResampleAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ResampleAttributesObserver = 0;

std::string
PyResampleAttributes_GetLogString()
{
    std::string s("ResampleAtts = ResampleAttributes()\n");
    if(currentAtts != 0)
        s += PyResampleAttributes_ToString(currentAtts, "ResampleAtts.");
    return s;
}

static void
PyResampleAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ResampleAtts = ResampleAttributes()\n");
        s += PyResampleAttributes_ToString(currentAtts, "ResampleAtts.");
        cb(s);
    }
}

void
PyResampleAttributes_StartUp(ResampleAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyResampleAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ResampleAttributesObserver == 0)
    {
        ResampleAttributesObserver = new ObserverToCallback(subj,
            PyResampleAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyResampleAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ResampleAttributesObserver;
    ResampleAttributesObserver = 0;
}

PyMethodDef *
PyResampleAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ResampleAttributesMethods;
}

bool
PyResampleAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ResampleAttributesType);
}

ResampleAttributes *
PyResampleAttributes_FromPyObject(PyObject *obj)
{
    ResampleAttributesObject *obj2 = (ResampleAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyResampleAttributes_New()
{
    return NewResampleAttributes(0);
}

PyObject *
PyResampleAttributes_Wrap(const ResampleAttributes *attr)
{
    return WrapResampleAttributes(attr);
}

void
PyResampleAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ResampleAttributesObject *obj2 = (ResampleAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyResampleAttributes_SetDefaults(const ResampleAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ResampleAttributes(*atts);
}

