/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisFluxWindow.h"

#include <FluxAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QvisVariableButton.h>


// ****************************************************************************
// Method: QvisFluxWindow::QvisFluxWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisFluxWindow::QvisFluxWindow(const int type,
                         FluxAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisFluxWindow::~QvisFluxWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisFluxWindow::~QvisFluxWindow()
{
}


// ****************************************************************************
// Method: QvisFluxWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisFluxWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    flowFieldLabel = new QLabel(tr("Flow field"), central);
    mainLayout->addWidget(flowFieldLabel,0,0);
    int flowFieldMask = QvisVariableButton::Vectors;
    flowField = new QvisVariableButton(true, true, true, flowFieldMask, central);
    connect(flowField, SIGNAL(activated(const QString&)),
            this, SLOT(flowFieldChanged(const QString&)));
    mainLayout->addWidget(flowField, 0,1);

    weight = new QCheckBox(tr("Multiply dot product by a scalar variable?"), central);
    connect(weight, SIGNAL(toggled(bool)),
            this, SLOT(weightChanged(bool)));
    mainLayout->addWidget(weight, 1,0);

    weightFieldLabel = new QLabel(tr("Weight field"), central);
    mainLayout->addWidget(weightFieldLabel,2,0);
    int weightFieldMask = QvisVariableButton::Scalars;
    weightField = new QvisVariableButton(true, true, true, weightFieldMask, central);
    connect(weightField, SIGNAL(activated(const QString&)),
            this, SLOT(weightFieldChanged(const QString&)));
    mainLayout->addWidget(weightField, 2,1);

}


// ****************************************************************************
// Method: QvisFluxWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisFluxWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case FluxAttributes::ID_flowField:
            flowField->blockSignals(true);
            flowField->setText(QString(atts->GetFlowField().c_str()));
            flowField->blockSignals(false);
            break;
          case FluxAttributes::ID_weight:
            if (atts->GetWeight() == true)
            {
                weightField->setEnabled(true);
                if(weightFieldLabel)
                    weightFieldLabel->setEnabled(true);
            }
            else
            {
                weightField->setEnabled(false);
                if(weightFieldLabel)
                    weightFieldLabel->setEnabled(false);
            }
            weight->blockSignals(true);
            weight->setChecked(atts->GetWeight());
            weight->blockSignals(false);
            break;
          case FluxAttributes::ID_weightField:
            weightField->blockSignals(true);
            weightField->setText(QString(atts->GetWeightField().c_str()));
            weightField->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisFluxWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisFluxWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisFluxWindow::flowFieldChanged(const QString &varName)
{
    atts->SetFlowField(varName.toStdString());
    SetUpdate(false);
    Apply();
}


void
QvisFluxWindow::weightChanged(bool val)
{
    atts->SetWeight(val);
    Apply();
}


void
QvisFluxWindow::weightFieldChanged(const QString &varName)
{
    atts->SetWeightField(varName.toStdString());
    SetUpdate(false);
    Apply();
}


