/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ExtrudeAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ExtrudeAttributes::ExtrudeAttributes
//
// Purpose: 
//   Init utility for the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ExtrudeAttributes::Init()
{
    axis[0] = 0;
    axis[1] = 0;
    axis[2] = 1;
    length = 1;
    steps = 30;
    preserveOriginalCellNumbers = true;

    ExtrudeAttributes::SelectAll();
}

// ****************************************************************************
// Method: ExtrudeAttributes::ExtrudeAttributes
//
// Purpose: 
//   Copy utility for the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ExtrudeAttributes::Copy(const ExtrudeAttributes &obj)
{
    axis[0] = obj.axis[0];
    axis[1] = obj.axis[1];
    axis[2] = obj.axis[2];

    length = obj.length;
    steps = obj.steps;
    preserveOriginalCellNumbers = obj.preserveOriginalCellNumbers;

    ExtrudeAttributes::SelectAll();
}

// Type map format string
const char *ExtrudeAttributes::TypeMapFormatString = EXTRUDEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ExtrudeAttributes::TmfsStruct = {EXTRUDEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ExtrudeAttributes::ExtrudeAttributes
//
// Purpose: 
//   Default constructor for the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ExtrudeAttributes::ExtrudeAttributes() : 
    AttributeSubject(ExtrudeAttributes::TypeMapFormatString)
{
    ExtrudeAttributes::Init();
}

// ****************************************************************************
// Method: ExtrudeAttributes::ExtrudeAttributes
//
// Purpose: 
//   Constructor for the derived classes of ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ExtrudeAttributes::ExtrudeAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ExtrudeAttributes::Init();
}

// ****************************************************************************
// Method: ExtrudeAttributes::ExtrudeAttributes
//
// Purpose: 
//   Copy constructor for the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ExtrudeAttributes::ExtrudeAttributes(const ExtrudeAttributes &obj) : 
    AttributeSubject(ExtrudeAttributes::TypeMapFormatString)
{
    ExtrudeAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ExtrudeAttributes::ExtrudeAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ExtrudeAttributes::ExtrudeAttributes(const ExtrudeAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ExtrudeAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ExtrudeAttributes::~ExtrudeAttributes
//
// Purpose: 
//   Destructor for the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ExtrudeAttributes::~ExtrudeAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ExtrudeAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ExtrudeAttributes& 
ExtrudeAttributes::operator = (const ExtrudeAttributes &obj)
{
    if (this == &obj) return *this;

    ExtrudeAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ExtrudeAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ExtrudeAttributes::operator == (const ExtrudeAttributes &obj) const
{
    // Compare the axis arrays.
    bool axis_equal = true;
    for(int i = 0; i < 3 && axis_equal; ++i)
        axis_equal = (axis[i] == obj.axis[i]);

    // Create the return value
    return (axis_equal &&
            (length == obj.length) &&
            (steps == obj.steps) &&
            (preserveOriginalCellNumbers == obj.preserveOriginalCellNumbers));
}

// ****************************************************************************
// Method: ExtrudeAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ExtrudeAttributes::operator != (const ExtrudeAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ExtrudeAttributes::TypeName
//
// Purpose: 
//   Type name method for the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ExtrudeAttributes::TypeName() const
{
    return "ExtrudeAttributes";
}

// ****************************************************************************
// Method: ExtrudeAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ExtrudeAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ExtrudeAttributes *tmp = (const ExtrudeAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ExtrudeAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ExtrudeAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ExtrudeAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ExtrudeAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ExtrudeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ExtrudeAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ExtrudeAttributes(*this);
    else
        retval = new ExtrudeAttributes;

    return retval;
}

// ****************************************************************************
// Method: ExtrudeAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ExtrudeAttributes::SelectAll()
{
    Select(ID_axis,                        (void *)axis, 3);
    Select(ID_length,                      (void *)&length);
    Select(ID_steps,                       (void *)&steps);
    Select(ID_preserveOriginalCellNumbers, (void *)&preserveOriginalCellNumbers);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ExtrudeAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ExtrudeAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ExtrudeAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ExtrudeAttributes.
    DataNode *node = new DataNode("ExtrudeAttributes");

    if(completeSave || !FieldsEqual(ID_axis, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axis", axis, 3));
    }

    if(completeSave || !FieldsEqual(ID_length, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("length", length));
    }

    if(completeSave || !FieldsEqual(ID_steps, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("steps", steps));
    }

    if(completeSave || !FieldsEqual(ID_preserveOriginalCellNumbers, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("preserveOriginalCellNumbers", preserveOriginalCellNumbers));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ExtrudeAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ExtrudeAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ExtrudeAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("axis")) != 0)
        SetAxis(node->AsDoubleArray());
    if((node = searchNode->GetNode("length")) != 0)
        SetLength(node->AsDouble());
    if((node = searchNode->GetNode("steps")) != 0)
        SetSteps(node->AsInt());
    if((node = searchNode->GetNode("preserveOriginalCellNumbers")) != 0)
        SetPreserveOriginalCellNumbers(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ExtrudeAttributes::SetAxis(const double *axis_)
{
    axis[0] = axis_[0];
    axis[1] = axis_[1];
    axis[2] = axis_[2];
    Select(ID_axis, (void *)axis, 3);
}

void
ExtrudeAttributes::SetLength(double length_)
{
    length = length_;
    Select(ID_length, (void *)&length);
}

void
ExtrudeAttributes::SetSteps(int steps_)
{
    steps = steps_;
    Select(ID_steps, (void *)&steps);
}

void
ExtrudeAttributes::SetPreserveOriginalCellNumbers(bool preserveOriginalCellNumbers_)
{
    preserveOriginalCellNumbers = preserveOriginalCellNumbers_;
    Select(ID_preserveOriginalCellNumbers, (void *)&preserveOriginalCellNumbers);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
ExtrudeAttributes::GetAxis() const
{
    return axis;
}

double *
ExtrudeAttributes::GetAxis()
{
    return axis;
}

double
ExtrudeAttributes::GetLength() const
{
    return length;
}

int
ExtrudeAttributes::GetSteps() const
{
    return steps;
}

bool
ExtrudeAttributes::GetPreserveOriginalCellNumbers() const
{
    return preserveOriginalCellNumbers;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ExtrudeAttributes::SelectAxis()
{
    Select(ID_axis, (void *)axis, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ExtrudeAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ExtrudeAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_axis:                        return "axis";
    case ID_length:                      return "length";
    case ID_steps:                       return "steps";
    case ID_preserveOriginalCellNumbers: return "preserveOriginalCellNumbers";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ExtrudeAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ExtrudeAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_axis:                        return FieldType_doubleArray;
    case ID_length:                      return FieldType_double;
    case ID_steps:                       return FieldType_int;
    case ID_preserveOriginalCellNumbers: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ExtrudeAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ExtrudeAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_axis:                        return "doubleArray";
    case ID_length:                      return "double";
    case ID_steps:                       return "int";
    case ID_preserveOriginalCellNumbers: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ExtrudeAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ExtrudeAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ExtrudeAttributes &obj = *((const ExtrudeAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_axis:
        {  // new scope
        // Compare the axis arrays.
        bool axis_equal = true;
        for(int i = 0; i < 3 && axis_equal; ++i)
            axis_equal = (axis[i] == obj.axis[i]);

        retval = axis_equal;
        }
        break;
    case ID_length:
        {  // new scope
        retval = (length == obj.length);
        }
        break;
    case ID_steps:
        {  // new scope
        retval = (steps == obj.steps);
        }
        break;
    case ID_preserveOriginalCellNumbers:
        {  // new scope
        retval = (preserveOriginalCellNumbers == obj.preserveOriginalCellNumbers);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

