/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisEllipsoidSliceWindow.h"

#include <EllipsoidSliceAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisEllipsoidSliceWindow::QvisEllipsoidSliceWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisEllipsoidSliceWindow::QvisEllipsoidSliceWindow(const int type,
                         EllipsoidSliceAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisEllipsoidSliceWindow::~QvisEllipsoidSliceWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisEllipsoidSliceWindow::~QvisEllipsoidSliceWindow()
{
}


// ****************************************************************************
// Method: QvisEllipsoidSliceWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisEllipsoidSliceWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    originLabel = new QLabel(tr("Origin"), central);
    mainLayout->addWidget(originLabel,0,0);
    origin = new QLineEdit(central);
    connect(origin, SIGNAL(returnPressed()),
            this, SLOT(originProcessText()));
    mainLayout->addWidget(origin, 0,1);

    radiiLabel = new QLabel(tr("Radii"), central);
    mainLayout->addWidget(radiiLabel,1,0);
    radii = new QLineEdit(central);
    connect(radii, SIGNAL(returnPressed()),
            this, SLOT(radiiProcessText()));
    mainLayout->addWidget(radii, 1,1);

    rotationAngleLabel = new QLabel(tr("Rotation Angle"), central);
    mainLayout->addWidget(rotationAngleLabel,2,0);
    rotationAngle = new QLineEdit(central);
    connect(rotationAngle, SIGNAL(returnPressed()),
            this, SLOT(rotationAngleProcessText()));
    mainLayout->addWidget(rotationAngle, 2,1);

}


// ****************************************************************************
// Method: QvisEllipsoidSliceWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisEllipsoidSliceWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case EllipsoidSliceAttributes::ID_origin:
            origin->setText(DoublesToQString(atts->GetOrigin(), 3));
            break;
          case EllipsoidSliceAttributes::ID_radii:
            radii->setText(DoublesToQString(atts->GetRadii(), 3));
            break;
          case EllipsoidSliceAttributes::ID_rotationAngle:
            rotationAngle->setText(DoublesToQString(atts->GetRotationAngle(), 3));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisEllipsoidSliceWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisEllipsoidSliceWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do origin
    if(which_widget == EllipsoidSliceAttributes::ID_origin || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(origin, val, 3))
            atts->SetOrigin(val);
        else
        {
            ResettingError(tr("Origin"),
                DoublesToQString(atts->GetOrigin(),3));
            atts->SetOrigin(atts->GetOrigin());
        }
    }

    // Do radii
    if(which_widget == EllipsoidSliceAttributes::ID_radii || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(radii, val, 3))
            atts->SetRadii(val);
        else
        {
            ResettingError(tr("Radii"),
                DoublesToQString(atts->GetRadii(),3));
            atts->SetRadii(atts->GetRadii());
        }
    }

    // Do rotationAngle
    if(which_widget == EllipsoidSliceAttributes::ID_rotationAngle || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(rotationAngle, val, 3))
            atts->SetRotationAngle(val);
        else
        {
            ResettingError(tr("Rotation Angle"),
                DoublesToQString(atts->GetRotationAngle(),3));
            atts->SetRotationAngle(atts->GetRotationAngle());
        }
    }

}


//
// Qt Slot functions
//


void
QvisEllipsoidSliceWindow::originProcessText()
{
    GetCurrentValues(EllipsoidSliceAttributes::ID_origin);
    Apply();
}


void
QvisEllipsoidSliceWindow::radiiProcessText()
{
    GetCurrentValues(EllipsoidSliceAttributes::ID_radii);
    Apply();
}


void
QvisEllipsoidSliceWindow::rotationAngleProcessText()
{
    GetCurrentValues(EllipsoidSliceAttributes::ID_rotationAngle);
    Apply();
}


