/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/
    
#include <QvisPredefinedViewports.h>
#include <QPixmap>
#include <QMenu>

/* XPM */
static const char * vicon_00_xpm[] = {
"60 40 2 1",
".    c #000000",
"+    c #DDDDDD",
"............................................................",
"............................................................",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"............................................................",
"............................................................"};

/* XPM */
static const char * vicon_01_xpm[] = {
"60 40 2 1",
".    c #000000",
"+    c #DDDDDD",
"............................................................",
"............................................................",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"............................................................",
"............................................................"};

/* XPM */
static const char * vicon_02_xpm[] = {
"60 40 2 1",
".    c #000000",
"+    c #DDDDDD",
"............................................................",
"............................................................",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"............................................................",
"............................................................",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"............................................................",
"............................................................"};

/* XPM */
static const char * vicon_03_xpm[] = {
"60 40 2 1",
".    c #000000",
"+    c #DDDDDD",
"............................................................",
"............................................................",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"............................................................",
"............................................................"};

/* XPM */
static const char * vicon_04_xpm[] = {
"60 40 2 1",
".    c #000000",
"+    c #DDDDDD",
"............................................................",
"............................................................",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"............................................................",
"............................................................"};

/* XPM */
static const char * vicon_05_xpm[] = {
"60 40 2 1",
".    c #000000",
"+    c #DDDDDD",
"............................................................",
"............................................................",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++..................++++..++++..................++++..",
"..++++++..................++++..++++..................++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..................++++..++++..................++++..",
"..++++++..................++++..++++..................++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"............................................................",
"............................................................"};


// ****************************************************************************
// Method: QvisPredefinedViewports::QvisPredefinedViewports
//
// Purpose: 
//   Constructor.
//
// Programmer: Brad Whitlock
// Creation:   Mon Oct 2 18:09:33 PST 2006
//
// Modifications:
//   Brad Whitlock, Tue Apr  8 15:26:49 PDT 2008
//   Support for internationalization.
//
//   Brad Whitlock, Tue Oct  7 10:28:20 PDT 2008
//   Qt 4.
//
// ****************************************************************************

QvisPredefinedViewports::QvisPredefinedViewports(QWidget *parent) : QPushButton(parent)
{
    setText("Layouts");

    // Insert items.
    menu = new QMenu(0);
    menu->addAction(QIcon(QPixmap(vicon_00_xpm)), tr("Single"));
    menu->addAction(QIcon(QPixmap(vicon_01_xpm)), tr("Side by side"));
    menu->addAction(QIcon(QPixmap(vicon_02_xpm)), tr("Two by Two"));
    menu->addAction(QIcon(QPixmap(vicon_03_xpm)), tr("Picture in picture 1"));
    menu->addAction(QIcon(QPixmap(vicon_04_xpm)), tr("Picture in picture 2"));
    menu->addAction(QIcon(QPixmap(vicon_05_xpm)), tr("2x Picture in picture"));
    setMenu(menu);
    connect(menu, SIGNAL(triggered(QAction*)),
            this, SLOT(emitActivated(QAction*)));
}

// ****************************************************************************
// Method: QvisPredefinedViewports::~QvisPredefinedViewports
//
// Purpose: 
//   Destructor.
//
// Programmer: Brad Whitlock
// Creation:   Mon Oct 2 18:09:49 PST 2006
//
// Modifications:
//   
// ****************************************************************************

QvisPredefinedViewports::~QvisPredefinedViewports()
{
    delete menu;
}

// ****************************************************************************
// Method: QvisPredefinedViewports::emitActivated
//
// Purpose: 
//   Emits the activated signal with the index of the activated action.
//
// Arguments:
//   a : The action that was triggered.
//
// Programmer: Brad Whitlock
// Creation:   Tue Oct  7 10:26:10 PDT 2008
//
// Modifications:
//   
// ****************************************************************************

void
QvisPredefinedViewports::emitActivated(QAction *a)
{
    emit activated(menu->actions().indexOf(a));
}
